/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.tpp.util;

import java.io.File;
import java.io.InputStream;
import java.io.Writer;
import java.util.concurrent.TimeoutException;

public class CommandRunner {
    private int timeoutSecs;
    private ProcessBuilder builder;
    private Writer writer;

    public CommandRunner(String string, String string2, int n) {
        File file = new File(string2);
        file.mkdirs();
        this.builder = new ProcessBuilder("/bin/sh", "-c", string);
        this.builder.directory(file);
        this.builder.redirectErrorStream(true);
        this.timeoutSecs = n;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public int run() throws Exception {
        long l = System.currentTimeMillis() + (long)(this.timeoutSecs * 1000);
        Process process = this.builder.start();
        InputStream inputStream = process.getInputStream();
        while (CommandRunner.isAlive(process) && System.currentTimeMillis() < l) {
            this.dumpOutput(inputStream);
            this.sleep(200L);
        }
        if (CommandRunner.isAlive(process)) {
            process.destroy();
            throw new TimeoutException();
        }
        this.dumpOutput(inputStream);
        return process.exitValue();
    }

    private void dumpOutput(InputStream inputStream) throws Exception {
        int n = inputStream.available();
        if (n <= 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            int n2 = inputStream.read();
            if (this.writer == null) continue;
            this.writer.write(n2);
        }
    }

    private void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static boolean isAlive(Process process) {
        try {
            process.exitValue();
            return false;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return true;
        }
    }
}

