/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.tpp.util;

import com.ericsson.tpp.util.Wildcard;
import java.io.File;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Configuration {
    private String dataDir;
    private String reportDir;
    private Set<String> rpmDirs = new TreeSet<String>();
    private Set<Wildcard> wlWildcard;
    private ConfigHandler saxHandler = new ConfigHandler(this);

    public Configuration() {
        this.wlWildcard = new TreeSet<Wildcard>();
    }

    private void clear() {
        this.dataDir = null;
        this.reportDir = null;
        this.rpmDirs.clear();
    }

    public void load(File file) throws Exception {
        this.load(file.getAbsolutePath());
    }

    public void load(String string) throws Exception {
        this.clear();
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        sAXParser.parse(string, (DefaultHandler)this.saxHandler);
        this.validate();
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public String getReportDir() {
        return this.reportDir;
    }

    public Set<String> getRpmDirs() {
        return this.rpmDirs;
    }

    private void validate() throws Exception {
        if (this.dataDir == null) {
            throw new Exception("Configuration error: Missing data directory.");
        }
        if (this.reportDir == null) {
            throw new Exception("Configuration error: Missing report directory.");
        }
        if (this.rpmDirs.isEmpty()) {
            throw new Exception("Configuration error: Missing RPM folder(s).");
        }
    }

    public boolean whiteList(String string) {
        if (string == null) {
            return false;
        }
        for (Wildcard wildcard : this.wlWildcard) {
            if (!wildcard.matches(string)) continue;
            return true;
        }
        return false;
    }

    private static class ConfigHandler
    extends DefaultHandler {
        private Configuration cfg;

        public ConfigHandler(Configuration configuration) {
            this.cfg = configuration;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            String string4;
            if ("dataDir".equals(string3)) {
                String string5 = attributes.getValue("path");
                if (string5 != null) {
                    this.cfg.dataDir = string5;
                }
            } else if ("reportDir".equals(string3)) {
                String string6 = attributes.getValue("path");
                if (string6 != null) {
                    this.cfg.reportDir = string6;
                }
            } else if ("rpmDir".equals(string3)) {
                String string7 = attributes.getValue("path");
                if (string7 != null) {
                    this.cfg.rpmDirs.add(string7);
                }
            } else if ("fileName".equals(string3) && (string4 = attributes.getValue("wildcard")) != null) {
                this.cfg.wlWildcard.add(new Wildcard(string4));
            }
        }
    }
}

