/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.tpp.util;

import com.ericsson.tpp.RpmInfo;
import com.ericsson.tpp.util.CommandRunner;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FileUtils {
    private static byte[] copyBuf = new byte[10240];

    private FileUtils() {
    }

    public static String getRelativePath(File file, File file2) {
        String string = "";
        String string2 = file2.getParent();
        String string3 = file.getAbsolutePath();
        if (string2 != null && string2.length() >= string3.length()) {
            string = string2.substring(string3.length());
        }
        return string;
    }

    public static RpmInfo getRpmInfo(File file) throws Exception {
        StringWriter stringWriter = new StringWriter();
        String string = "rpm -qp --nosignature --qf '%{NAME},%{VERSION},%{VENDOR},%{LICENSE},%{URL}' " + file;
        CommandRunner commandRunner = new CommandRunner(string, "/tmp", 30);
        commandRunner.setWriter(stringWriter);
        int n = commandRunner.run();
        if (n != 0) {
            throw new Exception("Could not get RPM info: " + stringWriter.getBuffer().toString());
        }
        String string2 = stringWriter.getBuffer().toString();
        String[] stringArray = string2.split(",");
        RpmInfo rpmInfo = new RpmInfo(file);
        rpmInfo.name = stringArray[0];
        rpmInfo.version = stringArray[1];
        rpmInfo.vendor = stringArray[2];
        rpmInfo.license = stringArray[3];
        rpmInfo.url = stringArray[4];
        return rpmInfo;
    }

    public static void deleteDir(File file) throws Exception {
        FileUtils.deleteDir(file.getAbsolutePath());
    }

    public static void deleteDir(String string) throws Exception {
        CommandRunner commandRunner = new CommandRunner("rm -Rf " + string, "/tmp", 30);
        int n = commandRunner.run();
        if (n != 0) {
            throw new Exception("Could not delete temp dir: " + string);
        }
    }

    public static void extractRpm(String string, String string2) throws Exception {
        String string3 = "rpm2cpio " + string + " | cpio -id \"*.[e,E,j,J,w,W][a,A][r,R]\"";
        CommandRunner commandRunner = new CommandRunner(string3, string2, 300);
        int n = commandRunner.run();
        if (n != 0) {
            throw new Exception("Could not extract RPM " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractJavaArchive(String string, String string2) throws Exception {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(string);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String string3 = zipEntry.getName().toLowerCase();
                if (!string3.endsWith(".jar") && !string3.endsWith(".war") && !string3.endsWith(".ear")) continue;
                FileUtils.extractFile(zipFile, zipEntry, string2);
            }
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractFile(ZipFile zipFile, ZipEntry zipEntry, String string) throws Exception {
        File file = new File(string, zipEntry.getName());
        file.getParentFile().mkdirs();
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            int n;
            inputStream = zipFile.getInputStream(zipEntry);
            outputStream = new FileOutputStream(file);
            while ((n = inputStream.read(copyBuf)) > 0) {
                outputStream.write(copyBuf, 0, n);
            }
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Exception exception) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

