/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.tpp.util;

import com.ericsson.tpp.JarInfo;
import com.ericsson.tpp.util.Logger;
import java.io.File;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class JarUtils {
    private JarUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasNestedJars(File file) throws Exception {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(file);
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (true) {
                if (enumeration.hasMoreElements()) {
                    String string = enumeration.nextElement().getName().toLowerCase();
                    if (!string.endsWith(".jar")) continue;
                    boolean bl = true;
                    return bl;
                    continue;
                }
                break;
            }
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setJarInfo(File file, JarInfo jarInfo) throws Exception {
        Logger logger = Logger.getLogger();
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(file);
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) {
                logger.warn("Jar does not have a manifest: " + file.getAbsolutePath());
            } else {
                jarInfo.title = JarUtils.getValue(manifest, AttributeName.Title);
                jarInfo.version = JarUtils.getValue(manifest, AttributeName.Version);
                jarInfo.vendor = JarUtils.getValue(manifest, AttributeName.Vendor);
                jarInfo.url = JarUtils.getValue(manifest, AttributeName.Url);
            }
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static String getValue(Manifest manifest, AttributeName attributeName) {
        String string = JarUtils.getValue(manifest.getMainAttributes(), attributeName);
        if (string == null && manifest.getEntries() != null) {
            for (Attributes attributes : manifest.getEntries().values()) {
                string = JarUtils.getValue(attributes, attributeName);
                if (string == null) continue;
                return string;
            }
        }
        return string;
    }

    private static String getValue(Attributes attributes, AttributeName attributeName) {
        switch (attributeName) {
            case Title: {
                return JarUtils.getTitle(attributes);
            }
            case Version: {
                return JarUtils.getVersion(attributes);
            }
            case Vendor: {
                return JarUtils.getVendor(attributes);
            }
            case Url: {
                return JarUtils.getUrl(attributes);
            }
        }
        return null;
    }

    private static String getUrl(Attributes attributes) {
        String string = attributes.getValue("Implementation-URL");
        return string;
    }

    private static String getTitle(Attributes attributes) {
        String string = attributes.getValue("Implementation-Title");
        if (string == null && (string = attributes.getValue("Specification-Title")) == null) {
            string = attributes.getValue("Bundle-Description");
        }
        return string;
    }

    private static String getVersion(Attributes attributes) {
        String string = attributes.getValue("Bundle-Version");
        if (string == null && (string = attributes.getValue("Implementation-Version")) == null) {
            string = attributes.getValue("Specification-Version");
        }
        return string;
    }

    private static String getVendor(Attributes attributes) {
        String string = attributes.getValue("Bundle-Vendor");
        if (string == null && (string = attributes.getValue("Implementation-Vendor")) == null) {
            string = attributes.getValue("Specification-Vendor");
        }
        return string;
    }

    private static enum AttributeName {
        Title,
        Version,
        Vendor,
        Url;

    }
}

