/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.tpp.util;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;

public class JavaArchiveList {
    private List<File> jarList = new ArrayList<File>();
    private List<File> earList = new ArrayList<File>();
    private List<File> warList = new ArrayList<File>();
    private JavaFilter javaFilter = new JavaFilter();

    public void appendFilesInDir(String string) {
        this.appendFilesInDir(new File(string));
    }

    public void appendFilesInDir(File file) {
        File[] fileArray = file.listFiles(this.javaFilter);
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            if (file2.isDirectory()) {
                this.appendFilesInDir(file2);
                continue;
            }
            String string = file2.getName().toLowerCase();
            if (string.endsWith(".jar")) {
                this.jarList.add(file2);
                continue;
            }
            if (string.endsWith(".ear")) {
                this.earList.add(file2);
                continue;
            }
            if (!string.endsWith(".war")) continue;
            this.warList.add(file2);
        }
    }

    public void clear() {
        this.jarList.clear();
        this.earList.clear();
        this.warList.clear();
    }

    public List<File> getJars() {
        return this.jarList;
    }

    public List<File> getWars() {
        return this.warList;
    }

    public List<File> getEars() {
        return this.earList;
    }

    private static class JavaFilter
    implements FileFilter {
        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName().toLowerCase();
            return string.endsWith(".jar") || string.endsWith(".ear") || string.endsWith(".war");
        }
    }
}

