/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.tpp.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Logger {
    private static Logger instance = new Logger();
    private Writer writer;
    private Date date = new Date();
    private DateFormat df = new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss:SSS");

    private Logger() {
    }

    public void openLogFile(File file) throws Exception {
        File file2;
        if (this.writer != null) {
            this.closeLogFile();
        }
        if ((file2 = file.getParentFile()) != null) {
            file2.mkdirs();
        }
        this.writer = new BufferedWriter(new FileWriter(file));
    }

    public void closeLogFile() {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static Logger getLogger() {
        return instance;
    }

    public void info(String string) {
        this.write(Level.INFO, string);
    }

    public void warn(String string) {
        this.write(Level.WARN, string);
    }

    public void error(String string) {
        this.write(Level.ERROR, string);
    }

    private void write(Level level, String string) {
        this.date.setTime(System.currentTimeMillis());
        String string2 = this.df.format(this.date);
        this.writeToConsole(string2, level, string);
        this.writeToFile(string2, level, string);
    }

    private void writeToConsole(String string, Level level, String string2) {
        System.out.print(string);
        System.out.print(": ");
        switch (level) {
            case INFO: {
                System.out.print("INFO:  ");
                break;
            }
            case WARN: {
                System.out.print("WARN:  ");
                break;
            }
            case ERROR: {
                System.out.print("ERROR: ");
            }
        }
        System.out.println(string2);
    }

    private void writeToFile(String string, Level level, String string2) {
        if (this.writer != null) {
            try {
                this.writer.write(string);
                this.writer.write(": ");
                switch (level) {
                    case INFO: {
                        this.writer.write("INFO:  ");
                        break;
                    }
                    case WARN: {
                        this.writer.write("WARN:  ");
                        break;
                    }
                    case ERROR: {
                        this.writer.write("ERROR: ");
                    }
                }
                this.writer.write(string2);
                this.writer.write("\n");
                this.writer.flush();
            }
            catch (Exception exception) {
                System.out.println("Logger error: " + exception);
            }
        }
    }

    public static enum Level {
        INFO,
        WARN,
        ERROR;

    }
}

