/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.tpp.util;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;

public class RpmList {
    private List<File> list = new ArrayList<File>();
    private RpmFilter rpmFilter = new RpmFilter();

    public void appendFilesInDir(String string) {
        this.appendFilesInDir(new File(string));
    }

    public void appendFilesInDir(File file) {
        if (!file.exists()) {
            return;
        }
        File[] fileArray = file.listFiles(this.rpmFilter);
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            if (file2.isDirectory()) {
                this.appendFilesInDir(file2);
                continue;
            }
            this.list.add(file2);
        }
    }

    public void clear() {
        this.list.clear();
    }

    public List<File> getFiles() {
        return this.list;
    }

    private static class RpmFilter
    implements FileFilter {
        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return file.getName().toLowerCase().endsWith(".rpm");
        }
    }
}

