/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.tpp.util;

import com.ericsson.tpp.JarInfo;
import com.ericsson.tpp.RpmInfo;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import org.apache.commons.lang3.StringEscapeUtils;

public class XmlWriter {
    private Writer writer;

    public XmlWriter(File file) throws Exception {
        File file2 = file.getParentFile();
        if (file2 != null) {
            file2.mkdirs();
        }
        this.writer = new BufferedWriter(new FileWriter(file));
    }

    public void close() {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void writeRootStart(String string) throws Exception {
        this.writer.write("<rpms ");
        this.writeAttribute("timestamp", string);
        this.writer.write(">\n");
    }

    public void writeRootEnd() throws Exception {
        this.writer.write("</rpms>\n");
    }

    public void writeRpmStart(RpmInfo rpmInfo) throws Exception {
        this.writer.write("<rpm ");
        this.writeAttribute("file", rpmInfo.fileName);
        this.writeAttribute("dir", rpmInfo.dir);
        this.writeAttribute("vendor", rpmInfo.vendor);
        this.writeAttribute("name", rpmInfo.name);
        this.writeAttribute("version", rpmInfo.version);
        this.writeAttribute("url", rpmInfo.url);
        this.writeAttribute("license", rpmInfo.license);
        this.writer.write(">\n");
    }

    public void writeRpmEnd() throws Exception {
        this.writer.write("</rpm>\n");
    }

    public void writeJar(JarInfo jarInfo) throws Exception {
        this.writer.write("    <jar ");
        this.writeAttribute("file", jarInfo.fileName);
        this.writeAttribute("dir", jarInfo.dir);
        this.writeAttribute("title", jarInfo.title);
        this.writeAttribute("version", jarInfo.version);
        this.writeAttribute("vendor", jarInfo.vendor);
        this.writeAttribute("url", jarInfo.url);
        this.writer.write("/>\n");
    }

    private void writeAttribute(String string, String string2) throws Exception {
        if (string2 == null) {
            return;
        }
        string2 = string2.replace("\"", "");
        string2 = StringEscapeUtils.escapeXml((String)string2);
        this.writer.write(string + "=\"" + string2 + "\" ");
    }
}

