/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.cis;

import com.ericsson.cms.cis.CISConstants;
import com.ericsson.cms.cis.CISException;
import com.ericsson.cms.cis.CISServiceHelper;
import com.ericsson.cms.sites.core.entities.CISNotificationData;
import com.ericsson.cms.sites.core.entities.CISNotificationType;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;
import org.scte.schemas._130_2._2008a.core.AddressType;
import org.scte.schemas._130_2._2008a.core.CalloutType;
import org.scte.schemas._130_2._2008a.core.NoteType;
import org.scte.schemas._130_2._2008a.core.ObjectFactory;
import org.scte.schemas._130_2._2008a.core.StatusCodeType;
import org.scte.schemas._130_4._2011.cis.CISNotificationRegistrationRequestType;
import org.scte.schemas._130_4._2011.cis.CISNotificationRegistrationResponseType;
import org.scte.schemas._130_8._2011.gis.BasicFilterElementType;
import org.scte.schemas._130_8._2011.gis.BasicQueryFilterType;
import org.scte.schemas._130_8._2011.gis.QueryAbstractType;
import org.scte.schemas._130_8._2011.gis.QueryType;

public class CISHelperUtil {
    private static Logger logger = Logger.getLogger(CISHelperUtil.class);

    public JAXBElement<CISNotificationRegistrationRequestType> convertXMLNotificationRequest(String inputXML) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{CISNotificationRegistrationRequestType.class});
        Unmarshaller jaxbUnmarshaller = jc.createUnmarshaller();
        StringReader requestReader = new StringReader(inputXML);
        JAXBElement request = (JAXBElement)jaxbUnmarshaller.unmarshal((Reader)requestReader);
        return request;
    }

    public void validateCISNotificationRegistrationRequest(JAXBElement<CISNotificationRegistrationRequestType> registrationRequestType) throws CISException {
        ArrayList<String> errorList = new ArrayList<String>();
        if (registrationRequestType.getDeclaredType() != CISNotificationRegistrationRequestType.class) {
            throw new CISException(12, Arrays.asList("Not Supported, request should be registration request type."));
        }
        CISNotificationRegistrationRequestType registrationRequest = (CISNotificationRegistrationRequestType)registrationRequestType.getValue();
        if (registrationRequest.getIdentity() == null || registrationRequest.getIdentity().isEmpty()) {
            errorList.add("Identity is required.");
        }
        if (registrationRequest.getMessageId() == null || registrationRequest.getMessageId().isEmpty()) {
            errorList.add("Message Id is required.");
        }
        if (!registrationRequest.getCallout().isEmpty()) {
            for (CalloutType calloutType : registrationRequest.getCallout()) {
                if (!this.isSupportedCallOutMessage("CISNotification")) {
                    errorList.add("Callout message is not CISNotification.");
                }
                if (!calloutType.getAddress().isEmpty()) {
                    for (AddressType addressType : calloutType.getAddress()) {
                        if (addressType.getValue() == null) {
                            errorList.add("Address URL is required for AddressType.");
                        }
                        if (this.isSupportedProtocol(addressType.getType())) continue;
                        errorList.add("AddressType is not supported. Only SOAP AddressType is supported.");
                    }
                    continue;
                }
                errorList.add("AddressType is required for callout.");
            }
        } else {
            errorList.add("Callout is required.");
        }
        if (registrationRequest.getQueryAbstract() == null) {
            errorList.add("Query is required.");
        } else {
            QueryType query;
            if (((QueryAbstractType)registrationRequest.getQueryAbstract().getValue()).getQueryId() == null) {
                errorList.add("Query Id is required.");
            }
            if (!(query = (QueryType)registrationRequest.getQueryAbstract().getValue()).getAdvancedQueryFilter().isEmpty()) {
                errorList.add("Advance Query is not supported.");
            }
            if (query.getUniqueQualifier() != null) {
                errorList.add("Unique Qualifier is not supported.");
            }
            if (query.getBasicQueryFilter().isEmpty()) {
                errorList.add("Basic Query Filter is required.");
            } else {
                if (query.getServiceDataModel() != null && !this.isSupportedSpec(query.getServiceDataModel().getValue())) {
                    errorList.add("Unsupported Service Data Model.");
                }
                List<BasicQueryFilterType> basicQueryFilters = query.getBasicQueryFilter();
                for (BasicQueryFilterType basicQueryFilter : basicQueryFilters) {
                    if (basicQueryFilter.getBasicFilterElement().isEmpty()) {
                        errorList.add("BasicFilterElement is required.");
                        continue;
                    }
                    List<BasicFilterElementType> basicFilterElements = basicQueryFilter.getBasicFilterElement();
                    for (BasicFilterElementType basicFilterElement : basicFilterElements) {
                        if (basicFilterElement.isValueIsRegex().booleanValue()) {
                            errorList.add("Regex is not supported.");
                        }
                        if (basicFilterElement.getName() == null || !this.isSupportedAlias(basicFilterElement.getName())) {
                            errorList.add("Unsupported basicfilter element name. Only Provider_ID is supported.");
                        }
                        if (basicFilterElement.getValue() != null) continue;
                        errorList.add("BasicFilterElement value is required.");
                    }
                }
            }
        }
        if (!errorList.isEmpty()) {
            throw new CISException(1, errorList);
        }
    }

    public CISNotificationData convertToCISNotificationData(int siteId, JAXBElement<CISNotificationRegistrationRequestType> registrationRequestType) throws CISException {
        CISServiceHelper helper = new CISServiceHelper();
        CISNotificationData cisData = new CISNotificationData();
        CISNotificationRegistrationRequestType registrationRequest = (CISNotificationRegistrationRequestType)registrationRequestType.getValue();
        cisData.setSiteId(Integer.valueOf(siteId));
        cisData.setNotificationType(CISNotificationType.CIS_NOTIFICATION);
        cisData.setIdentity(registrationRequest.getIdentity());
        cisData.setMessageId(registrationRequest.getMessageId());
        cisData.setCmsSystemId(helper.getCmsSystemId(siteId));
        cisData.setCmsIdentity(helper.getCmsIdentity(siteId));
        List<CalloutType> callOutTypes = registrationRequest.getCallout();
        List<String> calloutUrls = this.getUrls(callOutTypes);
        try {
            cisData.setCallOutURLs(calloutUrls);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("Failed to set callout urls. " + e), (Throwable)e);
            throw new CISException(18, "General error, error in saving the callout urls.");
        }
        JAXBElement<? extends QueryAbstractType> queryAbstract = registrationRequest.getQueryAbstract();
        String query = null;
        try {
            query = this.getQuery(queryAbstract);
        }
        catch (JAXBException e) {
            logger.error((Object)("Failed to parse query" + (Object)((Object)e)), (Throwable)e);
            throw new CISException(4, "Query failed, exception while parsing the query.");
        }
        cisData.setQuery(query);
        return cisData;
    }

    public CISNotificationRegistrationResponseType convertToCISNotificationRegistrationResponse(String identity, String messageUid, String messageRef, int errorCode, List<String> errorList) {
        org.scte.schemas._130_4._2011.cis.ObjectFactory requestFactory = new org.scte.schemas._130_4._2011.cis.ObjectFactory();
        ObjectFactory coreFactor = new ObjectFactory();
        CISNotificationRegistrationResponseType response = requestFactory.createCISNotificationRegistrationResponseType();
        response.setIdentity(identity);
        response.setMessageId(messageUid);
        if (messageRef == null) {
            messageRef = "";
        }
        response.setMessageRef(messageRef);
        response.setVersion("1.0");
        StatusCodeType statuscode = new StatusCodeType();
        statuscode.setClazz(BigInteger.valueOf(errorCode));
        if (errorList != null) {
            NoteType note = null;
            for (String error : errorList) {
                note = coreFactor.createNoteType();
                note.setValue(error);
                statuscode.getNote().add(note);
            }
        }
        response.setStatusCode(statuscode);
        return response;
    }

    public String getResponseXML(CISNotificationRegistrationResponseType response) {
        String responseXML = null;
        org.scte.schemas._130_4._2011.cis.ObjectFactory requestFactory = new org.scte.schemas._130_4._2011.cis.ObjectFactory();
        JAXBElement<CISNotificationRegistrationResponseType> registrationResponse = requestFactory.createCISNotificationRegistrationResponse(response);
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{CISNotificationRegistrationResponseType.class});
            Marshaller marshallerObj = jc.createMarshaller();
            marshallerObj.setProperty("jaxb.formatted.output", (Object)true);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            marshallerObj.marshal(registrationResponse, (OutputStream)outputStream);
            responseXML = ((Object)outputStream).toString();
        }
        catch (JAXBException e) {
            logger.error((Object)("JAXBException while trying to generate response xml" + (Object)((Object)e)), (Throwable)e);
        }
        return responseXML;
    }

    private List<String> getUrls(List<CalloutType> callOutTypes) {
        ArrayList<String> callOutUrls = new ArrayList<String>();
        for (CalloutType callout : callOutTypes) {
            List<AddressType> addressTypes = callout.getAddress();
            for (AddressType address : addressTypes) {
                if (address == null) continue;
                callOutUrls.add(address.getValue());
            }
        }
        return callOutUrls;
    }

    private String getQuery(JAXBElement<? extends QueryAbstractType> queryAbstract) throws JAXBException {
        String query = null;
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{QueryAbstractType.class});
        Marshaller marshallerObj = jc.createMarshaller();
        marshallerObj.setProperty("jaxb.formatted.output", (Object)true);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        marshallerObj.marshal(queryAbstract, (OutputStream)outputStream);
        query = ((Object)outputStream).toString();
        return query;
    }

    private boolean isSupportedProtocol(String addressType) {
        CISConstants.SUPPORTED_PROTOCOLS[] sUPPORTED_PROTOCOLSArray = CISConstants.SUPPORTED_PROTOCOLS.values();
        int n = sUPPORTED_PROTOCOLSArray.length;
        int n2 = 0;
        while (n2 < n) {
            CISConstants.SUPPORTED_PROTOCOLS protocol = sUPPORTED_PROTOCOLSArray[n2];
            if (addressType != null && addressType.startsWith(protocol.name())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isSupportedCallOutMessage(String message) {
        CISConstants.SUPPORTED_CALLOUT_MESSAGES[] sUPPORTED_CALLOUT_MESSAGESArray = CISConstants.SUPPORTED_CALLOUT_MESSAGES.values();
        int n = sUPPORTED_CALLOUT_MESSAGESArray.length;
        int n2 = 0;
        while (n2 < n) {
            CISConstants.SUPPORTED_CALLOUT_MESSAGES calloutMessage = sUPPORTED_CALLOUT_MESSAGESArray[n2];
            if (calloutMessage.toString().equals(message)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isSupportedAlias(String inputAlias) {
        CISConstants.SUPPORTED_FIELD_ALIAS[] sUPPORTED_FIELD_ALIASArray = CISConstants.SUPPORTED_FIELD_ALIAS.values();
        int n = sUPPORTED_FIELD_ALIASArray.length;
        int n2 = 0;
        while (n2 < n) {
            CISConstants.SUPPORTED_FIELD_ALIAS alias = sUPPORTED_FIELD_ALIASArray[n2];
            if (alias.toString().equals(inputAlias)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isSupportedSpec(String inputSpec) {
        CISConstants.SUPPORTED_METADATA_SPECS[] sUPPORTED_METADATA_SPECSArray = CISConstants.SUPPORTED_METADATA_SPECS.values();
        int n = sUPPORTED_METADATA_SPECSArray.length;
        int n2 = 0;
        while (n2 < n) {
            CISConstants.SUPPORTED_METADATA_SPECS spec = sUPPORTED_METADATA_SPECSArray[n2];
            if (spec.toString().equals(inputSpec)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

