/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.cis;

import com.ericsson.cms.cis.CISConstants;
import com.ericsson.cms.cis.resources.CISNotificationResponse;
import com.ericsson.cms.cis.resources.CISQualifiedData;
import com.ericsson.cms.cis.util.XmlUtil;
import com.ericsson.cms.sites.core.entities.CISMode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.apache.log4j.Logger;
import org.scte.schemas._130_2._2008a.core.ContentType;
import org.scte.schemas._130_2._2008a.core.ObjectFactory;
import org.scte.schemas._130_4._2011.cis.CISNotificationType;
import org.scte.schemas._130_4._2011.cis.query.VOD11BasicQueryResultType;
import org.scte.schemas._130_4._2011.cis.query.VOD30BasicQueryResultType;
import org.scte.schemas._130_8._2011.gis.QueryResultType;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class CISNotification {
    private static final String CISXMLNSCORE = "CISNotification xmlns=\"http://www.scte.org/schemas/130-2/2008a/core\"";
    private static final String ADI3XMLNSCORE = "ADI3 xmlns=\"urn:cablelabs:md:xsd:core:3.0\"";
    private static final Logger logger = Logger.getLogger(CISNotification.class);
    private static final String NOTICE_TYPE = "new";
    private static final String QUERY_REF = "query_ref_missing";
    private static final String XML_QUERYRESULT_ELEMENT = "ns2:QueryResult";
    private static final String XML_QUERYREF_ATTRIBUTE = "queryRef";
    private static final String ADIMETADATA = "ADI_METADATA";
    private static final String ADI3_REPLACE_STRING = "<ADI3>ADI_METADATA</ADI3>";
    private static final String ADI11_REPLACE_STRING = "ADI_METADATA";
    private static final BigInteger RESULT_SET_SIZE = BigInteger.valueOf(1L);
    private static final String MESSAGE_UID = "msg_uid_missing";

    public static List<CISNotificationResponse> getCISNotification(List<CISQualifiedData> qualifiedDataList, String titleXmlAsString, Integer siteId, CISMode cisMode) throws JAXBException, SAXException, IOException, ParserConfigurationException, TransformerFactoryConfigurationError, TransformerException {
        if (titleXmlAsString == null || titleXmlAsString.isEmpty()) {
            throw new IllegalArgumentException("Unable to get title metadata in Specification format: " + (Object)((Object)CISConstants.SUPPORTED_METADATA_SPECS.CL3_0));
        }
        Document genericCISNotificationXmlDoc = null;
        Document cisNotificatinResponseWithAdi3Doc = null;
        ArrayList<CISNotificationResponse> cisNotificationResponseList = new ArrayList<CISNotificationResponse>();
        if (!qualifiedDataList.isEmpty()) {
            String cmsIdentity = qualifiedDataList.get(0).getCmsIdentity();
            String cmsSystemId = qualifiedDataList.get(0).getCmsSystemId();
            if (cisMode == CISMode.BLACKARROWADI30) {
                genericCISNotificationXmlDoc = CISNotification.getCISNotificationResponseXMLVOD11(siteId, cmsIdentity, cmsSystemId);
                cisNotificatinResponseWithAdi3Doc = CISNotification.addTitleAdi11InCISNotificationReponse(genericCISNotificationXmlDoc, titleXmlAsString);
            } else {
                genericCISNotificationXmlDoc = CISNotification.getCISNotificationResponseXML(siteId, cmsIdentity, cmsSystemId);
                cisNotificatinResponseWithAdi3Doc = CISNotification.addTitleAdi3InCISNotificationReponse(genericCISNotificationXmlDoc, titleXmlAsString);
            }
            for (CISQualifiedData qData : qualifiedDataList) {
                CISNotificationResponse cisNotificationResponse = new CISNotificationResponse();
                List<String> calloutUrls = qData.getCallOutURLs();
                if (calloutUrls == null || calloutUrls.isEmpty()) continue;
                cisNotificationResponse.setCalloutUrls(calloutUrls);
                XmlUtil.updateXmlAttribute(cisNotificatinResponseWithAdi3Doc, XML_QUERYRESULT_ELEMENT, XML_QUERYREF_ATTRIBUTE, qData.getQueryId());
                String cisNotificatinResponseWithAdi3String = XmlUtil.getDocumentAsString(cisNotificatinResponseWithAdi3Doc);
                if (!cisNotificatinResponseWithAdi3String.contains(CISXMLNSCORE)) {
                    cisNotificatinResponseWithAdi3String = cisNotificatinResponseWithAdi3String.replace("CISNotification xmlns", "CISNotification xmlns=\"http://www.scte.org/schemas/130-2/2008a/core\" xmlns");
                }
                if (!cisNotificatinResponseWithAdi3String.contains("ADI3 xmlns=\"http://www.scte.org/schemas/130-2/2008a/core\"")) {
                    cisNotificatinResponseWithAdi3String = cisNotificatinResponseWithAdi3String.replace("ADI3 xmlns", "ADI3 xmlns=\"urn:cablelabs:md:xsd:core:3.0\" xmlns");
                }
                cisNotificationResponse.setCisNotificationResponseXML(cisNotificatinResponseWithAdi3String);
                cisNotificationResponseList.add(cisNotificationResponse);
            }
        }
        return cisNotificationResponseList;
    }

    public static Document addTitleAdi3InCISNotificationReponse(Document cisNotificationXmlDoc, String titleXmlAsString) throws SAXException, IOException, TransformerFactoryConfigurationError, TransformerException, ParserConfigurationException {
        String titleAdi3WithoutXmlDeclaration = XmlUtil.reformatXml(titleXmlAsString, true, true);
        String cisNotificationXmlString = XmlUtil.getDocumentAsString(cisNotificationXmlDoc);
        String cisNotificatinResponseWithAdi3String = cisNotificationXmlString.replace(ADI3_REPLACE_STRING, titleAdi3WithoutXmlDeclaration);
        String cisNotificatinResponseWithAdi3Formatted = XmlUtil.reformatXml(cisNotificatinResponseWithAdi3String, false, true);
        logger.debug((Object)("CISNotification template after appending title ADI3:\n" + cisNotificatinResponseWithAdi3Formatted));
        Document cisNotificatinResponseWithAdi3Doc = XmlUtil.getXmlStringAsDocument(cisNotificatinResponseWithAdi3Formatted);
        return cisNotificatinResponseWithAdi3Doc;
    }

    public static Document addTitleAdi11InCISNotificationReponse(Document cisNotificationXmlDoc, String titleXmlAsString) throws SAXException, IOException, TransformerFactoryConfigurationError, TransformerException, ParserConfigurationException {
        String titleAdi3WithoutXmlDeclaration = XmlUtil.reformatXml(titleXmlAsString, true, true);
        String cisNotificationXmlString = XmlUtil.getDocumentAsString(cisNotificationXmlDoc);
        String cisNotificatinResponseWithAdi3String = cisNotificationXmlString.replace("ADI_METADATA", titleAdi3WithoutXmlDeclaration);
        String cisNotificatinResponseWithAdi3Formatted = XmlUtil.reformatXml(cisNotificatinResponseWithAdi3String, false, true);
        logger.debug((Object)("CISNotification template after appending title ADI3:\n" + cisNotificatinResponseWithAdi3Formatted));
        Document cisNotificatinResponseWithAdi3Doc = XmlUtil.getXmlStringAsDocument(cisNotificatinResponseWithAdi3Formatted);
        return cisNotificatinResponseWithAdi3Doc;
    }

    public static Document getCISNotificationResponseXML(Integer siteId, String identity, String systemId) throws JAXBException, SAXException, IOException, ParserConfigurationException {
        org.scte.schemas._130_8._2011.gis.ObjectFactory objectFactory8 = new org.scte.schemas._130_8._2011.gis.ObjectFactory();
        org.scte.schemas._130_4._2011.cis.ObjectFactory objectFactory4 = new org.scte.schemas._130_4._2011.cis.ObjectFactory();
        org.scte.schemas._130_4._2011.cis.query.ObjectFactory queryObjectFactory = new org.scte.schemas._130_4._2011.cis.query.ObjectFactory();
        CISNotificationType cisNotification = objectFactory4.createCISNotificationType();
        cisNotification.setIdentity(identity);
        cisNotification.setSystem(systemId);
        cisNotification.setMessageId(MESSAGE_UID);
        cisNotification.setNoticeType(NOTICE_TYPE);
        cisNotification.setVersion("1.0");
        QueryResultType queryResult = objectFactory8.createQueryResultType();
        queryResult.setQueryRef(QUERY_REF);
        queryResult.setResultSetSize(RESULT_SET_SIZE);
        VOD30BasicQueryResultType vod30QueryResult = queryObjectFactory.createVOD30BasicQueryResultType();
        List<String> adi3List = vod30QueryResult.getADI3();
        adi3List.add("ADI_METADATA");
        JAXBElement<VOD30BasicQueryResultType> vod30QueryResultType = queryObjectFactory.createVOD30BasicQueryResult(vod30QueryResult);
        queryResult.setBasicQueryResultAbstract(vod30QueryResultType);
        JAXBElement<CISNotificationType> cisNotificationType = objectFactory4.createCISNotification(cisNotification);
        cisNotification.setQueryResult(queryResult);
        JAXBContext cisNotificationXml = JAXBContext.newInstance((Class[])new Class[]{CISNotificationType.class, VOD30BasicQueryResultType.class});
        Marshaller marshallerObj4 = cisNotificationXml.createMarshaller();
        marshallerObj4.setProperty("jaxb.formatted.output", (Object)true);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        marshallerObj4.marshal(cisNotificationType, (OutputStream)outputStream);
        String cisNotificationResponse = ((Object)outputStream).toString();
        logger.debug((Object)("CISNotification template before appending title ADI3:\n" + cisNotificationResponse));
        Document cisNotificationResponseDoc = XmlUtil.getXmlStringAsDocument(cisNotificationResponse);
        return cisNotificationResponseDoc;
    }

    public static Document getCISNotificationResponseXMLVOD11(Integer siteId, String identity, String systemId) throws JAXBException, SAXException, IOException, ParserConfigurationException {
        org.scte.schemas._130_8._2011.gis.ObjectFactory objectFactory8 = new org.scte.schemas._130_8._2011.gis.ObjectFactory();
        org.scte.schemas._130_4._2011.cis.ObjectFactory objectFactory4 = new org.scte.schemas._130_4._2011.cis.ObjectFactory();
        org.scte.schemas._130_4._2011.cis.query.ObjectFactory queryObjectFactory = new org.scte.schemas._130_4._2011.cis.query.ObjectFactory();
        ObjectFactory objectFactory6 = new ObjectFactory();
        CISNotificationType cisNotification = objectFactory4.createCISNotificationType();
        cisNotification.setIdentity(identity);
        cisNotification.setSystem(systemId);
        cisNotification.setMessageId(MESSAGE_UID);
        cisNotification.setNoticeType(NOTICE_TYPE);
        cisNotification.setVersion("1.0");
        QueryResultType queryResult = objectFactory8.createQueryResultType();
        queryResult.setQueryRef(QUERY_REF);
        queryResult.setResultSetSize(RESULT_SET_SIZE);
        VOD11BasicQueryResultType vod11QueryResult = queryObjectFactory.createVOD11BasicQueryResultType();
        List<ContentType> contentList = vod11QueryResult.getContent();
        ContentType ct = objectFactory6.createContentType();
        ct.setExt("ADI_METADATA");
        contentList.add(ct);
        JAXBElement<VOD11BasicQueryResultType> vod11QueryResultType = queryObjectFactory.createVOD11BasicQueryResult(vod11QueryResult);
        queryResult.setBasicQueryResultAbstract(vod11QueryResultType);
        JAXBElement<CISNotificationType> cisNotificationType = objectFactory4.createCISNotification(cisNotification);
        cisNotification.setQueryResult(queryResult);
        JAXBContext cisNotificationXml = JAXBContext.newInstance((Class[])new Class[]{CISNotificationType.class, VOD11BasicQueryResultType.class});
        Marshaller marshallerObj4 = cisNotificationXml.createMarshaller();
        marshallerObj4.setProperty("jaxb.formatted.output", (Object)true);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        marshallerObj4.marshal(cisNotificationType, (OutputStream)outputStream);
        String cisNotificationResponse = ((Object)outputStream).toString();
        logger.debug((Object)("CISNotification template before appending title ADI11:\n" + cisNotificationResponse));
        Document cisNotificationResponseDoc = XmlUtil.getXmlStringAsDocument(cisNotificationResponse);
        return cisNotificationResponseDoc;
    }
}

