/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.cis;

import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class CISProperties
extends Properties {
    private static final long serialVersionUID = -2440412148987996833L;
    private static final Logger logger = Logger.getLogger(CISProperties.class);
    private static final String SETTINGS_GROUP = "com.ericsson.cms.cis.settings";
    private static final String IDENTITY_PROPERTY = "uuid";
    private static final String NEPTUNE_CONF_NAME = "cms/ConfigurationService/local";
    private static final String DEFAULT_UUID_STR = "067e6162-3b6f-4ae2-a171-2470b63dff00";
    private String uuid;

    public String getUuid() {
        return this.uuid;
    }

    public CISProperties() {
        this.loadProperties();
    }

    private void loadProperties() {
        this.uuid = null;
        try {
            try {
                Map settings = this.getSettingsService().getProperties(SETTINGS_GROUP);
                this.uuid = (String)settings.get(IDENTITY_PROPERTY);
                logger.debug((Object)("Loaded properties: uuid" + this.uuid));
            }
            catch (Throwable ex) {
                logger.error((Object)("Cannot load properties " + ex), ex);
                if (this.uuid == null) {
                    this.uuid = DEFAULT_UUID_STR;
                    logger.debug((Object)("Loaded default value for uuid" + this.uuid));
                }
            }
        }
        finally {
            if (this.uuid == null) {
                this.uuid = DEFAULT_UUID_STR;
                logger.debug((Object)("Loaded default value for uuid" + this.uuid));
            }
        }
    }

    public IConfigurationService getSettingsService() {
        return (IConfigurationService)InjectionUtil.injectInstance((String)NEPTUNE_CONF_NAME, IConfigurationService.class);
    }
}

