/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.cis;

import com.ericsson.cms.cis.CISException;
import com.ericsson.cms.cis.resources.CISQualifiedData;
import com.ericsson.cms.sites.core.entities.CISNotificationData;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.scte.schemas._130_8._2011.gis.BasicFilterElementType;
import org.scte.schemas._130_8._2011.gis.BasicQueryFilterType;
import org.scte.schemas._130_8._2011.gis.QueryFilterOpTypeEnumeration;
import org.scte.schemas._130_8._2011.gis.QueryType;

public class CISQueryEvaluator {
    public static List<CISQualifiedData> getQualifiedCallOutURLs(List<CISNotificationData> cisData, Title siteTitle) throws CISException, UnsupportedEncodingException, JAXBException {
        ArrayList<CISQualifiedData> result = new ArrayList<CISQualifiedData>();
        for (CISNotificationData csd : cisData) {
            CISQualifiedData cisQd = CISQueryEvaluator.getQualified(csd, siteTitle);
            if (cisQd == null) continue;
            result.add(cisQd);
        }
        return result;
    }

    private static CISQualifiedData getQualified(CISNotificationData csd, Title title) throws JAXBException, UnsupportedEncodingException {
        CISQualifiedData result = new CISQualifiedData();
        QueryType query = CISQueryEvaluator.getQueryObject(csd.getQuery());
        boolean isQualified = CISQueryEvaluator.isQualified(query, title);
        if (!isQualified) {
            return null;
        }
        result.setCallOutURLs(csd.getCallOutURLs());
        result.setIdentity(csd.getIdentity());
        result.setQueryId(query.getQueryId());
        result.setCmsIdentity(csd.getCmsIdentity());
        result.setCmsSystemId(csd.getCmsSystemId());
        return result;
    }

    private static QueryType getQueryObject(String query) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{QueryType.class});
        Unmarshaller jaxbUnmarshaller = jc.createUnmarshaller();
        JAXBElement queryType = (JAXBElement)jaxbUnmarshaller.unmarshal((Reader)new StringReader(query));
        return (QueryType)queryType.getValue();
    }

    private static boolean isQualified(QueryType query, Title title) {
        return CISQueryEvaluator.isQualifiedBasicQueryFilters(query, title);
    }

    private static boolean isQualifiedBasicQueryFilters(QueryType query, Title title) {
        boolean isQualified = false;
        boolean aggregatedResult = false;
        for (BasicQueryFilterType bqf : query.getBasicQueryFilter()) {
            isQualified = CISQueryEvaluator.isQualifiedBasicFilterElements(bqf, title);
            if (aggregatedResult |= bqf.getOp() == QueryFilterOpTypeEnumeration.EXCLUDE ? !isQualified : isQualified) break;
        }
        return aggregatedResult;
    }

    private static boolean isQualifiedBasicFilterElements(BasicQueryFilterType bqf, Title title) {
        boolean isQualified = true;
        for (BasicFilterElementType bfe : bqf.getBasicFilterElement()) {
            if (!(isQualified &= CISQueryEvaluator.isQualifiedBasicFilterElement(bfe, title))) break;
        }
        return isQualified;
    }

    private static boolean isQualifiedBasicFilterElement(BasicFilterElementType bfe, Title title) {
        boolean isQualified = false;
        String queryAlaias = bfe.getName();
        String queryAliasValue = bfe.getValue();
        List assets = title.getAssets("TITLE");
        if (assets == null || assets.isEmpty()) {
            return false;
        }
        Asset titleAsset = (Asset)assets.get(0);
        Field field = titleAsset.getFirstField(queryAlaias);
        if (queryAliasValue.isEmpty()) {
            return true;
        }
        if (field != null && field.getValue().equals(queryAliasValue)) {
            isQualified = true;
        }
        return isQualified;
    }
}

