/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.cis;

import com.ericsson.cms.cis.CISException;
import com.ericsson.cms.cis.CISServiceHelper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;
import org.scte.schemas._130_2._2008a.core.NoteType;
import org.scte.schemas._130_2._2008a.core.ObjectFactory;
import org.scte.schemas._130_2._2008a.core.ServiceCheckRequestType;
import org.scte.schemas._130_2._2008a.core.ServiceCheckResponseType;
import org.scte.schemas._130_2._2008a.core.StatusCodeType;

public class CISServiceCheck {
    private static final Logger logger = Logger.getLogger(CISServiceCheck.class);

    public static ServiceCheckRequestType validateServiceCheckRequestType(String inputXML) throws CISException {
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ServiceCheckRequestType.class});
            Unmarshaller jaxbUnmarshaller = jc.createUnmarshaller();
            StringReader requestReader = new StringReader(inputXML);
            JAXBElement request = (JAXBElement)jaxbUnmarshaller.unmarshal((Reader)requestReader);
            if (request.getDeclaredType() != ServiceCheckRequestType.class) {
                throw new CISException(12, request.getDeclaredType() + " request type is not supported");
            }
            return (ServiceCheckRequestType)request.getValue();
        }
        catch (JAXBException e) {
            logger.error((Object)("Failed to convert to JAXBElement<ServiceCheckRequestType>" + (Object)((Object)e)), (Throwable)e);
            throw new CISException(2, "Message validation failed");
        }
    }

    public static String getServiceCheckResponse(int siteId, String messageRef, int errorCode, String ... errors) {
        logger.debug((Object)("Generating service check response xml with parameters: siteId=" + siteId + " messageRef=" + messageRef + " errorCode=" + errorCode));
        List<String> errorList = null;
        if (errors != null) {
            errorList = Arrays.asList(errors);
        }
        String serviceCheckReponseXml = null;
        try {
            serviceCheckReponseXml = CISServiceCheck.getCISServiceCheckResponse(siteId, messageRef, errorCode, errorList);
        }
        catch (JAXBException e) {
            logger.error((Object)("JAXBException while trying to generate ServiceCheckResponse xml" + (Object)((Object)e)), (Throwable)e);
        }
        logger.debug((Object)("ServiceCheckResponse xml: " + serviceCheckReponseXml));
        return serviceCheckReponseXml;
    }

    private static String getCISServiceCheckResponse(Integer siteId, String messageRef, int errorCode, List<String> errorList) throws JAXBException {
        ObjectFactory objectFactory = new ObjectFactory();
        ServiceCheckResponseType response = objectFactory.createServiceCheckResponseType();
        CISServiceHelper helper = new CISServiceHelper();
        response.setIdentity(helper.getCmsIdentity(siteId));
        response.setMessageId(helper.getMessageUid());
        response.setVersion("1.0");
        if (messageRef == null) {
            messageRef = "";
        }
        response.setMessageRef(messageRef);
        StatusCodeType statuscode = new StatusCodeType();
        statuscode.setClazz(BigInteger.valueOf(errorCode));
        if (errorList != null) {
            NoteType note = null;
            for (String error : errorList) {
                note = objectFactory.createNoteType();
                note.setValue(error);
                statuscode.getNote().add(note);
            }
        }
        response.setStatusCode(statuscode);
        String serviceResponseXmlAsString = CISServiceCheck.convertServiceCheckResponseTypeToXml(response);
        return serviceResponseXmlAsString;
    }

    private static String convertServiceCheckResponseTypeToXml(ServiceCheckResponseType response) throws JAXBException {
        ObjectFactory objectFactory = new ObjectFactory();
        JAXBElement<ServiceCheckResponseType> serviceResponseType = objectFactory.createServiceCheckResponse(response);
        JAXBContext serviceResponseXml = JAXBContext.newInstance((Class[])new Class[]{ServiceCheckResponseType.class});
        Marshaller marshallerObj4 = serviceResponseXml.createMarshaller();
        marshallerObj4.setProperty("jaxb.formatted.output", (Object)true);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        marshallerObj4.marshal(serviceResponseType, (OutputStream)outputStream);
        String serviceResponseXmlAsString = ((Object)outputStream).toString();
        return serviceResponseXmlAsString;
    }
}

