/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.cis;

import com.ericsson.cms.cis.CISException;
import com.ericsson.cms.cis.CISHelperUtil;
import com.ericsson.cms.cis.CISProperties;
import com.ericsson.cms.sites.core.entities.CISNotificationData;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.scte.schemas._130_4._2011.cis.CISNotificationRegistrationRequestType;
import org.scte.schemas._130_4._2011.cis.CISNotificationRegistrationResponseType;

public class CISServiceHelper {
    private CISHelperUtil cisHelperUtil = new CISHelperUtil();
    private CISProperties cisProperties = new CISProperties();
    private static Logger logger = Logger.getLogger(CISServiceHelper.class);

    public String getCmsIdentity(int siteId) {
        String uuid_setting = this.cisProperties.getUuid();
        return "CIS_" + siteId + "_" + uuid_setting;
    }

    public String getCmsSystemId(int siteId) {
        return "CIS_" + siteId;
    }

    public String getMessageUid() {
        return UUID.randomUUID().toString();
    }

    public CISNotificationData getCISDataForRegistrationRequest(int siteId, String registrationRequestXML) throws CISException {
        JAXBElement<CISNotificationRegistrationRequestType> request = null;
        try {
            request = this.cisHelperUtil.convertXMLNotificationRequest(registrationRequestXML);
        }
        catch (JAXBException e) {
            logger.error((Object)("Failed to convert to JAXBElement<CISNotificationRegistrationRequestType>" + (Object)((Object)e)), (Throwable)e);
            throw new CISException(12, "Invalid input for registration request.");
        }
        CISNotificationData cisNotificationData = null;
        if (request != null) {
            this.cisHelperUtil.validateCISNotificationRegistrationRequest(request);
            cisNotificationData = this.cisHelperUtil.convertToCISNotificationData(siteId, request);
        }
        return cisNotificationData;
    }

    public String getRegistrationResponse(int siteId, CISNotificationData cisData, int errorCode, String ... errors) {
        String messageId = cisData == null ? "" : cisData.getMessageId();
        return this.getRegistrationResponse(siteId, messageId, errorCode, errors);
    }

    public String getRegistrationResponse(int siteId, String messageRef, int errorCode, String ... errors) {
        logger.debug((Object)("Generating response xml with parameters: siteId=" + siteId + " messageRef=" + messageRef + " errorCode=" + errorCode));
        List<String> errorList = null;
        if (errors != null) {
            errorList = Arrays.asList(errors);
        }
        CISNotificationRegistrationResponseType notificatonResponse = this.cisHelperUtil.convertToCISNotificationRegistrationResponse(this.getCmsIdentity(siteId), this.getMessageUid(), messageRef, errorCode, errorList);
        String responseXML = this.cisHelperUtil.getResponseXML(notificatonResponse);
        logger.debug((Object)("Response xml=" + responseXML));
        return responseXML;
    }
}

