/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.cis.core;

import com.ericsson.cms.cis.CISConstants;
import com.ericsson.cms.cis.CISException;
import com.ericsson.cms.cis.CISNotification;
import com.ericsson.cms.cis.CISQueryEvaluator;
import com.ericsson.cms.cis.CISServiceCheck;
import com.ericsson.cms.cis.CISServiceHelper;
import com.ericsson.cms.cis.core.ICISManager;
import com.ericsson.cms.cis.resources.CISNotificationResponse;
import com.ericsson.cms.cis.resources.CISQualifiedData;
import com.ericsson.cms.cis.util.XmlUtil;
import com.ericsson.cms.sites.core.CISPersistenceException;
import com.ericsson.cms.sites.core.ICISPersistenceManager;
import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.cms.sites.core.entities.CISMode;
import com.ericsson.cms.sites.core.entities.CISNotificationData;
import com.ericsson.cms.sites.core.entities.CISNotificationType;
import com.ericsson.cms.sites.core.entities.DistributionSite;
import com.ericsson.cms.sites.core.entities.DistributionSiteTitle;
import com.ericsson.cms.sites.core.entities.Site;
import com.ericsson.cms.sites.core.entities.SiteType;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.watchpoint.pmm.title.conf.ISpecificationManager;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;
import org.scte.schemas._130_2._2008a.core.ServiceCheckRequestType;
import org.scte.schemas._130_4._2011.cis.CISNotificationRegistrationRequestType;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@Stateless
public class CISManager
implements ICISManager {
    private static final Logger logger = Logger.getLogger(CISManager.class);
    private ISpecificationManager specificationManager = (ISpecificationManager)ServiceRegistry.getDefault().lookup(ISpecificationManager.class);
    private ITitleManager titleManager = (ITitleManager)ServiceRegistry.getDefault().lookup(ITitleManager.class);
    @EJB
    private ISiteManager siteManager;
    @EJB
    private ICISPersistenceManager cisPersistenceManager;
    private static /* synthetic */ Annotation ajc$anno$0;

    @Override
    public List<CISNotificationResponse> getCISNotification(Long siteTitleId, CISMode cisMode) throws CISException {
        if (siteTitleId == null) {
            throw new CISException("Site Title ID cannot be null");
        }
        if (this.titleManager.isOriginalTitle(siteTitleId.longValue())) {
            throw new CISException(" Title with ID: " + siteTitleId + " is not a Site Title");
        }
        if (!this.titleManager.isActive(siteTitleId)) {
            throw new CISException(" Site Title with ID: " + siteTitleId + " is not active");
        }
        logger.info((Object)("Getting CISNotificationReponse for siteTitleId:" + siteTitleId));
        long t1 = System.currentTimeMillis();
        ArrayList<CISNotificationResponse> cisNotificationResponseList = new ArrayList();
        try {
            Integer siteId = this.siteManager.getDistributionSiteId(siteTitleId);
            List cisDataList = this.cisPersistenceManager.get(siteId, null, null, CISNotificationType.CIS_NOTIFICATION);
            DistributionSiteTitle dstSiteTitle = this.siteManager.getDistributionSiteTitle(siteTitleId.longValue());
            Title siteTitle = dstSiteTitle.getTitle();
            List<CISQualifiedData> qualifiedDataList = CISQueryEvaluator.getQualifiedCallOutURLs(cisDataList, siteTitle);
            String adi3_specName = CISConstants.SUPPORTED_METADATA_SPECS.CL3_0.toString();
            if (cisMode == CISMode.BLACKARROWADI30) {
                adi3_specName = CISConstants.SUPPORTED_METADATA_SPECS.CL3_0_I02.toString();
            }
            String titleXmlAsString = this.getTitleInSpecFormat(siteTitle, adi3_specName);
            cisNotificationResponseList = CISNotification.getCISNotification(qualifiedDataList, titleXmlAsString, siteId, cisMode);
        }
        catch (CISPersistenceException cisp) {
            throw new CISException(cisp.getMessage());
        }
        catch (UnsupportedEncodingException ue) {
            throw new CISException(ue.getMessage());
        }
        catch (JAXBException jax) {
            throw new CISException(jax.getMessage());
        }
        catch (TransformerException t) {
            throw new CISException(t.getMessage());
        }
        catch (SAXException sax) {
            throw new CISException(sax.getMessage());
        }
        catch (IOException io) {
            throw new CISException(io.getMessage());
        }
        catch (ParserConfigurationException p) {
            throw new CISException(p.getMessage());
        }
        catch (IllegalArgumentException i) {
            throw new CISException(i.getMessage());
        }
        catch (Exception e) {
            throw new CISException(e.getMessage());
        }
        long t2 = System.currentTimeMillis();
        logger.info((Object)("Time taken to get CISNotificationResponse:" + (t2 - t1) + " ms" + " for siteTitleID = " + siteTitleId));
        return cisNotificationResponseList;
    }

    @Override
    public String processRequest(int siteId, String requestXml) throws CISException {
        String responseXml;
        block4: {
            responseXml = null;
            try {
                JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{CISNotificationRegistrationRequestType.class, ServiceCheckRequestType.class});
                Unmarshaller jaxbUnmarshaller = jc.createUnmarshaller();
                StringReader requestReader = new StringReader(requestXml);
                JAXBElement request = (JAXBElement)jaxbUnmarshaller.unmarshal((Reader)requestReader);
                if (request.getDeclaredType().equals(CISNotificationRegistrationRequestType.class)) {
                    responseXml = this.saveNotificationRegistration(siteId, requestXml);
                    break block4;
                }
                if (request.getDeclaredType().equals(ServiceCheckRequestType.class)) {
                    responseXml = this.performServiceCheck(siteId, requestXml);
                    break block4;
                }
                throw new CISException(12, "Unsupported Request type");
            }
            catch (JAXBException jAXBException) {
                throw new CISException(12, "Unsupported Request type");
            }
        }
        return responseXml;
    }

    private String getTitleInSpecFormat(Title siteTitle, String specificationName) throws CISException, TransformerException {
        Specification specification = this.specificationManager.getSpecificationByAlias(specificationName);
        if (specification == null) {
            String message = "The specification[" + specificationName + "] does not exist.";
            throw new CISException(message);
        }
        Document titleDoc = this.titleManager.getDocument(siteTitle, specification);
        String titleXmlAsString = XmlUtil.getDocumentAsString(titleDoc);
        return titleXmlAsString;
    }

    @Transactional
    public String saveNotificationRegistration(int siteId, String notificationRegistration) {
        int n = siteId;
        String string = notificationRegistration;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = CISManager.class.getDeclaredMethod("saveNotificationRegistration", Integer.TYPE, String.class).getAnnotation(Transactional.class);
        }
        return (String)CISManager.saveNotificationRegistration_aroundBody1$advice(this, n, string, transactionEnforcer, (Transactional)annotation, null);
    }

    public String performServiceCheck(int siteId, String serviceCheckRequest) {
        String serviceCheckResponse;
        String requestMessageId = "";
        Site site = this.siteManager.getSite(siteId);
        if (site == null || site.getType() != SiteType.DISTRIBUTION) {
            String serviceCheckResponse2 = CISServiceCheck.getServiceCheckResponse(siteId, requestMessageId, 18, "Invalid Site Id:" + siteId);
            return serviceCheckResponse2;
        }
        try {
            ServiceCheckRequestType scRequestType = CISServiceCheck.validateServiceCheckRequestType(serviceCheckRequest);
            if (scRequestType != null) {
                requestMessageId = scRequestType.getMessageId();
            }
            serviceCheckResponse = CISServiceCheck.getServiceCheckResponse(siteId, requestMessageId, 0, new String[0]);
        }
        catch (CISException e) {
            logger.error((Object)("Error parsing Service check request " + e), (Throwable)e);
            String serviceCheckResponse3 = CISServiceCheck.getServiceCheckResponse(siteId, requestMessageId, e.getStatusCode(), e.getMessage());
            return serviceCheckResponse3;
        }
        return serviceCheckResponse;
    }

    @Override
    public CISMode getSiteCISMode(Long siteTitleId) {
        if (siteTitleId != null) {
            DistributionSite site = this.siteManager.getAssociatedDistributionSite(siteTitleId.longValue());
            return site.getCisMode();
        }
        return null;
    }

    private static final /* synthetic */ String saveNotificationRegistration_aroundBody0(CISManager ajc$this, int siteId, String notificationRegistration) {
        CISServiceHelper cisHelper = new CISServiceHelper();
        CISNotificationData cisNotificationData = null;
        String notificationRegistrationResponse = null;
        String[] errors = null;
        Site site = ajc$this.siteManager.getSite(siteId);
        if (site == null || site.getType() != SiteType.DISTRIBUTION) {
            notificationRegistrationResponse = cisHelper.getRegistrationResponse(siteId, cisNotificationData, 18, "Invalid site id.");
            return notificationRegistrationResponse;
        }
        if (((DistributionSite)site).getCisMode() == null) {
            notificationRegistrationResponse = cisHelper.getRegistrationResponse(siteId, cisNotificationData, 18, "The CIS mode is not set for the site.");
            return notificationRegistrationResponse;
        }
        try {
            cisNotificationData = cisHelper.getCISDataForRegistrationRequest(siteId, notificationRegistration);
        }
        catch (CISException e) {
            logger.error((Object)("Failed to convert the request xml to CISNotificationData" + e), (Throwable)e);
            errors = e.getMessages().toArray(new String[e.getMessages().size()]);
            notificationRegistrationResponse = cisHelper.getRegistrationResponse(siteId, cisNotificationData, e.getStatusCode(), errors);
            return notificationRegistrationResponse;
        }
        if (cisNotificationData.getIdentity() == null || cisNotificationData.getIdentity().isEmpty()) {
            logger.error((Object)"CIS Client Identity is empty");
            notificationRegistrationResponse = cisHelper.getRegistrationResponse(siteId, cisNotificationData, 18, "CIS Client Identity is empty");
            return notificationRegistrationResponse;
        }
        try {
            ajc$this.cisPersistenceManager.save(cisNotificationData);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("UnsupportedEncodingException while trying to save the request" + e), (Throwable)e);
            notificationRegistrationResponse = cisHelper.getRegistrationResponse(siteId, cisNotificationData, 18, "Error while trying to save the request.");
            return notificationRegistrationResponse;
        }
        catch (CISPersistenceException e) {
            logger.error((Object)("CISPersistenceException while trying to save the request" + (Object)((Object)e)), (Throwable)e);
            notificationRegistrationResponse = cisHelper.getRegistrationResponse(siteId, cisNotificationData, 18, "Error while trying to save the request.");
            return notificationRegistrationResponse;
        }
        notificationRegistrationResponse = cisHelper.getRegistrationResponse(siteId, cisNotificationData, 0, new String[0]);
        return notificationRegistrationResponse;
    }

    private static final /* synthetic */ Object saveNotificationRegistration_aroundBody1$advice(CISManager ajc$this, int siteId, String notificationRegistration, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return CISManager.saveNotificationRegistration_aroundBody0(ajc$this, siteId, notificationRegistration);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            String object = CISManager.saveNotificationRegistration_aroundBody0(ajc$this, siteId, notificationRegistration);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

