/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.cis.util;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtil {
    public static String getDocumentAsString(Document document) throws TransformerException {
        DOMSource domSource = new DOMSource(document);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = null;
        transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, result);
        return writer.toString();
    }

    public static Document getXmlStringAsDocument(String xmlString) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory docBF = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = docBF.newDocumentBuilder();
        Document doc = dBuilder.parse(new InputSource(new StringReader(xmlString)));
        return doc;
    }

    public static void updateXmlAttribute(Document xmlDoc, String xmlElement, String xmlAttribute, String attrNewValue) {
        Node queryNode = xmlDoc.getElementsByTagName(xmlElement).item(0);
        if (queryNode != null) {
            NamedNodeMap queryAttributes = queryNode.getAttributes();
            Node queryAttr = queryAttributes.getNamedItem(xmlAttribute);
            queryAttr.setTextContent(attrNewValue);
        }
    }

    public static String reformatXml(String xmlAsString, boolean omitXmlDeclaration, boolean indent) throws SAXException, IOException, TransformerFactoryConfigurationError, TransformerException, ParserConfigurationException {
        Document xmlDoc = XmlUtil.getXmlStringAsDocument(xmlAsString);
        Transformer xform = TransformerFactory.newInstance().newTransformer();
        String omit = omitXmlDeclaration ? "yes" : "no";
        String ind_ent = indent ? "yes" : "no";
        xform.setOutputProperty("omit-xml-declaration", omit);
        xform.setOutputProperty("indent", ind_ent);
        StringWriter xmlWithoutDeclaration = new StringWriter();
        xform.transform(new DOMSource(xmlDoc), new StreamResult(xmlWithoutDeclaration));
        return xmlWithoutDeclaration.toString();
    }
}

