/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.content_trafficking.ejb;

import com.tandbergtv.cms.content_trafficking.schedule.IScheduleManager;
import com.tandbergtv.watchpoint.pmm.entities.IAssetList;
import com.tandbergtv.watchpoint.pmm.entities.Schedule;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.schedule.ISchedulePersistenceService;
import com.tandbergtv.watchpoint.pmm.schedule.IScheduleValidator;
import com.tandbergtv.watchpoint.pmm.title.ITitleService;
import com.tandbergtv.watchpoint.pmm.title.conf.IRightsManager;
import com.tandbergtv.watchpoint.pmm.title.conf.specs.RightsManagerFactory;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import org.apache.log4j.Logger;

@Stateless
public class ScheduleManager
implements IScheduleManager {
    private static final Logger logger = Logger.getLogger(ScheduleManager.class);

    @TransactionAttribute
    public void addTitlesToSchedule(long scheduleId, List<Long> titleIds) {
        IRightsManager rm = RightsManagerFactory.getRightsManager();
        ISchedulePersistenceService scheduleService = (ISchedulePersistenceService)ServiceRegistry.getDefault().lookup(ISchedulePersistenceService.class);
        Schedule schedule = (Schedule)scheduleService.get((Serializable)Long.valueOf(scheduleId));
        ITitleService titleService = (ITitleService)ServiceRegistry.getDefault().lookup(ITitleService.class);
        Collection titlesToAdd = titleService.getCompleteTitles(titleIds);
        ArrayList<Title> titles = new ArrayList<Title>();
        for (Title title : titlesToAdd) {
            if (schedule.getTitle(title.getId()) != null) {
                logger.warn((Object)("Title [" + title.getId() + "] already belongs to schedule " + schedule));
                continue;
            }
            if (rm != null) {
                if (rm instanceof IScheduleValidator) {
                    ((IScheduleValidator)rm).isLicensed(title, schedule);
                } else {
                    rm.isLicensed(title, schedule.getDate());
                }
            }
            titles.add(title);
        }
        schedule.addTitles(titles);
        scheduleService.save((IAssetList)schedule);
    }
}

