/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search;

import com.ericsson.cms.neptune.cluster.Cluster;
import com.ericsson.cms.neptune.cluster.service.IClusterService;
import com.ericsson.cms.search.IElasticSearchPeriodicTitleSyncCleanupService;
import com.ericsson.cms.search.IElasticSearchTitleSyncCleanupService;
import com.ericsson.neptune.clustermgmt.service.ClusterConstant;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.Timer;
import java.util.TimerTask;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.DependsOn;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;

@Singleton(name="Sites:service=com.ericsson.cms.search.IElasticSearchPeriodicTitleSyncCleanupService")
@DependsOn(value={"ContentManagement:service=com.tandbergtv.cms.contentmgmt.activation.IServiceActivator"})
@Startup
public class ElasticSearchPeriodicTitleSyncCleanupService
implements IElasticSearchPeriodicTitleSyncCleanupService {
    private static final Logger logger = Logger.getLogger(ElasticSearchPeriodicTitleSyncCleanupService.class);
    private Timer timer = new Timer();
    private TimerTask periodicPollingTask;
    private IClusterService hzcs;
    private MembershipListener hazelcastListener = new MembershipListener(){

        public void memberAdded(MembershipEvent ignore) {
        }

        public void memberRemoved(MembershipEvent evt) {
            logger.info((Object)("member removed: " + evt.getMember().getSocketAddress()));
            if (ElasticSearchPeriodicTitleSyncCleanupService.this.hzcs.isMaster()) {
                logger.info((Object)"This node is now the Cluster master node. Starting periodic task to poll database for titles that need to be synced to ES...");
                ElasticSearchPeriodicTitleSyncCleanupService.this.startPeriodicPolling();
            }
        }

        public void memberAttributeChanged(MemberAttributeEvent arg0) {
        }
    };

    @Override
    @PostConstruct
    public void start() {
        try {
            this.hzcs = Cluster.getService((String)ClusterConstant.CLUSTER_CONFIG_PATH);
            this.hzcs.getInstance().getCluster().addMembershipListener(this.hazelcastListener);
            if (this.hzcs.isMaster()) {
                logger.info((Object)"This node is immediately the Cluster master node. Starting periodic task to poll database for titles that need to be synced to ES...");
                this.startPeriodicPolling();
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to crash recover the ElasticSearch Periodic Title Sync Cleanup Service");
        }
    }

    @Override
    @PreDestroy
    public void stop() {
        this.stopPeriodicPolling();
    }

    private void startPeriodicPolling() {
        this.periodicPollingTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                IElasticSearchTitleSyncCleanupService service = (IElasticSearchTitleSyncCleanupService)ServiceRegistry.getDefault().lookup(IElasticSearchTitleSyncCleanupService.class);
                boolean rollback = true;
                TransactionManager transactionManager = null;
                try {
                    transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
                    transactionManager.begin();
                    service.syncTitles(100);
                    transactionManager.commit();
                    rollback = false;
                }
                catch (NamingException ne) {
                    logger.error((Object)"Problem starting a JTA transaction", (Throwable)ne);
                }
                catch (SystemException se) {
                    logger.error((Object)"Problem beginning a new JTA transaction", (Throwable)se);
                }
                catch (NotSupportedException nse) {
                    logger.error((Object)"Problem beginning a new JTA transaction", (Throwable)nse);
                }
                catch (Exception ex) {
                    logger.error((Object)"Unexpected error synching titles", (Throwable)ex);
                }
                finally {
                    if (rollback) {
                        try {
                            logger.warn((Object)"Rolling back JTA transaction because of unexpected error");
                            transactionManager.rollback();
                        }
                        catch (SystemException se) {
                            logger.error((Object)"Unexpected problem trying to rollback exception", (Throwable)se);
                        }
                    }
                }
            }
        };
        this.timer.schedule(this.periodicPollingTask, 60000L, 60000L);
    }

    private void stopPeriodicPolling() {
        if (this.periodicPollingTask != null) {
            this.periodicPollingTask.cancel();
            this.periodicPollingTask = null;
        }
    }
}

