/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.contentmgmt.ejb.title;

import com.tandbergtv.cms.contentmgmt.service.template.IWorkOrderRequestSender;
import com.tandbergtv.neptune.authorization.service.IAuthorizationService;
import com.tandbergtv.watchpoint.pmm.core.ProgressManager;
import com.tandbergtv.watchpoint.routing.SoapRouter;
import com.tandbergtv.workflow.message.WPCLCommand;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import com.tandbergtv.workflow.message.util.WPCLConverter;
import javax.ejb.EJB;
import javax.ejb.Stateless;

@Stateless
public class WorkOrderRequestSender
implements IWorkOrderRequestSender {
    @EJB
    private IAuthorizationService authorizationService;
    private static String PROGRESS_NAME = " - WORK ORDER SCHEDULED";
    private static String PROGRESS_VALUE = "";
    private static String SOURCE_COMPONENT_NAME = "Content Management";
    private static String SOURCE_ENTITY_NAME = "";

    public void sendWorkOrderCreateMessage(long titleId, String templateName) {
        try {
            this.sendMessage(titleId, templateName);
            ProgressManager.newInstance().updateStatus(titleId, null, templateName + PROGRESS_NAME, PROGRESS_VALUE, true, SOURCE_COMPONENT_NAME, SOURCE_ENTITY_NAME, this.authorizationService.getUserName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void sendMessage(long titleId, String templateName) throws Exception {
        WorkflowMessage message = WorkflowMessageFactory.createControlMessage((String)"CM0104");
        WPCLCommand command = new WPCLCommand("create");
        command.addParameter("_template", templateName);
        message.setCommand(command);
        message.getPayload().putValue("titleId", String.valueOf(titleId));
        SoapRouter router = new SoapRouter();
        router.send(new WPCLConverter().convert(message));
    }
}

