/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.validation;

import com.ericsson.cms.contractmgmt.validation.ContractManagerValidator;
import com.ericsson.cms.contractmgmt.validation.ValidationMessages;
import com.ericsson.cms.contractmgmt.validation.interfaces.IContractValidator;
import com.ericsson.ejb.Contract;
import com.ericsson.ejb.ContractType;
import com.ericsson.ejb.CopyrightHolder;
import com.ericsson.ejb.Deal;
import com.ericsson.entitymanager.ContractManager;
import com.ericsson.enumeration.ScreenName;
import com.ericsson.service.ContractManagerValidationException;
import com.ericsson.service.IDealManager;
import com.ericsson.service.IFieldManager;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContractValidator
extends ContractManagerValidator
implements IContractValidator {
    private static final Log log = LogFactory.getLog(ContractValidator.class);
    private static int NAME_MAX_LENGTH = 50;

    @Override
    public void validate(Contract contract, IDealManager dealManager, IFieldManager fieldManager, EntityManager entityManager, ContractManager cmgr) throws ContractManagerValidationException {
        ArrayList<String> validationMessages = new ArrayList<String>();
        if (contract == null) {
            validationMessages.add(ValidationMessages.getString("audit.contract.null"));
            throw new ContractManagerValidationException(validationMessages);
        }
        this.validateContractFields(contract, validationMessages, fieldManager, dealManager, entityManager, cmgr);
        if (!validationMessages.isEmpty()) {
            throw new ContractManagerValidationException(validationMessages);
        }
    }

    private void validateContractFields(Contract contract, List<String> validationMessages, IFieldManager fieldManager, IDealManager dealManager, EntityManager entityManager, ContractManager cmgr) throws ContractManagerValidationException {
        super.validateRequired(contract.getName(), "Name", "", validationMessages);
        super.validateRequired(contract.getContractType(), "Contract Type", "", validationMessages);
        super.validateRequired(contract.getCreationDate(), "Creation Date", "", validationMessages);
        super.validateRequired(contract.getEffectiveDate(), "Effective Date", "", validationMessages);
        super.validateRequired(contract.getExpiryDate(), "Expiry Date", "", validationMessages);
        super.validateLength(contract.getName(), "Name", NAME_MAX_LENGTH, "", validationMessages);
        if (contract.getDealExpiryReminder() != null) {
            super.validateNumeric(contract.getDealExpiryReminder().toString(), "Deal Expiry Reminder", "", validationMessages);
        }
        if (contract.getCopyrightHolder() == null) {
            validationMessages.add(ValidationMessages.getString("contract.CRHValidation"));
        } else {
            CopyrightHolder copright = null;
            try {
                copright = (CopyrightHolder)entityManager.getReference(CopyrightHolder.class, (Object)contract.getCopyrightHolder().getIdCopyrightHolder());
            }
            catch (Exception e) {
                log.debug((Object)("Error on checking CopyrightHolder for Contract [" + contract.getName() + "] - " + e.getMessage()));
            }
            if (copright == null) {
                Object[] values = new Object[]{contract.getCopyrightHolder().getName(), contract.getCopyrightHolder().getIdCopyrightHolder()};
                validationMessages.add(MessageFormat.format(ValidationMessages.getString("contract.copyright.non.existent"), values));
            }
        }
        if (!validationMessages.isEmpty()) {
            throw new ContractManagerValidationException(validationMessages);
        }
        this.validateAgainstDealDates(contract, validationMessages, dealManager);
        this.validateDates(contract, validationMessages);
        this.validateContractType(contract.getContractType(), entityManager, validationMessages);
        super.validateCustomFields(contract.getContractCustomLicFieldValues(), ScreenName.CONTRACT, validationMessages, "", fieldManager, entityManager);
        try {
            Contract c = cmgr.getFullContractByExternalId(contract.getExternalId());
            if (contract.getIdContract() == null && c != null) {
                validationMessages.add("The save operation failed. Contract External Id '" + contract.getExternalId() + "' already exists.");
                throw new ContractManagerValidationException(validationMessages);
            }
            if (c != null && contract.getExternalId().equals(c.getExternalId())) {
                if (!contract.getIdContract().equals(c.getIdContract())) {
                    validationMessages.add("The save operation failed. Contract External Id '" + contract.getExternalId() + "' already exists.");
                    throw new ContractManagerValidationException(validationMessages);
                }
                Contract sameNameContract = cmgr.getContractByName(contract.getName(), contract.getExternalId());
                if (sameNameContract != null) {
                    validationMessages.add("The save operation failed. The name '" + contract.getName() + "' already exists.");
                    throw new ContractManagerValidationException(validationMessages);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void validateAgainstDealDates(Contract contract, List<String> validationMessages, IDealManager dealManager) {
        if (contract.getIdContract() != null) {
            for (Deal deal : dealManager.findByContract(contract.getIdContract().longValue())) {
                Object[] values;
                if (deal.getCreationDate().before(contract.getCreationDate())) {
                    values = new Object[]{contract.getCreationDate(), ""};
                    validationMessages.add(MessageFormat.format(ValidationMessages.getString("contract.dealDate"), values));
                    continue;
                }
                if (deal.getEffectiveDate().before(contract.getEffectiveDate())) {
                    values = new Object[]{contract.getEffectiveDate(), ""};
                    validationMessages.add(MessageFormat.format(ValidationMessages.getString("contract.effectiveDate"), values));
                    continue;
                }
                if (!deal.getExpiryDate().after(contract.getExpiryDate())) continue;
                values = new Object[]{contract.getExpiryDate(), ""};
                validationMessages.add(MessageFormat.format(ValidationMessages.getString("contract.expiryDate"), values));
            }
        }
    }

    private void validateDates(Contract contract, List<String> validationMessages) {
        if (contract.getCreationDate().after(contract.getEffectiveDate())) {
            validationMessages.add(ValidationMessages.getString("contract.CreationDateValidation"));
        }
        if (contract.getEffectiveDate().after(contract.getExpiryDate())) {
            validationMessages.add(ValidationMessages.getString("contract.effectiveDateValidation"));
        }
    }

    private void validateContractType(ContractType type, EntityManager entityManager, List<String> validationMessages) {
        ContractType contractType = null;
        try {
            contractType = (ContractType)entityManager.getReference(ContractType.class, (Object)type.getIdType());
        }
        catch (Exception e) {
            log.error((Object)("ContractType reference error: " + e.getMessage()));
        }
        if (contractType == null) {
            Object[] values = new Object[]{type.getType()};
            validationMessages.add(MessageFormat.format(ValidationMessages.getString("contract.type.non.existent"), values));
        }
    }
}

