/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.validation;

import com.ericsson.cms.contractmgmt.validation.ContractManagerValidator;
import com.ericsson.cms.contractmgmt.validation.ValidationMessages;
import com.ericsson.cms.contractmgmt.validation.interfaces.ILicenseDetailValidator;
import com.ericsson.ejb.DistributionManagement;
import com.ericsson.ejb.Language;
import com.ericsson.ejb.License;
import com.ericsson.ejb.LicenseDetails;
import com.ericsson.ejb.RevenuePricing;
import com.ericsson.enumeration.RevenuePricingType;
import com.ericsson.enumeration.ScreenName;
import com.ericsson.service.ContractManagerValidationException;
import com.ericsson.service.IFieldManager;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.persistence.EntityManager;

public class LicenseDetailValidator
extends ContractManagerValidator
implements ILicenseDetailValidator {
    private static String DATE_FORMAT = "MM//dd//yyyy";

    @Override
    public void validate(LicenseDetails licenseDetail, IFieldManager fieldManager, EntityManager entityManager) throws ContractManagerValidationException {
        ArrayList<String> validationMessages = new ArrayList<String>();
        if (licenseDetail == null) {
            validationMessages.add(ValidationMessages.getString("license.detail.null"));
            throw new ContractManagerValidationException(validationMessages);
        }
        this.validateStorageAndMetadata(licenseDetail, validationMessages, entityManager);
        this.validateLicenseDetailsFields(licenseDetail, validationMessages, fieldManager, entityManager);
        if (!validationMessages.isEmpty()) {
            throw new ContractManagerValidationException(validationMessages);
        }
    }

    private void validateLicenseDetailsFields(LicenseDetails licenseDetail, List<String> validationMessages, IFieldManager fieldManager, EntityManager entityManager) throws ContractManagerValidationException {
        this.validatePrice(licenseDetail, validationMessages, entityManager);
        this.validateRows(new ArrayList<RevenuePricing>(licenseDetail.getRevenuePricings()), licenseDetail.getLicense(), validationMessages, entityManager);
        this.validateDistributionData(new ArrayList<DistributionManagement>(licenseDetail.getDistributionManagements()), licenseDetail.getLicense(), validationMessages);
        this.validateAssetEnhancement(licenseDetail, validationMessages);
        super.validateCustomFields(licenseDetail.getLicenseDetailsCustomLicFieldValues(), ScreenName.LICENSE, validationMessages, "", fieldManager, entityManager);
    }

    private void validateStorageAndMetadata(LicenseDetails licenseDetail, List<String> validationMessages, EntityManager entityManager) throws ContractManagerValidationException {
        if (licenseDetail.getSmPreviewRequired() == null) {
            validationMessages.add(ValidationMessages.getString("license.detail.preview.required"));
        }
        if (licenseDetail.getSmPosterArtRequired() == null) {
            validationMessages.add(ValidationMessages.getString("license.detail.poster.art.required"));
        }
        if (licenseDetail.getLanguages() != null & !licenseDetail.getLanguages().isEmpty()) {
            for (Language language : licenseDetail.getLanguages()) {
                Language lang = null;
                try {
                    lang = (Language)entityManager.getReference(Language.class, (Object)language.getIdLanguage());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (lang != null) continue;
                Object[] values = new Object[]{language.getLanguage()};
                validationMessages.add(MessageFormat.format(ValidationMessages.getString("license.detail.language.error"), values));
            }
        } else {
            validationMessages.add(ValidationMessages.getString("license.detail.language"));
            throw new ContractManagerValidationException(validationMessages);
        }
        Date effectiveDate = licenseDetail.getSmEffectiveDate();
        Date expiryDate = licenseDetail.getSmExpiryDate();
        if (effectiveDate != null && !effectiveDate.equals(licenseDetail.getLicense().getEffectiveDate()) && effectiveDate.before(licenseDetail.getLicense().getEffectiveDate())) {
            validationMessages.add(ValidationMessages.getString("license.detail.effective.storageDateMessage"));
        }
        if (expiryDate != null && !expiryDate.equals(licenseDetail.getLicense().getExpiryDate()) && expiryDate.after(licenseDetail.getLicense().getExpiryDate())) {
            validationMessages.add(ValidationMessages.getString("license.detail.expiry.storageDateMessage"));
        }
    }

    private void validatePrice(LicenseDetails licenseDetail, List<String> validationMessages, EntityManager entityManager) throws ContractManagerValidationException {
        Float revenue;
        Float lost;
        Float buyrate;
        if (licenseDetail.getPrGuaranteedBuyRate() != null && ((buyrate = new Float(licenseDetail.getPrGuaranteedBuyRate().floatValue())).floatValue() < 0.0f || buyrate.floatValue() > 100.0f)) {
            validationMessages.add(ValidationMessages.getString("license.detail.pricingTabBuyRate"));
        }
        if (licenseDetail.getPrLostBuys() != null && ((lost = new Float(licenseDetail.getPrLostBuys().floatValue())).floatValue() < 0.0f || lost.floatValue() > 100.0f)) {
            validationMessages.add(ValidationMessages.getString("license.detail.pricingTabLostBuys"));
        }
        if (licenseDetail.getPrRevenueShare() != null && ((revenue = new Float(licenseDetail.getPrRevenueShare().floatValue())).floatValue() < 0.0f || revenue.floatValue() > 100.0f)) {
            validationMessages.add(ValidationMessages.getString("license.detail.pricingTabRevenueShare"));
        }
    }

    private void validateRows(List<RevenuePricing> rows, License license, List<String> validationMessages, EntityManager entityManager) {
        if (rows != null) {
            boolean overlap = false;
            HashSet<RevenuePricing> rpTempSet = new HashSet<RevenuePricing>();
            block0: for (int i = 0; i < rows.size(); ++i) {
                Object[] values;
                RevenuePricing rp1 = rows.get(i);
                rpTempSet.add(rp1);
                RevenuePricingType type = rp1.getType();
                if (rp1.getPrice() == null) {
                    values = new Object[]{type, i + 1, type.equals((Object)RevenuePricingType.RS) ? "Percentage" : "Price"};
                    validationMessages.add(MessageFormat.format(ValidationMessages.getString("license.detail.pricingTabPriceRequired"), values));
                }
                if (rp1.getThreshold() != null && !type.equals((Object)RevenuePricingType.RS)) continue;
                if (rp1.getToDt() != null && rp1.getFromDt() != null) {
                    this.validateRevenuePricingDate(validationMessages, license, type, i, rp1);
                    if (overlap) continue;
                    for (int j = 0; j < rows.size(); ++j) {
                        RevenuePricing rp2 = rows.get(j);
                        if (rpTempSet.contains(rp2) || rp2.getFromDt() == null || rp2.getToDt() == null || (rp2.getFromDt().before(rp1.getFromDt()) || rp2.getFromDt().after(rp1.getToDt())) && (rp2.getToDt().before(rp1.getFromDt()) || rp2.getToDt().after(rp1.getToDt()))) continue;
                        if (type.equals((Object)RevenuePricingType.RS) && rp1.getThreshold() != null && rp2.getThreshold() != null) {
                            Float rp1FloatVal = Float.valueOf(Float.parseFloat(rp1.getThreshold().toString()));
                            Float rp2FloatVal = Float.valueOf(Float.parseFloat(rp2.getThreshold().toString()));
                            if (rp1FloatVal.floatValue() != rp2FloatVal.floatValue()) continue;
                            Object[] values2 = new Object[]{type};
                            validationMessages.add(MessageFormat.format(ValidationMessages.getString("license.detail.pricingTabDatesThresholdOverlap"), values2));
                            overlap = true;
                            continue block0;
                        }
                        Object[] values3 = new Object[]{type};
                        validationMessages.add(MessageFormat.format(ValidationMessages.getString("license.detail.pricingTabDatesOverlap"), values3));
                        overlap = true;
                        continue block0;
                    }
                    continue;
                }
                values = new Object[]{type, i + 1};
                validationMessages.add(MessageFormat.format(ValidationMessages.getString("license.detail.pricingTabDatesThresholdOverlap"), values));
            }
        }
    }

    private void validateRevenuePricingDate(List<String> validationMessages, License license, RevenuePricingType type, int i, RevenuePricing rp1) {
        Object[] values;
        if (rp1.getToDt().before(rp1.getFromDt())) {
            values = new Object[]{type, i + 1};
            validationMessages.add(MessageFormat.format(ValidationMessages.getString("license.detail.pricingTabToDateBeforeFrom"), values));
        }
        if (license.getEffectiveDate() != null && license.getExpiryDate() != null && rp1.getToDt() != null && rp1.getFromDt() != null) {
            if (license.getEffectiveDate().after(rp1.getFromDt())) {
                values = new Object[]{type, i + 1, license.getEffectiveDate().toString()};
                validationMessages.add(MessageFormat.format(ValidationMessages.getString("license.detail.pricingTabLicenseEffectiveAfterFromDate"), values));
            }
            if (license.getExpiryDate().before(rp1.getToDt())) {
                values = new Object[]{type, i + 1, license.getExpiryDate().toString()};
                validationMessages.add(MessageFormat.format(ValidationMessages.getString("license.detail.pricingTabLicenseExpiryBeforeToDate"), values));
            }
        }
    }

    private void validateDistributionData(List<DistributionManagement> arrayList, License license, List<String> validationMessages) {
        this.validateUnique(arrayList);
        Date licenseEffectiveDate = license.getEffectiveDate();
        Date licenseExpiryDate = license.getExpiryDate();
        List<DistributionManagement> dmList = arrayList;
        for (int x = 0; x < dmList.size(); ++x) {
            DistributionManagement dm = dmList.get(x);
            Date deliveryDate = dm.getDeliveryDate();
            Date dueDate = dm.getDueDate();
            Date returnDate = dm.getReturnDate();
            BigDecimal cost = dm.getDeliveryCost();
            if (cost != null && cost.floatValue() < 0.0f) {
                validationMessages.add(ValidationMessages.getString("license.detail.distributionManagement.cost.positive"));
            }
            if (returnDate != null) {
                if (deliveryDate == null) {
                    validationMessages.add(ValidationMessages.getString("license.detail.deliveryDateRequired"));
                } else if (!deliveryDate.before(returnDate)) {
                    validationMessages.add(ValidationMessages.getString("license.detail.deliveryDateNotBeforeReturn"));
                }
            }
            if (dueDate != null && deliveryDate != null && deliveryDate.before(dueDate)) {
                validationMessages.add(ValidationMessages.getString("license.detail.deliveryDateBeforeDue"));
            }
            this.validateDatesWithin(deliveryDate, ValidationMessages.getString("license.detail.platformDeliveryDateColumn"), licenseEffectiveDate, licenseExpiryDate, x, validationMessages);
            this.validateDatesWithin(dueDate, ValidationMessages.getString("license.detail.platformDueDateColumn"), licenseEffectiveDate, licenseExpiryDate, x, validationMessages);
            this.validateDatesWithin(returnDate, ValidationMessages.getString("license.detail.platformReturnDateColumn"), licenseEffectiveDate, licenseExpiryDate, x, validationMessages);
        }
    }

    private void validateUnique(List<DistributionManagement> distributionManagementList) {
        for (int x = 0; x < distributionManagementList.size(); ++x) {
            DistributionManagement dm1 = distributionManagementList.get(x);
            Long methodKey1 = dm1.getDeliveryMethod().getIdDeliveryMethod();
            Long mediaKey1 = dm1.getMedia().getIdMedia();
            String formatKey1 = dm1.getMetadataFormat();
            for (int y = x + 1; y < distributionManagementList.size(); ++y) {
                DistributionManagement dm2 = distributionManagementList.get(y);
                Long methodKey2 = dm2.getDeliveryMethod().getIdDeliveryMethod();
                Long mediaKey2 = dm2.getMedia().getIdMedia();
                String formatKey2 = dm2.getMetadataFormat();
                if (!this.compareLongs(methodKey1, methodKey2) || !this.compareLongs(mediaKey1, mediaKey2) || !this.compareStrings(formatKey1, formatKey2)) continue;
                ArrayList<String> validationMessages = new ArrayList<String>();
                validationMessages.add(ValidationMessages.getString("license.detail.distributionManagementUniqueViolation"));
            }
        }
    }

    private boolean compareLongs(Long value1, Long value2) {
        boolean isEqual;
        boolean bl = isEqual = value1 == value2;
        if (!isEqual && value1 != null && value1.equals(value2)) {
            isEqual = true;
        }
        return isEqual;
    }

    private boolean compareStrings(String value1, String value2) {
        boolean isEqual;
        boolean bl = isEqual = value1 == value2;
        if (!isEqual && value1 != null && value1.equals(value2)) {
            isEqual = true;
        }
        return isEqual;
    }

    private void validateDatesWithin(Date date, String field, Date d1, Date d2, int row, List<String> validationMessages) {
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT);
        if (date != null && date.compareTo(d1) < 0 || date.compareTo(d2) > 0) {
            String d1Text = formatter.format(d1);
            String d2Text = formatter.format(d2);
            Object[] values = new Object[]{row + 1, field, d1Text, d2Text};
            validationMessages.add(MessageFormat.format(ValidationMessages.getString("license.detail.dateNotWithinError"), values));
        }
    }

    private void validateAssetEnhancement(LicenseDetails licenseDetail, List<String> validationMessages) {
        if (licenseDetail.getAeWatermarking() == null) {
            validationMessages.add(ValidationMessages.getString("license.detail.watermarking.required"));
        }
        if (licenseDetail.getAeAdRemoval() == null) {
            validationMessages.add(ValidationMessages.getString("license.detail.adremoval.required"));
        }
        if (licenseDetail.getAeContentEdit() == null) {
            validationMessages.add(ValidationMessages.getString("license.detail.contentedit.required"));
        }
        if (licenseDetail.getAeContentSecurity() == null) {
            validationMessages.add(ValidationMessages.getString("license.detail.contentsecurity.required"));
        }
        if (licenseDetail.getAeFingerprinting() == null) {
            validationMessages.add(ValidationMessages.getString(" license.detail.fingerprinting.required"));
        }
        if (licenseDetail.getAeQualityCheck() == null) {
            validationMessages.add(ValidationMessages.getString("license.detail.qualitycheck.required"));
        }
        if (licenseDetail.getAeTranscoding() == null) {
            validationMessages.add(ValidationMessages.getString("license.detail.transcoding.required"));
        }
    }
}

