/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.entitymanager;

import com.ericsson.cms.contractmgmt.audit.AuditMessages;
import com.ericsson.cms.contractmgmt.validation.LicenseValidator;
import com.ericsson.cms.contractmgmt.validation.ValidationMessages;
import com.ericsson.cms.contractmgmt.validation.interfaces.ILicenseValidator;
import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.SearchColumn;
import com.ericsson.cms.search.TitleSearchResult;
import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.ejb.Contract;
import com.ericsson.ejb.ContractContacts;
import com.ericsson.ejb.CopyHolderContacts;
import com.ericsson.ejb.CopyrightHolder;
import com.ericsson.ejb.Deal;
import com.ericsson.ejb.DealContacts;
import com.ericsson.ejb.Device;
import com.ericsson.ejb.Language;
import com.ericsson.ejb.License;
import com.ericsson.ejb.LicenseDetails;
import com.ericsson.ejb.Platform;
import com.ericsson.ejb.SmAssets;
import com.ericsson.ejb.SmAssetsId;
import com.ericsson.enumeration.AuditAction;
import com.ericsson.enumeration.AuditType;
import com.ericsson.mail.MailUtil;
import com.ericsson.rules.contract.ILicensingRule;
import com.ericsson.rules.contract.LicensingRule;
import com.ericsson.service.ContractManagerEntityNotFoundException;
import com.ericsson.service.ContractManagerValidationException;
import com.ericsson.service.IAuditManager;
import com.ericsson.service.ICMLicenseManager;
import com.ericsson.service.IFieldManager;
import com.ericsson.service.IPlatformManager;
import com.ericsson.service.ISmAssetsManager;
import com.tandbergtv.cms.title.search.ITitleSearchService;
import com.tandbergtv.watchpoint.pmm.core.PMMException;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerManagement;
import com.tandbergtv.watchpoint.search.Entity;
import com.tandbergtv.watchpoint.search.QueryBuilder;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SortParameter;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.util.SortingOrder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Local(value={ICMLicenseManager.class})
@Stateless
@TransactionAttribute
public class CMLicenseManager
implements ICMLicenseManager {
    private final ILicenseValidator validator = new LicenseValidator();
    private static final Log log = LogFactory.getLog(CMLicenseManager.class);
    private static final String NULL = "null";
    @EJB
    private IFieldManager fieldManager;
    @EJB
    private ITitleSearchService searchService;
    @EJB
    private IAuditManager auditManager;
    @EJB
    private ISmAssetsManager smAssetsManager;
    @EJB
    private ILicensingRule licensingRuleManager;
    @EJB
    private ISiteManager siteManager;
    @EJB
    private IPlatformManager platformManager;
    private final IPartnerManagement partnerManagement = (IPartnerManagement)ServiceRegistry.getDefault().lookup(IPartnerManagement.class);
    @PersistenceContext(unitName="ContractManagerRealm")
    private EntityManager entityManager;

    public void persist(License transientInstance) throws ContractManagerValidationException {
        log.debug((Object)"persisting License instance");
        this.validate(transientInstance);
        for (LicenseDetails ld : transientInstance.getLicenseDetails()) {
            ArrayList<Object> persistentLanguages = new ArrayList<Object>();
            for (Language language : ld.getLanguages()) {
                persistentLanguages.add(this.entityManager.getReference(Language.class, (Object)language.getIdLanguage()));
            }
            ld.getLanguages().clear();
            ld.getLanguages().addAll(persistentLanguages);
        }
        this.entityManager.persist((Object)transientInstance);
        log.debug((Object)"persist successful");
        Object[] values = new Object[]{transientInstance.getName(), transientInstance.getIdLicense()};
        this.auditManager.logAudit(AuditType.LICENSE.getValue(), AuditAction.CREATE.getValue(), MessageFormat.format(AuditMessages.getString("audit.license.create"), values));
        this.sendEmail(transientInstance.getName(), this.getRecipients(transientInstance), "created");
    }

    public void remove(License persistentInstance) throws ContractManagerValidationException {
        log.debug((Object)"removing License instance");
        Long licenseId = persistentInstance.getIdLicense();
        if (this.canLicenseBeDeleted(licenseId)) {
            Set<String> recipients = this.getRecipients(persistentInstance);
            String name = persistentInstance.getName();
            this.entityManager.remove((Object)persistentInstance);
            log.debug((Object)"remove successful");
            Object[] values = new Object[]{persistentInstance.getName(), persistentInstance.getIdLicense()};
            this.auditManager.logAudit(AuditType.LICENSE.getValue(), AuditAction.DELETE.getValue(), MessageFormat.format(AuditMessages.getString("audit.license.delete"), values));
            this.sendEmail(name, recipients, "deleted");
        }
    }

    private boolean canLicenseBeDeleted(Long licenseId) throws ContractManagerValidationException {
        ArrayList<String> validationMessages = new ArrayList<String>();
        boolean canDelete = true;
        LicensingRule rule = this.licensingRuleManager.getLicensingRule(licenseId.longValue());
        if (rule != null) {
            canDelete = false;
            log.debug((Object)("Rule[" + rule.getRuleName() + "(" + rule.getRuleId() + ")] associated with licenseId[" + licenseId + "]. Cannot delete license."));
            validationMessages.add("Rule[" + rule.getRuleName() + "(" + rule.getRuleId() + ")] associated with licenseId[" + licenseId + "]. Please delete the rule before you can delete the license.");
            throw new ContractManagerValidationException(validationMessages);
        }
        return canDelete;
    }

    public License merge(License detachedInstance) throws ContractManagerValidationException {
        log.debug((Object)"merging License instance");
        this.validate(detachedInstance);
        return this.mergeAndNotify(detachedInstance);
    }

    private License mergeAndNotify(License detachedInstance) {
        for (LicenseDetails ld : detachedInstance.getLicenseDetails()) {
            ArrayList<Object> persistentLanguages = new ArrayList<Object>();
            for (Language language : ld.getLanguages()) {
                persistentLanguages.add(this.entityManager.getReference(Language.class, (Object)language.getIdLanguage()));
            }
            ld.getLanguages().clear();
            ld.getLanguages().addAll(persistentLanguages);
        }
        License result = (License)this.entityManager.merge((Object)detachedInstance);
        log.debug((Object)"merge successful");
        Object[] values = new Object[]{detachedInstance.getName(), detachedInstance.getIdLicense()};
        this.auditManager.logAudit(AuditType.LICENSE.getValue(), AuditAction.UPDATE.getValue(), MessageFormat.format(AuditMessages.getString("audit.license.update"), values));
        this.sendEmail(detachedInstance.getName(), this.getRecipients(detachedInstance), "modified");
        return result;
    }

    public License findById(Long id) {
        log.debug((Object)("getting License instance with id: " + id));
        License license = (License)this.entityManager.find(License.class, (Object)id);
        log.debug((Object)"get successful");
        return license;
    }

    public License findByName(String name) {
        log.debug((Object)("getting License instance with name: " + name));
        Query query = this.entityManager.createQuery("SELECT license FROM License license WHERE license.name=:NAME");
        query.setParameter("NAME", (Object)name);
        List licenses = query.getResultList();
        return licenses.isEmpty() ? null : (License)licenses.get(0);
    }

    public License getFullLicense(Long key) {
        Query query = this.entityManager.createQuery("SELECT DISTINCT license from License license LEFT JOIN FETCH license.deal d LEFT JOIN FETCH d.contract c LEFT JOIN FETCH c.copyrightHolder ch LEFT JOIN FETCH license.licenseDetails ld LEFT JOIN FETCH ld.distributionManagements LEFT JOIN FETCH ld.licenseDetailsCustomLicFieldValues LEFT JOIN FETCH ld.revenuePricings LEFT JOIN FETCH ld.languages LEFT JOIN FETCH ld.platform LEFT JOIN FETCH ld.device LEFT JOIN FETCH license.licenseCustomLicFieldValues LEFT JOIN FETCH license.licenseType LEFT JOIN FETCH license.smAssets WHERE license.idLicense = :ID");
        query.setParameter("ID", (Object)key);
        log.debug((Object)"get successful");
        return (License)query.getSingleResult();
    }

    public License getFullLicenseForXml(Long key) {
        Query query = this.entityManager.createQuery("SELECT DISTINCT license from License license LEFT JOIN FETCH license.deal d LEFT JOIN FETCH license.licenseDetails ld LEFT JOIN FETCH ld.currency LEFT JOIN FETCH ld.distributionManagements dm LEFT JOIN FETCH dm.deliveryMethod LEFT JOIN FETCH dm.ownership LEFT JOIN FETCH dm.media LEFT JOIN FETCH ld.licenseDetailsCustomLicFieldValues ldcf LEFT JOIN FETCH ldcf.field fld LEFT JOIN FETCH fld.fieldDropdowns LEFT JOIN FETCH ld.revenuePricings rp LEFT JOIN FETCH rp.currency LEFT JOIN FETCH ld.languages LEFT JOIN FETCH ld.platform LEFT JOIN FETCH ld.device LEFT JOIN FETCH license.licenseCustomLicFieldValues lcf LEFT JOIN FETCH lcf.field fld LEFT JOIN FETCH fld.fieldDropdowns LEFT JOIN FETCH license.licenseType LEFT JOIN FETCH license.smAssets WHERE license.idLicense = :ID");
        query.setParameter("ID", (Object)key);
        log.debug((Object)"get successful");
        return (License)query.getSingleResult();
    }

    public License getFullLicenseForIngest(Long key) {
        License license = null;
        Query query = this.entityManager.createQuery("SELECT DISTINCT license from License license LEFT JOIN FETCH license.deal d LEFT JOIN FETCH license.licenseDetails ld LEFT JOIN FETCH ld.currency LEFT JOIN FETCH ld.distributionManagements dm LEFT JOIN FETCH dm.deliveryMethod LEFT JOIN FETCH dm.ownership LEFT JOIN FETCH dm.media LEFT JOIN FETCH ld.licenseDetailsCustomLicFieldValues ldcf LEFT JOIN FETCH ldcf.field fld LEFT JOIN FETCH fld.fieldDropdowns LEFT JOIN FETCH ld.revenuePricings rp LEFT JOIN FETCH rp.currency LEFT JOIN FETCH ld.languages LEFT JOIN FETCH ld.platform LEFT JOIN FETCH ld.device LEFT JOIN FETCH license.licenseDocuments LEFT JOIN FETCH license.licenseCustomLicFieldValues lcf LEFT JOIN FETCH lcf.field fld LEFT JOIN FETCH fld.fieldDropdowns LEFT JOIN FETCH license.licenseType LEFT JOIN FETCH license.smAssets WHERE license.idLicense = :ID");
        query.setParameter("ID", (Object)key);
        log.debug((Object)"get successful");
        try {
            license = (License)query.getSingleResult();
        }
        catch (NoResultException e) {
            log.error((Object)"the license is not exists. ", (Throwable)e);
        }
        return license;
    }

    public License getFullLicenseForIngestByExternalId(String key) {
        Query query = this.entityManager.createQuery("SELECT DISTINCT license from License license LEFT JOIN FETCH license.deal d LEFT JOIN FETCH license.licenseDetails ld LEFT JOIN FETCH ld.currency LEFT JOIN FETCH ld.distributionManagements dm LEFT JOIN FETCH dm.deliveryMethod LEFT JOIN FETCH dm.ownership LEFT JOIN FETCH dm.media LEFT JOIN FETCH ld.licenseDetailsCustomLicFieldValues ldcf LEFT JOIN FETCH ldcf.field fld LEFT JOIN FETCH fld.fieldDropdowns LEFT JOIN FETCH ld.revenuePricings rp LEFT JOIN FETCH rp.currency LEFT JOIN FETCH ld.languages LEFT JOIN FETCH ld.platform LEFT JOIN FETCH ld.device LEFT JOIN FETCH license.licenseDocuments LEFT JOIN FETCH license.licenseCustomLicFieldValues lcf LEFT JOIN FETCH lcf.field fld LEFT JOIN FETCH fld.fieldDropdowns LEFT JOIN FETCH license.licenseType LEFT JOIN FETCH license.smAssets WHERE license.externalId = :ID");
        query.setParameter("ID", (Object)key);
        log.debug((Object)"get successful");
        return (License)query.getSingleResult();
    }

    public List<License> findByDealId(Long dealId) {
        Query query = this.entityManager.createQuery("SELECT license from License license WHERE license.deal.idDeal = " + dealId);
        log.debug((Object)"get successful");
        return query.getResultList();
    }

    public int count() {
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("license", License.class, "lic");
        criteria.addParameter((SearchParameterBase)e);
        String s = QueryBuilder.newInstance().buildCountQuery(criteria);
        Query query = this.entityManager.createQuery(s);
        long count = (Long)query.getSingleResult();
        return (int)count;
    }

    public List<License> getAllLicenses() {
        Query query = this.entityManager.createQuery("SELECT license from License license JOIN FETCH license.licenseType");
        List licenses = query.getResultList();
        log.debug((Object)"get successful");
        return licenses;
    }

    public List<License> getLicenses(int start, int length, String sortProperty, boolean isAscending) {
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("license", License.class, "lic");
        SortingOrder sortOrder = SortingOrder.ASCENDING;
        if (!isAscending) {
            sortOrder = SortingOrder.DESCENDING;
        }
        e.addParameter((SearchParameterBase)new SortParameter(sortProperty, sortOrder));
        criteria.addParameter((SearchParameterBase)e);
        criteria.setStartingRecordNumber(start);
        criteria.setRecordsCount(length);
        String s = this.getQuery(criteria);
        Query query = this.entityManager.createQuery(s);
        query.setFirstResult(start);
        query.setMaxResults(criteria.getRecordsCount() == 0 ? Integer.MAX_VALUE : criteria.getRecordsCount());
        return query.getResultList();
    }

    public List<License> getLicenses(int start, int count, Date modifiedAfter, Long titleId, String providerId, Boolean active) throws ContractManagerEntityNotFoundException {
        String qry = "select distinct lic from License lic left JOIN lic.smAssets assets ";
        String orderBy = " order by lic.idLicense";
        String whereClause = "";
        boolean add = false;
        if (modifiedAfter != null || titleId != null || providerId != null || active != null) {
            whereClause = " where ";
        }
        if (modifiedAfter != null) {
            qry = qry + whereClause + " lic.updateDate >= :modifiedAfter ";
            add = true;
        }
        if (titleId != null) {
            qry = qry + (add ? " and " : whereClause) + " (assets.id.idAsset = :titleId ) ";
            add = true;
        }
        if (providerId != null) {
            qry = NULL.equals(providerId.trim()) ? qry + (add ? " and " : whereClause) + " (lic.contentProvider = :providerId or lic.contentProvider is null ) " : qry + (add ? " and " : whereClause) + " (lic.contentProvider = :providerId ) ";
            add = true;
        }
        if (active != null) {
            qry = qry + (add ? " and " : whereClause) + " lic.active = :isActive ";
            add = true;
        }
        qry = qry + orderBy;
        Query query = this.entityManager.createQuery(qry);
        if (active != null) {
            query.setParameter("isActive", (Object)active);
        }
        if (providerId != null) {
            query.setParameter("providerId", (Object)providerId);
        }
        if (titleId != null) {
            query.setParameter("titleId", (Object)titleId.toString());
        }
        if (modifiedAfter != null) {
            query.setParameter("modifiedAfter", modifiedAfter, TemporalType.TIMESTAMP);
        }
        query.setFirstResult(start);
        query.setMaxResults(count);
        List licenses = query.getResultList();
        log.debug((Object)"get successful");
        return licenses;
    }

    private String getQuery(SearchCriteria criteria) {
        return QueryBuilder.newInstance().buildQuery(criteria);
    }

    private void validate(License license) throws ContractManagerValidationException {
        if (license == null) {
            throw new ContractManagerValidationException(ValidationMessages.getString("audit.license.null"));
        }
        if (license.getContentProvider() != null) {
            try {
                this.partnerManagement.getSourceOrSelfPartner(license.getContentProvider());
            }
            catch (PMMException e) {
                throw new ContractManagerValidationException(e.getMessage(), (Throwable)e);
            }
        }
        for (LicenseDetails ld : license.getLicenseDetails()) {
            if (ld.getDeliveryLocation() != null && this.siteManager.getSiteByName(ld.getDeliveryLocation().trim()) == null) {
                throw new ContractManagerValidationException("Site [" + ld.getDeliveryLocation() + "] does not exist in CMS.");
            }
            if (ld.getPlatform() == null) continue;
            Platform platform = this.platformManager.findByName(ld.getPlatform().getDescription().trim());
            if (platform == null) {
                throw new ContractManagerValidationException("Platform [" + ld.getPlatform() + "] does not exist in CMS.");
            }
            if (ld.getDevice() == null) continue;
            boolean foundIt = false;
            for (Device device : platform.getDevices()) {
                if (!(device != null & device.getDeviceName().trim().equals(ld.getDevice().getDeviceName().trim()))) continue;
                foundIt = true;
                break;
            }
            if (foundIt) continue;
            throw new ContractManagerValidationException("Device [" + ld.getDevice() + "] does not exist for Platform [" + platform.getDescription() + "] .");
        }
        this.validator.validate(license, this.fieldManager, this.entityManager, this);
    }

    public void addAssets(long licenseId, List<Long> titleIds) throws ContractManagerValidationException {
        License license = this.findById(licenseId);
        Map<Long, String> titleProviderMap = this.getAssets(titleIds);
        ArrayList<Long> titleIdsToAdd = new ArrayList<Long>();
        if (license != null) {
            for (Long titleId : titleIds) {
                String providerId;
                if (this.assetAlreadyAdded(license, titleId) || (providerId = titleProviderMap.get(titleId)) == null || license.getContentProvider() != null && !providerId.equals(license.getContentProvider())) continue;
                titleIdsToAdd.add(titleId);
            }
            for (Long titleId : titleIdsToAdd) {
                this.addSmAssetsToLicense(licenseId, license, titleId);
            }
        }
        this.merge(license);
    }

    private void addSmAssetsToLicense(long licenseId, License license, Long titleId) {
        SmAssetsId smAssetsId = new SmAssetsId(titleId.toString(), Long.valueOf(licenseId));
        SmAssets smAssets = new SmAssets(smAssetsId, license);
        license.getSmAssets().add(smAssets);
    }

    private Map<Long, String> getAssets(List<Long> assetIds) {
        ArrayList<SearchColumn> sc = new ArrayList<SearchColumn>();
        sc.add(new SearchColumn("Package/Title", "/Fields/ProviderInfo/Identifier/Id", FieldType.ASSET, "string", false));
        HashMap<Long, String> titleProviderMap = new HashMap<Long, String>();
        TitleSearchResult result = this.searchService.getMasterTitleSearchResults(assetIds, sc);
        if (result != null) {
            List searchResults = result.getRows();
            for (TitleSearchResult.SearchRow searchRow : searchResults) {
                titleProviderMap.put(searchRow.getId(), searchRow.getFirstValueAsString(0));
            }
        }
        return titleProviderMap;
    }

    private boolean assetAlreadyAdded(License license, Long id) {
        boolean alreadyAdded = false;
        for (SmAssets smAssets : license.getSmAssets()) {
            if (!smAssets.getId().getIdAsset().equals(id.toString())) continue;
            alreadyAdded = true;
            break;
        }
        return alreadyAdded;
    }

    private void sendEmail(String name, Set<String> recipients, String activity) {
        String subject = "License " + activity;
        String body = "License " + name + " was " + activity;
        MailUtil.sendMail(subject, body, recipients);
    }

    private Set<String> getRecipients(License license) {
        HashSet<String> recipients = new HashSet<String>();
        Deal deal = (Deal)this.entityManager.getReference(Deal.class, (Object)license.getDeal().getIdDeal());
        Contract contract = deal.getContract();
        CopyrightHolder copyrightHolder = contract.getCopyrightHolder();
        for (CopyHolderContacts copyrightHolderContact : copyrightHolder.getCopyHolderContacts()) {
            if (copyrightHolderContact.getNotify() == null || !copyrightHolderContact.getNotify().booleanValue()) continue;
            recipients.add(copyrightHolderContact.getEmail());
        }
        for (ContractContacts contractContact : contract.getContractContacts()) {
            if (contractContact.getNotify() == null || !contractContact.getNotify().booleanValue()) continue;
            recipients.add(contractContact.getEmail());
        }
        for (DealContacts dealContact : deal.getDealContacts()) {
            if (dealContact.getNotify() == null || !dealContact.getNotify().booleanValue()) continue;
            recipients.add(dealContact.getEmail());
        }
        return recipients;
    }

    public License associateTitle(Long licenseId, Long titleId) throws ContractManagerValidationException {
        if (titleId != null) {
            ArrayList<String> validationMessages = new ArrayList<String>();
            License license = this.findById(licenseId);
            ArrayList<Long> titleIds = new ArrayList<Long>();
            titleIds.add(titleId);
            Map<Long, String> titleProviderMap = this.getAssets(titleIds);
            if (license != null) {
                String providerId = titleProviderMap.get(titleId);
                if (providerId != null) {
                    if (license.getContentProvider() == null || providerId.equals(license.getContentProvider())) {
                        if (!this.assetAlreadyAdded(license, titleId)) {
                            List associatedAssets = this.smAssetsManager.getAssociatedAssetsList(titleId.longValue());
                            if (associatedAssets != null) {
                                boolean found = false;
                                for (SmAssets smAsset : associatedAssets) {
                                    if (new Long(smAsset.getId().getIdAsset()).longValue() != titleId.longValue()) continue;
                                    found = true;
                                    validationMessages.add("Title with titleId: [" + titleId + "] is already associated with License [" + smAsset.getId().getIdLicense() + "]");
                                }
                                if (!found) {
                                    this.addSmAssetsToLicense(licenseId, license, titleId);
                                }
                            } else {
                                this.addSmAssetsToLicense(licenseId, license, titleId);
                            }
                        } else {
                            log.info((Object)("Title with titleId: [" + titleId + "] is already associated with License [" + licenseId + "] and template is trying to re-associate."));
                        }
                    } else {
                        validationMessages.add("Title with titleId: [" + titleId + "] cannot associated with License [" + licenseId + "] as it belongs to a different Content Provider as compared to the License...");
                    }
                } else {
                    validationMessages.add("Stop Piracy!!! Identify who is the provider of the content and I will be able to associate the title to a license.");
                }
            } else {
                validationMessages.add("Title with titleId: [" + titleId + "] cannot associated with License [" + licenseId + "] as we could not find the License...");
            }
            if (!validationMessages.isEmpty()) {
                throw new ContractManagerValidationException(validationMessages);
            }
            return this.mergeAndNotify(license);
        }
        return null;
    }

    public List<Long> getActiveLicenses(List<Long> licenseIds) {
        Query query = this.entityManager.createQuery("SELECT distinct license.idLicense from License license WHERE license.expiryDate >= :currentDate AND license.active = :isActive AND license.idLicense IN (:licenseIds)");
        query.setParameter("currentDate", new Date(), TemporalType.TIMESTAMP);
        query.setParameter("isActive", (Object)Boolean.TRUE);
        query.setParameter("licenseIds", licenseIds);
        List activeLicenseIds = query.getResultList();
        log.debug((Object)"get successful");
        return activeLicenseIds;
    }
}

