/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.entitymanager;

import com.ericsson.cms.contractmgmt.audit.AuditMessages;
import com.ericsson.ejb.ContractDocuments;
import com.ericsson.enumeration.AuditAction;
import com.ericsson.enumeration.AuditType;
import com.ericsson.service.IAuditManager;
import com.ericsson.service.IContractDocumentsManager;
import java.text.MessageFormat;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Local(value={IContractDocumentsManager.class})
@Stateless
public class ContractDocumentsManager
implements IContractDocumentsManager {
    private static final Log log = LogFactory.getLog(ContractDocumentsManager.class);
    @EJB
    private IAuditManager auditManager;
    @PersistenceContext(unitName="ContractManagerRealm")
    private EntityManager entityManager;

    public void persist(ContractDocuments transientInstance) {
        log.debug((Object)"persisting ContractDocuments instance");
        try {
            this.entityManager.persist((Object)transientInstance);
            this.entityManager.flush();
            log.debug((Object)"persist successful");
            Object[] values = new Object[]{transientInstance.getFileName(), transientInstance.getIdDocument()};
            this.auditManager.logAudit(AuditType.CONTRACT.getValue(), AuditAction.CREATE.getValue(), MessageFormat.format(AuditMessages.getString("audit.contract.document.create"), values));
        }
        catch (RuntimeException re) {
            log.error((Object)"persist failed", (Throwable)re);
            throw re;
        }
    }

    public void remove(ContractDocuments persistentInstance) {
        log.debug((Object)"removing ContractDocuments instance");
        try {
            this.entityManager.remove((Object)persistentInstance);
            log.debug((Object)"remove successful");
            Object[] values = new Object[]{persistentInstance.getFileName(), persistentInstance.getIdDocument()};
            this.auditManager.logAudit(AuditType.CONTRACT.getValue(), AuditAction.DELETE.getValue(), MessageFormat.format(AuditMessages.getString("audit.contract.document.delete"), values));
        }
        catch (RuntimeException re) {
            log.error((Object)"remove failed", (Throwable)re);
            throw re;
        }
    }

    public ContractDocuments merge(ContractDocuments detachedInstance) {
        log.debug((Object)"merging ContractDocuments instance");
        try {
            ContractDocuments result = (ContractDocuments)this.entityManager.merge((Object)detachedInstance);
            this.entityManager.flush();
            log.debug((Object)"merge successful");
            Object[] values = new Object[]{detachedInstance.getFileName(), detachedInstance.getIdDocument()};
            this.auditManager.logAudit(AuditType.CONTRACT.getValue(), AuditAction.UPDATE.getValue(), MessageFormat.format(AuditMessages.getString("audit.contract.document.update"), values));
            return result;
        }
        catch (RuntimeException re) {
            log.error((Object)"merge failed", (Throwable)re);
            throw re;
        }
    }

    public ContractDocuments findById(long id) {
        log.debug((Object)("getting ContractDocuments instance with id: " + id));
        try {
            ContractDocuments instance = (ContractDocuments)this.entityManager.find(ContractDocuments.class, (Object)id);
            log.debug((Object)"get successful");
            return instance;
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }

    public List<ContractDocuments> findByContract(long contractId) {
        try {
            Query query = this.entityManager.createQuery("SELECT docs from ContractDocuments docs WHERE docs.contract.idContract = " + contractId);
            log.debug((Object)"get successful");
            return query.getResultList();
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }
}

