/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.entitymanager;

import com.ericsson.cms.contractmgmt.audit.AuditMessages;
import com.ericsson.cms.contractmgmt.validation.CopyrightHolderContactsValidator;
import com.ericsson.cms.contractmgmt.validation.interfaces.ICopyrightHolderContactsValidator;
import com.ericsson.ejb.CopyHolderContacts;
import com.ericsson.enumeration.AuditAction;
import com.ericsson.enumeration.AuditType;
import com.ericsson.service.ContractManagerValidationException;
import com.ericsson.service.IAuditManager;
import com.ericsson.service.ICopyHolderContactsManager;
import com.tandbergtv.watchpoint.search.Entity;
import com.tandbergtv.watchpoint.search.QueryBuilder;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.SortParameter;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.util.SortingOrder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Local(value={ICopyHolderContactsManager.class})
@Stateless
public class CopyHolderContactsManager
implements ICopyHolderContactsManager {
    private static final Log log = LogFactory.getLog(CopyHolderContactsManager.class);
    @EJB
    private IAuditManager auditManager;
    private final ICopyrightHolderContactsValidator contactsValidator = new CopyrightHolderContactsValidator();
    @PersistenceContext(unitName="ContractManagerRealm")
    private EntityManager entityManager;

    public void persist(CopyHolderContacts transientInstance) throws ContractManagerValidationException {
        log.debug((Object)"persisting CopyHolderContacts instance");
        try {
            this.validate(transientInstance);
            this.entityManager.persist((Object)transientInstance);
            log.debug((Object)"persist successful");
            Object[] values = new Object[]{transientInstance.getName(), transientInstance.getIdContact()};
            this.auditManager.logAudit(AuditType.COPYRIGHT.getValue(), AuditAction.CREATE.getValue(), MessageFormat.format(AuditMessages.getString("audit.copyright.contact.create"), values));
        }
        catch (ContractManagerValidationException re) {
            log.error((Object)"Persist failed due to validation", (Throwable)re);
            throw re;
        }
        catch (RuntimeException re) {
            log.error((Object)"persist failed", (Throwable)re);
            throw re;
        }
    }

    public void remove(CopyHolderContacts persistentInstance) {
        log.debug((Object)"removing CopyHolderContacts instance");
        try {
            this.entityManager.remove((Object)persistentInstance);
            log.debug((Object)"remove successful");
            Object[] values = new Object[]{persistentInstance.getName(), persistentInstance.getIdContact()};
            this.auditManager.logAudit(AuditType.COPYRIGHT.getValue(), AuditAction.DELETE.getValue(), MessageFormat.format(AuditMessages.getString("audit.copyright.contact.delete"), values));
        }
        catch (RuntimeException re) {
            log.error((Object)"remove failed", (Throwable)re);
            throw re;
        }
    }

    public CopyHolderContacts merge(CopyHolderContacts detachedInstance) throws ContractManagerValidationException {
        log.debug((Object)"merging CopyHolderContacts instance");
        try {
            this.validate(detachedInstance);
            CopyHolderContacts result = (CopyHolderContacts)this.entityManager.merge((Object)detachedInstance);
            log.debug((Object)"merge successful");
            Object[] values = new Object[]{detachedInstance.getName(), detachedInstance.getIdContact()};
            this.auditManager.logAudit(AuditType.COPYRIGHT.getValue(), AuditAction.UPDATE.getValue(), MessageFormat.format(AuditMessages.getString("audit.copyright.contact.update"), values));
            return result;
        }
        catch (ContractManagerValidationException re) {
            log.error((Object)"merge failed", (Throwable)re);
            throw re;
        }
        catch (RuntimeException re) {
            log.error((Object)"merge failed", (Throwable)re);
            throw re;
        }
    }

    public CopyHolderContacts findById(long id) {
        log.debug((Object)("getting CopyHolderContacts instance with id: " + id));
        try {
            CopyHolderContacts instance = (CopyHolderContacts)this.entityManager.find(CopyHolderContacts.class, (Object)id);
            log.debug((Object)"get successful");
            return instance;
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }

    public List<CopyHolderContacts> findByCopyrightHolder(long copyrightHolderId) {
        try {
            Query query = this.entityManager.createQuery("SELECT contacts from CopyHolderContacts contacts WHERE contacts.copyrightHolder.idCopyrightHolder = " + copyrightHolderId);
            log.debug((Object)"get successful");
            return query.getResultList();
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }

    public List<CopyHolderContacts> getCopyrightHoldersContacts(Long copyrightHolderKey, String sortProperty, boolean isAscending) {
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("CopyHolderContacts", CopyHolderContacts.class, "copyHolderContacts");
        SortingOrder sortOrder = SortingOrder.ASCENDING;
        if (!isAscending) {
            sortOrder = SortingOrder.DESCENDING;
        }
        e.addParameter((SearchParameterBase)new SortParameter(sortProperty, sortOrder));
        e.addParameter((SearchParameterBase)new ValueParameter("copyrightHolder", SearchType.NUMERIC, (Object)copyrightHolderKey));
        criteria.addParameter((SearchParameterBase)e);
        String s = this.getQuery(criteria);
        Query query = this.entityManager.createQuery(s);
        return query.getResultList();
    }

    private String getQuery(SearchCriteria criteria) {
        return QueryBuilder.newInstance().buildQuery(criteria);
    }

    private void validate(CopyHolderContacts instance) throws ContractManagerValidationException {
        try {
            HashSet<CopyHolderContacts> contacts = new HashSet<CopyHolderContacts>(0);
            ArrayList<CopyHolderContacts> existentContacts = null;
            if (instance.getCopyrightHolder() != null) {
                existentContacts = new ArrayList<CopyHolderContacts>(this.findByCopyrightHolder(instance.getCopyrightHolder().getIdCopyrightHolder()));
            }
            contacts.add(instance);
            this.contactsValidator.validate(contacts, existentContacts);
        }
        catch (ContractManagerValidationException e) {
            log.error((Object)"CopyrightHolderContact Validation failed", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            log.error((Object)"RuntimeException inside CopyrightHolderContact Validation ", (Throwable)e);
            throw e;
        }
    }
}

