/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.entitymanager;

import com.ericsson.ejb.Currency;
import com.ericsson.enumeration.FieldType;
import com.ericsson.service.ContractManagerValidationException;
import com.ericsson.service.ICurrencyManager;
import com.ericsson.service.IFieldManager;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Local(value={ICurrencyManager.class})
@Stateless
public class CurrencyManager
implements ICurrencyManager {
    private static final Log log = LogFactory.getLog(CurrencyManager.class);
    @EJB
    private IFieldManager fieldManager;
    @PersistenceContext(unitName="ContractManagerRealm")
    private EntityManager entityManager;
    private List<Currency> allCurrenciesCache = new ArrayList<Currency>();

    public void persist(Currency transientInstance) throws ContractManagerValidationException {
        log.debug((Object)"persisting Currency instance");
        this.isExists(transientInstance);
        this.entityManager.persist((Object)transientInstance);
        this.reloadAllCurrenciesCache();
        log.debug((Object)"persist successful");
    }

    public void remove(Currency persistentInstance) throws ContractManagerValidationException {
        log.debug((Object)"removing Currency instance");
        this.isCurrencyUsed(persistentInstance);
        this.entityManager.remove((Object)persistentInstance);
        this.reloadAllCurrenciesCache();
        log.debug((Object)"remove successful");
    }

    private void isCurrencyUsed(Currency persistentInstance) throws ContractManagerValidationException {
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (persistentInstance.getRevenuePricings().isEmpty() && persistentInstance.getLicenseDetails().isEmpty()) {
            List fields = null;
            fields = this.fieldManager.findByTypeAndValue(FieldType.Currency, persistentInstance.getIdCurrency().toString());
            if (fields != null && !fields.isEmpty()) {
                validationErrors.add("The Currency (" + persistentInstance.getNameAndSymbol() + ") is used as a value [default or otherwise], and hence cannot be deleted at this time!");
                throw new ContractManagerValidationException(validationErrors);
            }
        } else {
            validationErrors.add("Currency (" + persistentInstance.getNameAndSymbol() + ") is associated with a License!");
            throw new ContractManagerValidationException(validationErrors);
        }
    }

    public Currency merge(Currency detachedInstance) throws ContractManagerValidationException {
        log.debug((Object)"merging Currency instance");
        this.isExists(detachedInstance);
        Currency result = (Currency)this.entityManager.merge((Object)detachedInstance);
        log.debug((Object)"merge successful");
        this.reloadAllCurrenciesCache();
        return result;
    }

    private void reloadAllCurrenciesCache() {
        this.allCurrenciesCache.clear();
        this.getAllCurrencies();
    }

    public Currency findById(long id) {
        log.debug((Object)("getting Currency instance with id: " + id));
        try {
            Currency instance = (Currency)this.entityManager.find(Currency.class, (Object)id);
            log.debug((Object)"get successful");
            return instance;
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }

    public List<Currency> getAllCurrencies() {
        if (this.allCurrenciesCache.size() == 0) {
            Query query = this.entityManager.createQuery("SELECT currency from Currency currency");
            List result = query.getResultList();
            log.debug((Object)"get successful");
            if (result != null) {
                this.allCurrenciesCache.addAll(result);
            }
        }
        return new ArrayList<Currency>(this.allCurrenciesCache);
    }

    private void isExists(Currency transientInstance) throws ContractManagerValidationException {
        Currency existing = this.findByNameAndSymbol(transientInstance.getName(), transientInstance.getSymbol());
        if (existing != null && (transientInstance.getIdCurrency() == null || existing.getIdCurrency().longValue() != transientInstance.getIdCurrency().longValue())) {
            ArrayList<String> validationErrors = new ArrayList<String>();
            validationErrors.add("Currency already exists!");
            throw new ContractManagerValidationException(validationErrors);
        }
    }

    private Currency findByNameAndSymbol(String name, String symbol) {
        try {
            Query query = this.entityManager.createQuery("SELECT currency from Currency currency WHERE currency.name = :name and currency.symbol = :symbol");
            query.setParameter("symbol", (Object)symbol);
            query.setParameter("name", (Object)name);
            log.debug((Object)"get successful");
            try {
                return (Currency)query.getSingleResult();
            }
            catch (NoResultException e) {
                return null;
            }
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }

    public Currency findByName(String name) {
        try {
            Query query = this.entityManager.createQuery("SELECT currency from Currency currency WHERE currency.name = :name");
            query.setParameter("name", (Object)name);
            log.debug((Object)"get successful");
            try {
                return (Currency)query.getSingleResult();
            }
            catch (NoResultException e) {
                return null;
            }
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }
}

