/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.entitymanager;

import com.ericsson.ejb.Contract;
import com.ericsson.ejb.CopyrightHolder;
import com.ericsson.ejb.CustomLicFieldValue;
import com.ericsson.ejb.Deal;
import com.ericsson.ejb.License;
import com.ericsson.ejb.LicenseDetails;
import com.ericsson.service.ICustomLicFieldValueManager;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Local(value={ICustomLicFieldValueManager.class})
@Stateless
public class CustomLicFieldValueManager
implements ICustomLicFieldValueManager {
    private static final Log log = LogFactory.getLog(CustomLicFieldValueManager.class);
    @PersistenceContext(unitName="ContractManagerRealm")
    private EntityManager entityManager;

    public void persist(CustomLicFieldValue transientInstance) {
        log.debug((Object)"persisting CustomLicFieldValue instance");
        try {
            this.entityManager.persist((Object)transientInstance);
            log.debug((Object)"persist successful");
        }
        catch (RuntimeException re) {
            log.error((Object)"persist failed", (Throwable)re);
            throw re;
        }
    }

    public void remove(CustomLicFieldValue persistentInstance) {
        log.debug((Object)"removing CustomLicFieldValue instance");
        try {
            this.entityManager.remove((Object)persistentInstance);
            log.debug((Object)"remove successful");
        }
        catch (RuntimeException re) {
            log.error((Object)"remove failed", (Throwable)re);
            throw re;
        }
    }

    public CustomLicFieldValue merge(CustomLicFieldValue detachedInstance) {
        log.debug((Object)"merging CustomLicFieldValue instance");
        try {
            CustomLicFieldValue result = (CustomLicFieldValue)this.entityManager.merge((Object)detachedInstance);
            log.debug((Object)"merge successful");
            return result;
        }
        catch (RuntimeException re) {
            log.error((Object)"merge failed", (Throwable)re);
            throw re;
        }
    }

    public CustomLicFieldValue findById(long id) {
        log.debug((Object)("getting CustomLicFieldValue instance with id: " + id));
        try {
            CustomLicFieldValue instance = (CustomLicFieldValue)this.entityManager.find(CustomLicFieldValue.class, (Object)id);
            log.debug((Object)"get successful");
            return instance;
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }

    public CustomLicFieldValue findByFieldIdEntityId(Long id, Object entity) {
        log.debug((Object)("getting CustomLicFieldValue instance with field id: " + id));
        try {
            CopyrightHolder copy = null;
            Contract contract = null;
            Deal deal = null;
            License license = null;
            LicenseDetails licenseDetails = null;
            Query query = null;
            if (entity instanceof CopyrightHolder) {
                copy = (CopyrightHolder)entity;
                query = this.entityManager.createQuery("SELECT customLicFieldValue from CustomLicFieldValue customLicFieldValue where customLicFieldValue.field.idField = :ID and customLicFieldValue.copyrightHolder = :copy");
                query.setParameter("ID", (Object)id);
                query.setParameter("copy", (Object)copy);
            } else if (entity instanceof Contract) {
                contract = (Contract)entity;
                query = this.entityManager.createQuery("SELECT customLicFieldValue from CustomLicFieldValue customLicFieldValue where customLicFieldValue.field.idField = :ID and customLicFieldValue.contract = :contract");
                query.setParameter("ID", (Object)id);
                query.setParameter("contract", (Object)contract);
            } else if (entity instanceof Deal) {
                deal = (Deal)entity;
                query = this.entityManager.createQuery("SELECT customLicFieldValue from CustomLicFieldValue customLicFieldValue where customLicFieldValue.field.idField = :ID and customLicFieldValue.deal = :deal");
                query.setParameter("ID", (Object)id);
                query.setParameter("deal", (Object)deal);
            } else if (entity instanceof License) {
                license = (License)entity;
                query = this.entityManager.createQuery("SELECT customLicFieldValue from CustomLicFieldValue customLicFieldValue where customLicFieldValue.field.idField = :ID and customLicFieldValue.license = :license");
                query.setParameter("ID", (Object)id);
                query.setParameter("license", (Object)license);
            } else if (entity instanceof LicenseDetails) {
                licenseDetails = (LicenseDetails)entity;
                query = this.entityManager.createQuery("SELECT customLicFieldValue from CustomLicFieldValue customLicFieldValue where customLicFieldValue.field.idField = :ID and customLicFieldValue.licenseDetails = :licenseDetails");
                query.setParameter("ID", (Object)id);
                query.setParameter("licenseDetails", (Object)licenseDetails);
            }
            CustomLicFieldValue instance = (CustomLicFieldValue)query.getSingleResult();
            log.debug((Object)"get successful");
            return instance;
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            return null;
        }
    }
}

