/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.entitymanager;

import com.ericsson.cms.contractmgmt.audit.AuditMessages;
import com.ericsson.cms.contractmgmt.validation.DealContactsValidator;
import com.ericsson.cms.contractmgmt.validation.DealValidator;
import com.ericsson.cms.contractmgmt.validation.interfaces.IDealContactsValidator;
import com.ericsson.cms.contractmgmt.validation.interfaces.IDealManagerValidator;
import com.ericsson.ejb.Audit;
import com.ericsson.ejb.Contract;
import com.ericsson.ejb.ContractContacts;
import com.ericsson.ejb.CopyHolderContacts;
import com.ericsson.ejb.CopyrightHolder;
import com.ericsson.ejb.Deal;
import com.ericsson.ejb.DealContacts;
import com.ericsson.ejb.ExpiringDetail;
import com.ericsson.ejb.License;
import com.ericsson.enumeration.AuditAction;
import com.ericsson.enumeration.AuditType;
import com.ericsson.mail.MailUtil;
import com.ericsson.service.ContractManagerValidationException;
import com.ericsson.service.IAuditManager;
import com.ericsson.service.ICMLicenseManager;
import com.ericsson.service.IDealContactsManager;
import com.ericsson.service.IDealManager;
import com.ericsson.service.IFieldManager;
import com.tandbergtv.watchpoint.search.Entity;
import com.tandbergtv.watchpoint.search.QueryBuilder;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SortParameter;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.util.SortingOrder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Local(value={IDealManager.class})
@Stateless
public class DealManager
implements IDealManager {
    private static final Log log = LogFactory.getLog(DealManager.class);
    private final IDealManagerValidator validator = new DealValidator();
    private final IDealContactsValidator contactsValidator = new DealContactsValidator();
    @EJB
    private IDealContactsManager contactsManager;
    @EJB
    private IFieldManager fieldManager;
    @EJB
    private ICMLicenseManager licenseManager;
    @EJB
    private IAuditManager auditManager;
    @PersistenceContext(unitName="ContractManagerRealm")
    private EntityManager entityManager;

    public void persist(Deal transientInstance) throws ContractManagerValidationException {
        log.debug((Object)"persisting Deal instance");
        this.validate(transientInstance);
        this.entityManager.persist((Object)transientInstance);
        log.debug((Object)"persist successful");
        Object[] values = new Object[]{transientInstance.getName(), transientInstance.getIdDeal()};
        this.auditManager.logAudit(AuditType.DEAL.getValue(), AuditAction.CREATE.getValue(), MessageFormat.format(AuditMessages.getString("audit.deal.create"), values));
        this.sendEmail(transientInstance.getName(), this.getRecipients(transientInstance), "created");
    }

    public void remove(Deal persistentInstance) {
        log.debug((Object)"removing Deal instance");
        Set<String> recipients = this.getRecipients(persistentInstance);
        String name = persistentInstance.getName();
        this.entityManager.remove((Object)persistentInstance);
        log.debug((Object)"remove successful");
        Object[] values = new Object[]{persistentInstance.getName(), persistentInstance.getIdDeal()};
        this.auditManager.logAudit(AuditType.DEAL.getValue(), AuditAction.DELETE.getValue(), MessageFormat.format(AuditMessages.getString("audit.deal.delete"), values));
        this.sendEmail(name, recipients, "deleted");
    }

    public List<Audit> logAuditDeleteCascade(Set<License> licenses) {
        return new ArrayList<Audit>();
    }

    public Deal merge(Deal detachedInstance) throws ContractManagerValidationException {
        log.debug((Object)"merging Deal instance");
        this.validate(detachedInstance);
        Deal result = (Deal)this.entityManager.merge((Object)detachedInstance);
        log.debug((Object)"merge successful");
        Object[] values = new Object[]{detachedInstance.getName(), detachedInstance.getIdDeal()};
        this.auditManager.logAudit(AuditType.DEAL.getValue(), AuditAction.UPDATE.getValue(), MessageFormat.format(AuditMessages.getString("audit.deal.update"), values));
        this.sendEmail(detachedInstance.getName(), this.getRecipients(detachedInstance), "modified");
        return result;
    }

    public Deal findById(long id) {
        log.debug((Object)("getting Deal instance with id: " + id));
        Deal instance = (Deal)this.entityManager.find(Deal.class, (Object)id);
        log.debug((Object)"get successful");
        return instance;
    }

    public Deal getFullDealById(long id) {
        log.debug((Object)("getting Deal instance with id: " + id));
        Deal deal = null;
        Query query = this.entityManager.createQuery("SELECT deal FROM Deal deal LEFT JOIN FETCH deal.contract c LEFT JOIN FETCH deal.dealContacts dc LEFT JOIN FETCH deal.dealCustomLicFieldValues customLicFieldValues LEFT JOIN FETCH deal.dealDocuments dd LEFT JOIN FETCH deal.dealType dd WHERE deal.idDeal = :ID");
        log.debug((Object)"get successful");
        query.setParameter("ID", (Object)id);
        try {
            deal = (Deal)query.getSingleResult();
        }
        catch (NoResultException e) {
            log.error((Object)"the deal is not exists. ", (Throwable)e);
        }
        return deal;
    }

    public Deal getFullDealByExternalId(String id) {
        log.debug((Object)("getting Deal instance with id: " + id));
        Query query = this.entityManager.createQuery("SELECT deal FROM Deal deal LEFT JOIN FETCH deal.contract c LEFT JOIN FETCH deal.dealContacts dc LEFT JOIN FETCH deal.dealCustomLicFieldValues customLicFieldValues LEFT JOIN FETCH deal.dealDocuments dd LEFT JOIN FETCH deal.dealType dd WHERE deal.externalId = :ID");
        log.debug((Object)"get successful");
        query.setParameter("ID", (Object)id);
        return (Deal)query.getSingleResult();
    }

    public List<Deal> getAllDeals() {
        Query query = this.entityManager.createQuery("SELECT deal from Deal deal");
        log.debug((Object)"get successful");
        return query.getResultList();
    }

    public List<Deal> findByContract(long contractId) {
        Query query = this.entityManager.createQuery("SELECT deal from Deal deal WHERE deal.contract.idContract = " + contractId);
        log.debug((Object)"get successful");
        return query.getResultList();
    }

    public List<Deal> getDeals(int start, int length, String sortProperty, boolean isAscending) {
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("Deal", Deal.class, "deal");
        SortingOrder sortOrder = SortingOrder.ASCENDING;
        if (!isAscending) {
            sortOrder = SortingOrder.DESCENDING;
        }
        e.addParameter((SearchParameterBase)new SortParameter(sortProperty, sortOrder));
        criteria.addParameter((SearchParameterBase)e);
        criteria.setStartingRecordNumber(start);
        criteria.setRecordsCount(length);
        String s = this.getQuery(criteria);
        Query query = this.entityManager.createQuery(s);
        query.setFirstResult(start);
        query.setMaxResults(criteria.getRecordsCount() == 0 ? Integer.MAX_VALUE : criteria.getRecordsCount());
        return query.getResultList();
    }

    private String getQuery(SearchCriteria criteria) {
        return QueryBuilder.newInstance().buildQuery(criteria);
    }

    public int count() {
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("Deal", Deal.class, "deal");
        criteria.addParameter((SearchParameterBase)e);
        String s = QueryBuilder.newInstance().buildCountQuery(criteria);
        Query query = this.entityManager.createQuery(s);
        long count = (Long)query.getSingleResult();
        return (int)count;
    }

    private void sendEmail(String name, Set<String> recipients, String activity) {
        try {
            String subject = "Deal " + activity;
            String body = "Deal " + name + " was " + activity;
            MailUtil.sendMail(subject, body, recipients);
        }
        catch (Exception e) {
            log.error((Object)("Error sending email to recipients: " + e.getLocalizedMessage()));
        }
    }

    private Set<String> getRecipients(Deal deal) {
        HashSet<String> recipients = new HashSet<String>();
        Contract contract = (Contract)this.entityManager.getReference(Contract.class, (Object)deal.getContract().getIdContract());
        CopyrightHolder copyrightHolder = contract.getCopyrightHolder();
        for (CopyHolderContacts copyrightHolderContact : copyrightHolder.getCopyHolderContacts()) {
            if (copyrightHolderContact.getNotify() == null || !copyrightHolderContact.getNotify().booleanValue()) continue;
            recipients.add(copyrightHolderContact.getEmail());
        }
        for (ContractContacts contractContact : contract.getContractContacts()) {
            if (contractContact.getNotify() == null || !contractContact.getNotify().booleanValue()) continue;
            recipients.add(contractContact.getEmail());
        }
        for (DealContacts dealContact : this.contactsManager.findByDeal(deal.getIdDeal().longValue())) {
            if (dealContact.getNotify() == null || !dealContact.getNotify().booleanValue()) continue;
            recipients.add(dealContact.getEmail());
        }
        return recipients;
    }

    public List<ExpiringDetail> getAllDealsWithExpiringLicenses() {
        String sql = "select distinct d.name,l.name,l.expiry_date,dc.email from CM_DEAL d join CM_LICENSE l on d.id_deal=l.id_deal join CM_DEAL_CONTACTS dc on d.id_deal=dc.id_deal where l.expiry_date between current_timestamp and (current_timestamp +  CAST((COALESCE(d.license_expiry_reminder, 1) || ' days') as INTERVAL)) and dc.notify='Y' order by d.name,l.name ";
        Query query = this.entityManager.createNativeQuery(sql);
        List resultList = query.getResultList();
        return resultList.stream().map(rep -> new ExpiringDetail((String)rep[0], (String)rep[1], (Date)rep[2], (String)rep[3])).collect(Collectors.toList());
    }

    private void validate(Deal instance) throws ContractManagerValidationException {
        this.validator.validate(instance, this.licenseManager, this.fieldManager, this.entityManager, this);
        if (!instance.getDealContacts().isEmpty()) {
            ArrayList<DealContacts> existentContacts = new ArrayList<DealContacts>(instance.getDealContacts());
            this.contactsValidator.validate(instance.getDealContacts(), existentContacts);
        }
    }
}

