/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.entitymanager;

import com.ericsson.cms.contractmgmt.audit.AuditMessages;
import com.ericsson.ejb.LicenseDocuments;
import com.ericsson.enumeration.AuditAction;
import com.ericsson.enumeration.AuditType;
import com.ericsson.service.IAuditManager;
import com.ericsson.service.ILicenseDocumentsManager;
import java.text.MessageFormat;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Local(value={ILicenseDocumentsManager.class})
@Stateless
public class LicenseDocumentsManager
implements ILicenseDocumentsManager {
    private static final Log log = LogFactory.getLog(LicenseDocumentsManager.class);
    @EJB
    private IAuditManager auditManager;
    @PersistenceContext(unitName="ContractManagerRealm")
    private EntityManager entityManager;

    public void persist(LicenseDocuments transientInstance) {
        log.debug((Object)"persisting LicenseDocuments instance");
        try {
            this.entityManager.persist((Object)transientInstance);
            this.entityManager.flush();
            log.debug((Object)"persist successful");
            Object[] values = new Object[]{transientInstance.getFileName(), transientInstance.getIdDocument()};
            this.auditManager.logAudit(AuditType.LICENSE.getValue(), AuditAction.CREATE.getValue(), MessageFormat.format(AuditMessages.getString("audit.license.document.create"), values));
        }
        catch (RuntimeException re) {
            log.error((Object)"persist failed", (Throwable)re);
            throw re;
        }
    }

    public void remove(LicenseDocuments persistentInstance) {
        log.debug((Object)"removing LicenseDocuments instance");
        try {
            this.entityManager.remove((Object)persistentInstance);
            log.debug((Object)"remove successful");
            Object[] values = new Object[]{persistentInstance.getFileName(), persistentInstance.getIdDocument()};
            this.auditManager.logAudit(AuditType.LICENSE.getValue(), AuditAction.DELETE.getValue(), MessageFormat.format(AuditMessages.getString("audit.license.document.delete"), values));
        }
        catch (RuntimeException re) {
            log.error((Object)"remove failed", (Throwable)re);
            throw re;
        }
    }

    public LicenseDocuments merge(LicenseDocuments detachedInstance) {
        log.debug((Object)"merging LicenseDocuments instance");
        try {
            LicenseDocuments result = (LicenseDocuments)this.entityManager.merge((Object)detachedInstance);
            this.entityManager.flush();
            log.debug((Object)"merge successful");
            Object[] values = new Object[]{detachedInstance.getFileName(), detachedInstance.getIdDocument()};
            this.auditManager.logAudit(AuditType.LICENSE.getValue(), AuditAction.UPDATE.getValue(), MessageFormat.format(AuditMessages.getString("audit.license.document.update"), values));
            return result;
        }
        catch (RuntimeException re) {
            log.error((Object)"merge failed", (Throwable)re);
            throw re;
        }
    }

    public LicenseDocuments findById(long id) {
        log.debug((Object)("getting LicenseDocuments instance with id: " + id));
        try {
            LicenseDocuments instance = (LicenseDocuments)this.entityManager.find(LicenseDocuments.class, (Object)id);
            log.debug((Object)"get successful");
            return instance;
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }

    public List<LicenseDocuments> findByLicense(long licenseId) {
        try {
            Query query = this.entityManager.createQuery("SELECT docs from LicenseDocuments docs WHERE docs.license.idLicense = " + licenseId);
            log.debug((Object)"get successful");
            return query.getResultList();
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }
}

