/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.entitymanager;

import com.ericsson.ejb.Media;
import com.ericsson.service.ContractManagerValidationException;
import com.ericsson.service.IMediaManager;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Local(value={IMediaManager.class})
@Stateless
public class MediaManager
implements IMediaManager {
    private static final Log log = LogFactory.getLog(MediaManager.class);
    @PersistenceContext(unitName="ContractManagerRealm")
    private EntityManager entityManager;

    public void persist(Media transientInstance) throws ContractManagerValidationException {
        log.debug((Object)"persisting Media instance");
        try {
            this.isExists(transientInstance);
            this.entityManager.persist((Object)transientInstance);
            log.debug((Object)"persist successful");
        }
        catch (RuntimeException re) {
            log.error((Object)"persist failed", (Throwable)re);
            throw re;
        }
    }

    public void remove(Media persistentInstance) {
        log.debug((Object)"removing Media instance");
        try {
            this.entityManager.remove((Object)persistentInstance);
            log.debug((Object)"remove successful");
        }
        catch (RuntimeException re) {
            log.error((Object)"remove failed", (Throwable)re);
            throw re;
        }
    }

    public Media merge(Media detachedInstance) throws ContractManagerValidationException {
        log.debug((Object)"merging Media instance");
        try {
            this.isExists(detachedInstance);
            Media result = (Media)this.entityManager.merge((Object)detachedInstance);
            log.debug((Object)"merge successful");
            return result;
        }
        catch (RuntimeException re) {
            log.error((Object)"merge failed", (Throwable)re);
            throw re;
        }
    }

    public Media findById(long id) {
        log.debug((Object)("getting Media instance with id: " + id));
        try {
            Media instance = (Media)this.entityManager.find(Media.class, (Object)id);
            log.debug((Object)"get successful");
            return instance;
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }

    public List<Media> getAllMedias() {
        try {
            Query query = this.entityManager.createQuery("SELECT media from Media media");
            log.debug((Object)"get successful");
            return query.getResultList();
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }

    private void isExists(Media transientInstance) throws ContractManagerValidationException {
        Media existing = this.findByName(transientInstance.getMediaType());
        if (existing != null && (transientInstance.getIdMedia() == null || existing.getIdMedia().longValue() != transientInstance.getIdMedia().longValue())) {
            ArrayList<String> validationErrors = new ArrayList<String>();
            validationErrors.add("Media Type already exists!");
            throw new ContractManagerValidationException(validationErrors);
        }
    }

    public Media findByName(String name) {
        try {
            Query query = this.entityManager.createQuery("SELECT media from Media media WHERE media.mediaType = :name");
            query.setParameter("name", (Object)name);
            log.debug((Object)"get successful");
            try {
                return (Media)query.getSingleResult();
            }
            catch (NoResultException e) {
                return null;
            }
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }
}

