/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.entitymanager;

import com.ericsson.ejb.Ownership;
import com.ericsson.service.ContractManagerValidationException;
import com.ericsson.service.IOwnershipManager;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Local(value={IOwnershipManager.class})
@Stateless
public class OwnershipManager
implements IOwnershipManager {
    private static final Log log = LogFactory.getLog(OwnershipManager.class);
    @PersistenceContext(unitName="ContractManagerRealm")
    private EntityManager entityManager;

    public void persist(Ownership transientInstance) throws ContractManagerValidationException {
        log.debug((Object)"persisting Ownership instance");
        try {
            this.isExists(transientInstance);
            this.entityManager.persist((Object)transientInstance);
            log.debug((Object)"persist successful");
        }
        catch (RuntimeException re) {
            log.error((Object)"persist failed", (Throwable)re);
            throw re;
        }
    }

    public void remove(Ownership persistentInstance) {
        log.debug((Object)"removing Ownership instance");
        try {
            this.entityManager.remove((Object)persistentInstance);
            log.debug((Object)"remove successful");
        }
        catch (RuntimeException re) {
            log.error((Object)"remove failed", (Throwable)re);
            throw re;
        }
    }

    public Ownership merge(Ownership detachedInstance) throws ContractManagerValidationException {
        log.debug((Object)"merging Ownership instance");
        try {
            this.isExists(detachedInstance);
            Ownership result = (Ownership)this.entityManager.merge((Object)detachedInstance);
            log.debug((Object)"merge successful");
            return result;
        }
        catch (RuntimeException re) {
            log.error((Object)"merge failed", (Throwable)re);
            throw re;
        }
    }

    public Ownership findById(long id) {
        log.debug((Object)("getting Ownership instance with id: " + id));
        try {
            Ownership instance = (Ownership)this.entityManager.find(Ownership.class, (Object)id);
            log.debug((Object)"get successful");
            return instance;
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }

    public List<Ownership> getAllOwnerships() {
        try {
            Query query = this.entityManager.createQuery("SELECT own from Ownership own");
            log.debug((Object)"get successful");
            return query.getResultList();
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }

    private void isExists(Ownership transientInstance) throws ContractManagerValidationException {
        Ownership existing = this.findByName(transientInstance.getOwnership());
        if (existing != null && (transientInstance.getIdOwnership() == null || existing.getIdOwnership().longValue() != transientInstance.getIdOwnership().longValue())) {
            ArrayList<String> validationErrors = new ArrayList<String>();
            validationErrors.add("Owner already exists!");
            throw new ContractManagerValidationException(validationErrors);
        }
    }

    public Ownership findByName(String name) {
        try {
            Query query = this.entityManager.createQuery("SELECT own from Ownership own WHERE own.ownership = :name");
            query.setParameter("name", (Object)name);
            log.debug((Object)"get successful");
            try {
                return (Ownership)query.getSingleResult();
            }
            catch (NoResultException e) {
                return null;
            }
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }
}

