/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.me.pluginmanager;

import com.ericsson.cms.me.exception.MetadataEnhancementException;
import com.ericsson.cms.me.jpf.JPFPlugin;
import com.ericsson.cms.me.service.Fields;
import com.ericsson.cms.me.service.IMEPlugin;
import com.ericsson.cms.me.service.IMEPluginManager;
import com.ericsson.cms.me.util.JPFActivator;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;
import org.java.plugin.PluginClassLoader;
import org.java.plugin.PluginLifecycleException;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.PluginDescriptor;

public class MEPluginManagerCore
implements IMEPluginManager {
    public static String PRODUCT_DIR = "com.tandbergtv.cms.product.dir";
    public static String ME_PLUGIN_FOLDER_RELATIVE_PATH = "plugins" + File.separator + "metadataenhancement";
    public static String JPF_PLUGIN_REPOSITORY_PROPERTY = "org.java.plugin.boot.pluginsRepositories";
    private static String EXTENSION_POINT_ID = "metadataenhancement";
    private static String PLUGIN_ID = "com.ericsson.cms.metadataenhancement.plugins";
    private static String PROFILE_PARAMETER = "profileParameter";
    private static String NAME = "name";
    private static String CLASS = "class";
    private static String ECMF_MAPPING_FILE = "ECMFMappingFile";
    private final Set<JPFPlugin> plugins = new HashSet<JPFPlugin>();
    private static final Logger logger = Logger.getLogger(MEPluginManagerCore.class);

    public void start() throws MetadataEnhancementException {
        logger.debug((Object)"Entering MEPluginManagerCore start()");
        Properties properties = new Properties();
        String installFolder = System.getProperty(PRODUCT_DIR);
        File pluginFolder = new File(installFolder, ME_PLUGIN_FOLDER_RELATIVE_PATH);
        properties.put(JPF_PLUGIN_REPOSITORY_PROPERTY, pluginFolder.getAbsolutePath());
        JPFActivator jpfActivator = new JPFActivator();
        jpfActivator.start(properties);
        PluginManager pluginManager = jpfActivator.getPluginManager();
        if (pluginManager == null) {
            MetadataEnhancementException mee = this.fail("Cannot get Plugin Manager for Metadata Enhancement Plugins");
            logger.error((Object)mee, (Throwable)mee);
            throw mee;
        }
        ExtensionPoint point = pluginManager.getRegistry().getExtensionPoint(PLUGIN_ID, EXTENSION_POINT_ID);
        Collection extensions = point.getConnectedExtensions();
        if (!extensions.isEmpty()) {
            LinkedHashMap<String, String> pluginParams = new LinkedHashMap<String, String>();
            LinkedHashSet<String> profileParams = new LinkedHashSet<String>();
            for (Extension extension : extensions) {
                String pluginName = extension.getParameter(NAME).valueAsString();
                String classStr = extension.getParameter(CLASS).valueAsString();
                String ecmfMappingFile = extension.getParameter(ECMF_MAPPING_FILE).valueAsString();
                String resourcePath = null;
                pluginParams = new LinkedHashMap();
                profileParams = new LinkedHashSet();
                for (Extension.Parameter p : extension.getParameters()) {
                    if (PROFILE_PARAMETER.equals(p.getId())) {
                        profileParams.add(p.valueAsString());
                        continue;
                    }
                    pluginParams.put(p.getId(), p.valueAsString());
                }
                PluginDescriptor declaringPluginDescriptor = extension.getDeclaringPluginDescriptor();
                try {
                    pluginManager.activatePlugin(declaringPluginDescriptor.getId());
                }
                catch (MetadataEnhancementException e) {
                    throw e;
                }
                catch (PluginLifecycleException e) {
                    MetadataEnhancementException mee = this.fail("Unable to activate the plugin: " + declaringPluginDescriptor.getId(), (Exception)((Object)e));
                    logger.error((Object)mee, (Throwable)mee);
                    throw mee;
                }
                Class<?> mePluginClass = null;
                try {
                    PluginClassLoader classLoader = pluginManager.getPluginClassLoader(declaringPluginDescriptor);
                    mePluginClass = classLoader.loadClass(classStr);
                    if (ecmfMappingFile != null && !ecmfMappingFile.isEmpty()) {
                        resourcePath = classLoader.getResource(ecmfMappingFile).getPath();
                        resourcePath = resourcePath.substring(0, resourcePath.length() - ecmfMappingFile.length() - 1);
                    }
                }
                catch (MetadataEnhancementException e) {
                    throw e;
                }
                catch (Exception e) {
                    MetadataEnhancementException mee = this.fail("Unable to load the metadata enhancement class: " + classStr + " for plugin: " + declaringPluginDescriptor.getId(), e);
                    logger.error((Object)mee, (Throwable)mee);
                    throw mee;
                }
                JPFPlugin plugin = new JPFPlugin(pluginName, mePluginClass, pluginParams, profileParams, resourcePath);
                this.plugins.add(plugin);
            }
        }
        logger.debug((Object)"Exiting MEPluginManagerCore start()");
    }

    public Set<JPFPlugin> getJPFPlugins() {
        return this.plugins;
    }

    public IMEPlugin getMEPlugin(String pluginName) throws MetadataEnhancementException {
        Set<JPFPlugin> jpfPlugins = this.getJPFPlugins();
        for (JPFPlugin plugin : jpfPlugins) {
            if (!plugin.getName().equals(pluginName)) continue;
            try {
                IMEPlugin result = (IMEPlugin)plugin.getMePluginClass().newInstance();
                result.setPluginParams(plugin.getPluginParams());
                result.setSupportedProfileParams(plugin.getProfileParams());
                result.setResourcePath(plugin.getResourcePath());
                return result;
            }
            catch (MetadataEnhancementException e) {
                throw e;
            }
            catch (Exception e) {
                MetadataEnhancementException mee = this.fail("Unable to instantiate the me plugin class: " + plugin.getMePluginClass() + " of plugin: " + plugin.getName(), e);
                logger.error((Object)mee, (Throwable)mee);
                throw mee;
            }
        }
        return null;
    }

    public HashMap<String, Set<Fields>> getECMFFieldMappings(String pluginName) throws MetadataEnhancementException {
        IMEPlugin plugin = this.getMEPlugin(pluginName);
        if (plugin != null) {
            plugin.initialize();
            return plugin.getECMFFieldMappings();
        }
        return null;
    }

    private MetadataEnhancementException fail(String message) {
        return new MetadataEnhancementException(message);
    }

    private MetadataEnhancementException fail(Exception e) {
        return this.fail("Unexpected exception: " + e, e);
    }

    private MetadataEnhancementException fail(String message, Exception e) {
        if (e instanceof MetadataEnhancementException) {
            return (MetadataEnhancementException)((Object)e);
        }
        return new MetadataEnhancementException(message + " " + e, (Throwable)e);
    }
}

