/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.actions;

import com.tandbergtv.marvin.actions.NormalizationActions;
import com.tandbergtv.marvin.engine.EvaluatorResults;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.search.SearchSchemaHelper;
import com.tandbergtv.metadatamanager.search.XpathNodeCardinality;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class FieldIndexCleaner {
    public static void fixIndexOnRemove(String sectionType, String xpath, Title title) {
        List cardinality = new SearchSchemaHelper().getXpathCardinality(sectionType, xpath);
        int startPos = sectionType.startsWith("NEW/") ? sectionType.substring(4).split("/").length : sectionType.split("/").length;
        StringBuilder workingXpath = new StringBuilder();
        for (int i = startPos; i < cardinality.size(); ++i) {
            workingXpath.append("/");
            workingXpath.append(((XpathNodeCardinality)cardinality.get(i)).getNodeName());
            if (((XpathNodeCardinality)cardinality.get(i)).getCardinality() <= 1) continue;
            List<Field> leftOvers = NormalizationActions.findFields(sectionType, "", workingXpath.toString(), false, new EvaluatorResults(), title, true);
            FieldIndexCleaner.fixIndexes(leftOvers, cardinality);
            break;
        }
    }

    private static void fixIndexes(List<Field> fields, List<XpathNodeCardinality> cardinality) {
        if (fields == null || fields.isEmpty()) {
            return;
        }
        LinkedList<FieldTreeNode> root = new LinkedList<FieldTreeNode>();
        ArrayList<FieldTreeNode> leafNodes = new ArrayList<FieldTreeNode>();
        for (Field field : fields) {
            List indices = field.getIndices();
            LinkedList<FieldTreeNode> curr = root;
            List<String> path = Arrays.asList(field.getTtvXPath().split("/"));
            path = path.subList(1, path.size());
            FieldTreeNode parentTracker = null;
            for (int i = 0; i < path.size() - 1; ++i) {
                boolean nodeAlreadyExists = false;
                String name = path.get(i);
                int index = (Integer)indices.get(i);
                for (FieldTreeNode ftn : curr) {
                    if (!ftn.name.equals(name) || !ftn.currentIndex.equals(index)) continue;
                    parentTracker = ftn;
                    curr = ftn.children;
                    nodeAlreadyExists = true;
                    break;
                }
                if (nodeAlreadyExists) continue;
                parentTracker = new FieldTreeNode(name, index, parentTracker);
                FieldIndexCleaner.addNodeInOrder(curr, parentTracker);
                curr = parentTracker.children;
            }
            FieldTreeNode leafNode = new FieldTreeNode(path.get(path.size() - 1), (Integer)indices.get(indices.size() - 1), field, parentTracker);
            leafNodes.add(leafNode);
            FieldIndexCleaner.addNodeInOrder(curr, leafNode);
        }
        for (FieldTreeNode node : leafNodes) {
            if (!node.name.startsWith("@")) {
                FieldIndexCleaner.fixIndex(node.field.getIndices(), node.field.getIndices().size() - 1, node);
            }
            if (!node.name.startsWith("@")) continue;
            FieldIndexCleaner.fixIndex(node.field.getIndices(), node.field.getIndices().size() - 1, node.parent);
        }
    }

    private static void fixIndex(List<Integer> indices, int index, FieldTreeNode nextNode) {
        indices.set(index, nextNode.pos);
        if (nextNode.parent != null) {
            FieldIndexCleaner.fixIndex(indices, index - 1, nextNode.parent);
        }
    }

    private static void addNodeInOrder(List<FieldTreeNode> nodes, FieldTreeNode ftn) {
        ListIterator<FieldTreeNode> iterator = nodes.listIterator();
        boolean added = false;
        FieldTreeNode node = null;
        while (iterator.hasNext()) {
            node = iterator.next();
            if (!added && ftn.name.compareTo(node.name) < 0) {
                iterator.previous();
                iterator.add(ftn);
                ftn.pos = 1;
                added = true;
                continue;
            }
            if (!added && ftn.name.equals(node.name) && ftn.currentIndex < node.currentIndex) {
                iterator.previous();
                iterator.add(ftn);
                iterator.next();
                ftn.pos = ++node.pos;
                added = true;
                continue;
            }
            if (!ftn.name.equals(node.name) || !added) continue;
            ++node.pos;
        }
        if (!added) {
            nodes.add(ftn);
            ftn.pos = node != null && ftn.name.equals(node.name) ? node.pos + 1 : 1;
        }
    }

    private static class FieldTreeNode {
        String name;
        int pos = 1;
        Integer currentIndex;
        Field field;
        FieldTreeNode parent;
        LinkedList<FieldTreeNode> children;

        public FieldTreeNode(String name, Integer currentIndex, Field field, FieldTreeNode parent) {
            this.name = name;
            this.currentIndex = currentIndex;
            this.field = field;
            this.parent = parent;
        }

        public FieldTreeNode(String name, Integer currentIndex, FieldTreeNode parent) {
            this.name = name;
            this.currentIndex = currentIndex;
            this.children = new LinkedList();
            this.parent = parent;
        }
    }
}

