/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.actions;

import com.ericsson.cms.criteria.FieldType;
import com.tandbergtv.content.contentclass.service.ICustomFieldManager;
import com.tandbergtv.marvin.actions.Action;
import com.tandbergtv.marvin.actions.FieldIndexCleaner;
import com.tandbergtv.marvin.actions.NormalizationAddFieldAction;
import com.tandbergtv.marvin.actions.NormalizationChangeAction;
import com.tandbergtv.marvin.actions.NormalizationOverrideHelper;
import com.tandbergtv.marvin.actions.TimeHelper;
import com.tandbergtv.marvin.engine.EvaluatorException;
import com.tandbergtv.marvin.engine.EvaluatorResults;
import com.tandbergtv.marvin.engine.MatchedItem;
import com.tandbergtv.marvin.engine.TitleExt;
import com.tandbergtv.marvin.metadata.ActionAnnotations;
import com.tandbergtv.marvin.udt.DataTypes;
import com.tandbergtv.metadatamanager.AssetCopyException;
import com.tandbergtv.metadatamanager.customfield.model.CustomField;
import com.tandbergtv.metadatamanager.customfield.model.CustomFieldGroup;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.FieldTree;
import com.tandbergtv.metadatamanager.model.FieldTreeNode;
import com.tandbergtv.metadatamanager.model.Group;
import com.tandbergtv.metadatamanager.model.IField;
import com.tandbergtv.metadatamanager.model.Item;
import com.tandbergtv.metadatamanager.model.Relation;
import com.tandbergtv.metadatamanager.search.SearchSchemaHelper;
import com.tandbergtv.metadatamanager.search.XpathNodeCardinality;
import com.tandbergtv.metadatamanager.specimpl.ttv.TTVSpecHandler;
import com.tandbergtv.metadatamanager.util.DataTypeMappingReader;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

@ActionAnnotations(name="NORMALIZATION")
public class NormalizationActions
extends Action {
    private static final Logger logger = Logger.getLogger(NormalizationActions.class);
    private static final String CATEGORY_SEPERATOR = "/";
    private static final String CATEGORY_XPATH = "/Fields/Categories/Category/Text";

    @ActionAnnotations.Action(name="normalizationAddAssetLabel", parms={"sectionType", "forMatched", "matchedItems", "titleExt"}, allowMatchedRootNodes=false, assetTypesDisallowed={"PACKAGE", "PACKAGE/TITLE.*", "SERIES.*", ".*FILE"}, xpathFilter={""})
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.COMPLEX}, valueType={DataTypes.COMPLEX})
    public void addAsset(String sectionType, boolean forMatched, EvaluatorResults evalResults, TitleExt titleExt) {
        List<Asset> parentAssets;
        int lastSlash = sectionType.lastIndexOf(CATEGORY_SEPERATOR);
        String parentAssetType = sectionType.substring(0, lastSlash);
        String assetType = sectionType.substring(lastSlash + 1, sectionType.length());
        if (forMatched) {
            parentAssets = new ArrayList();
            for (Asset a : evalResults.getMatchedAssets(parentAssetType)) {
                parentAssets.add(a);
            }
        } else {
            parentAssets = titleExt.getTitle().getAsset().getAllAssetsWithLineage(Arrays.asList(parentAssetType.split(CATEGORY_SEPERATOR)));
        }
        for (Asset parent : parentAssets) {
            Asset newAsset = this.getAsset(sectionType, assetType);
            parent.addChild(newAsset);
            evalResults.addNewAsset(newAsset);
        }
    }

    private Asset getAsset(String assetPath, String assetType) {
        Group asset = null;
        for (Group.GroupType groupType : Group.GroupType.values()) {
            if (!groupType.name().equals(assetType)) continue;
            Group group = new Group();
            group.setType(groupType);
            asset = group;
        }
        for (Group.GroupType groupType : Item.ItemType.values()) {
            if (!groupType.name().equals(assetType)) continue;
            Item item = new Item();
            item.setType((Item.ItemType)groupType);
            asset = item;
        }
        asset.setPath(assetPath);
        return asset;
    }

    @ActionAnnotations.Action(name="normalizationChangeLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "matchedItems", "title"}, useSuggestedValues=true)
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.STRING, DataTypes.FLOAT, DataTypes.LONG, DataTypes.BOOLEAN, DataTypes.DATE, DataTypes.TIME, DataTypes.TIMECODE}, valueType={DataTypes.STRING, DataTypes.FLOAT, DataTypes.LONG, DataTypes.BOOLEAN, DataTypes.DATE, DataTypes.TIME, DataTypes.TIMECODE})
    public void change(String sectionType, String rootxpath, String xpath, Boolean forMatched, String value, EvaluatorResults evalResults, Title title) {
        NormalizationChangeAction changer = new NormalizationChangeAction(sectionType, rootxpath, xpath, forMatched, value, evalResults, title);
        changer.change();
    }

    @ActionAnnotations.Action(name="normalizationAddFieldLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "matchedItems", "title"}, useSuggestedValues=true, allowMatchedRootNodes=false)
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.STRING, DataTypes.FLOAT, DataTypes.LONG, DataTypes.BOOLEAN, DataTypes.DATE, DataTypes.TIME, DataTypes.TIMECODE}, valueType={DataTypes.STRING, DataTypes.FLOAT, DataTypes.LONG, DataTypes.BOOLEAN, DataTypes.DATE, DataTypes.TIME, DataTypes.TIMECODE})
    public void addField(String sectionType, String rootxpath, String xpath, Boolean forMatched, String value, EvaluatorResults evalResults, Title title) {
        NormalizationAddFieldAction adder = new NormalizationAddFieldAction(sectionType, rootxpath, xpath, forMatched, value, evalResults, title);
        adder.add();
    }

    @ActionAnnotations.Action(name="normalizationDuplicatePrefixLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "matchedItems", "title"}, useSuggestedValues=false, matchedOnly=true)
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.STRING}, valueType={DataTypes.STRING})
    public void duplicatePrefix(String sectionType, String rootxpath, String xpath, Boolean forMatched, String value, EvaluatorResults evalResults, Title title) {
        List<Field> fields = NormalizationActions.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        for (Field field : fields) {
            NormalizationAddFieldAction adder = new NormalizationAddFieldAction(sectionType, null, xpath, false, value + field.getValue(), evalResults, title);
            adder.add();
        }
    }

    @ActionAnnotations.Action(name="normalizationDuplicateAppendLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "matchedItems", "title"}, useSuggestedValues=false, matchedOnly=true)
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.STRING}, valueType={DataTypes.STRING})
    public void duplicateAppend(String sectionType, String rootxpath, String xpath, Boolean forMatched, String value, EvaluatorResults evalResults, Title title) {
        List<Field> fields = NormalizationActions.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        for (Field field : fields) {
            NormalizationAddFieldAction adder = new NormalizationAddFieldAction(sectionType, null, xpath, false, field.getValue() + value, evalResults, title);
            adder.add();
        }
    }

    @ActionAnnotations.Action(name="normalizationDuplicateReplaceLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "value2", "matchedItems", "title"}, parmLabels={"", "", "", "", "find", "replace", "", ""}, useSuggestedValues=false, matchedOnly=true)
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.STRING}, valueType={DataTypes.STRING})
    public void duplicateReplace(String sectionType, String rootxpath, String xpath, Boolean forMatched, String value, String value2, EvaluatorResults evalResults, Title title) {
        List<Field> fields = NormalizationActions.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        for (Field field : fields) {
            NormalizationAddFieldAction adder = new NormalizationAddFieldAction(sectionType, null, xpath, false, field.getValue().replace(value, value2), evalResults, title);
            adder.add();
        }
    }

    @ActionAnnotations.Action(name="normalizationCopyLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "sectionTypeRhs", "rootxpathRhs", "xpathRhs", "forMatchedRhs", "matchedItems", "title"}, useSuggestedValues=true)
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.STRING, DataTypes.FLOAT, DataTypes.LONG, DataTypes.BOOLEAN, DataTypes.DATE, DataTypes.TIME, DataTypes.TIMECODE}, valueType={DataTypes.STRING, DataTypes.FLOAT, DataTypes.LONG, DataTypes.BOOLEAN, DataTypes.DATE, DataTypes.TIME, DataTypes.TIMECODE})
    public void copy(String sectionType, String rootxpath, String xpath, Boolean forMatched, String sectionTypeRhs, String rootxpathRhs, String xpathRhs, Boolean forMatchedRhs, EvaluatorResults evalResults, Title title) {
        List<Field> fields = NormalizationActions.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        if (fields.size() > 0) {
            String value = fields.get(0).getValue();
            NormalizationChangeAction changer = new NormalizationChangeAction(sectionTypeRhs, rootxpathRhs, xpathRhs, forMatchedRhs, value, evalResults, title);
            changer.change();
        }
    }

    @ActionAnnotations.Action(name="normalizationAppendFieldLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "sectionTypeRhs", "rootxpathRhs", "xpathRhs", "forMatchedRhs", "matchedItems", "title"}, useSuggestedValues=true)
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.STRING, DataTypes.FLOAT, DataTypes.LONG, DataTypes.BOOLEAN, DataTypes.DATE, DataTypes.TIME, DataTypes.TIMECODE}, valueType={DataTypes.STRING, DataTypes.STRING, DataTypes.STRING, DataTypes.STRING, DataTypes.STRING, DataTypes.STRING, DataTypes.STRING})
    public void appendField(String sectionType, String rootxpath, String xpath, Boolean forMatched, String sectionTypeRhs, String rootxpathRhs, String xpathRhs, Boolean forMatchedRhs, EvaluatorResults evalResults, Title title) {
        List<Field> fields = NormalizationActions.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        if (fields.size() > 0) {
            String value = fields.get(0).getValue();
            List<Field> fieldsRhs = NormalizationActions.findFields(sectionTypeRhs, rootxpathRhs, xpathRhs, forMatchedRhs, evalResults, title, false);
            for (Field field : fieldsRhs) {
                field.setValue(field.getValue() + value);
            }
        }
    }

    @ActionAnnotations.Action(name="normalizationPrefixFieldLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "sectionTypeRhs", "rootxpathRhs", "xpathRhs", "forMatchedRhs", "matchedItems", "title"}, useSuggestedValues=true)
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.STRING, DataTypes.FLOAT, DataTypes.LONG, DataTypes.BOOLEAN, DataTypes.DATE, DataTypes.TIME, DataTypes.TIMECODE}, valueType={DataTypes.STRING, DataTypes.STRING, DataTypes.STRING, DataTypes.STRING, DataTypes.STRING, DataTypes.STRING, DataTypes.STRING})
    public void prefixField(String sectionType, String rootxpath, String xpath, Boolean forMatched, String sectionTypeRhs, String rootxpathRhs, String xpathRhs, Boolean forMatchedRhs, EvaluatorResults evalResults, Title title) {
        List<Field> fields = NormalizationActions.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        if (fields.size() > 0) {
            String value = fields.get(0).getValue();
            List<Field> fieldsRhs = NormalizationActions.findFields(sectionTypeRhs, rootxpathRhs, xpathRhs, forMatchedRhs, evalResults, title, false);
            for (Field field : fieldsRhs) {
                field.setValue(value + field.getValue());
            }
        }
    }

    @ActionAnnotations.Action(name="normalizationCopyNonPackageLabel", parms={"fieldType", "sectionType", "rootxpath", "xpath", "forMatched", "sectionTypeRhs", "rootxpathRhs", "xpathRhs", "forMatchedRhs", "matchedItems", "titleExt"}, useSuggestedValues=true, fieldTypesAllowed={FieldType.ASSET, FieldType.LICENSE, FieldType.ENHANCEMENT}, assetTypesAllowed={"SERIES.*"}, assetTypesDisallowed={})
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.STRING, DataTypes.FLOAT, DataTypes.LONG, DataTypes.BOOLEAN, DataTypes.DATE, DataTypes.TIME, DataTypes.TIMECODE}, valueType={DataTypes.STRING, DataTypes.FLOAT, DataTypes.LONG, DataTypes.BOOLEAN, DataTypes.DATE, DataTypes.TIME, DataTypes.TIMECODE})
    public void copyNonPackage(FieldType fieldType, String sectionType, String rootxpath, String xpath, Boolean forMatched, String sectionTypeRhs, String rootxpathRhs, String xpathRhs, Boolean forMatchedRhs, EvaluatorResults evalResults, TitleExt titleExt) {
        List<? extends IField> fields;
        if (forMatched.booleanValue()) {
            fields = NormalizationActions.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, titleExt.getSeries(), false);
        } else {
            try {
                fields = titleExt.getFields(fieldType, sectionType, xpath);
            }
            catch (EvaluatorException e) {
                logger.error((Object)e);
                throw new RuntimeException(e);
            }
        }
        if (fields.size() > 0) {
            String value = fields.get(0).getValue();
            NormalizationChangeAction changer = new NormalizationChangeAction(sectionTypeRhs, rootxpathRhs, xpathRhs, forMatchedRhs, value, evalResults, titleExt.getTitle());
            changer.change();
        }
    }

    @ActionAnnotations.Action(name="normalizationOverrideLabel", parms={"fieldType", "sectionType", "rootxpath", "xpath", "forMatched", "sectionTypeRhs", "rootxpathRhs", "xpathRhs", "forMatchedRhs", "matchedItems", "titleExt"}, useSuggestedValues=true, fieldTypesAllowed={FieldType.ASSET, FieldType.LICENSE, FieldType.ENHANCEMENT}, assetTypesAllowed={}, assetTypesDisallowed={}, allowAssets=false)
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.COMPLEX, DataTypes.STRING, DataTypes.FLOAT, DataTypes.LONG, DataTypes.BOOLEAN, DataTypes.DATE, DataTypes.TIME, DataTypes.TIMECODE}, valueType={DataTypes.COMPLEX, DataTypes.STRING, DataTypes.FLOAT, DataTypes.LONG, DataTypes.BOOLEAN, DataTypes.DATE, DataTypes.TIME, DataTypes.TIMECODE})
    public void copyOverride(FieldType fieldType, String sectionType, String rootxpath, String xpath, Boolean forMatched, String sectionTypeRhs, String rootxpathRhs, String xpathRhs, Boolean forMatchedRhs, EvaluatorResults evalResults, TitleExt titleExt) {
        List<? extends IField> fields;
        if (fieldType.equals((Object)FieldType.ENHANCEMENT) && !titleExt.hasRefId()) {
            return;
        }
        if (forMatched.booleanValue()) {
            fields = NormalizationActions.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, titleExt.getTitle(), true);
        } else {
            try {
                fields = titleExt.getFields(fieldType, sectionType, xpath);
            }
            catch (EvaluatorException e) {
                logger.error((Object)e);
                throw new RuntimeException(e);
            }
        }
        List<XpathNodeCardinality> xpathCardinality = NormalizationActions.getXpathCardinality(sectionTypeRhs, xpathRhs);
        int cardinality = 1;
        int pivotPoint = -1;
        int xpathNodeStartPoint = sectionTypeRhs.split(CATEGORY_SEPERATOR).length;
        if (sectionTypeRhs.startsWith("NEW/")) {
            --xpathNodeStartPoint;
        }
        StringBuffer xpathToRemoveSb = new StringBuffer();
        for (int i = xpathNodeStartPoint; i < xpathCardinality.size(); ++i) {
            XpathNodeCardinality node = xpathCardinality.get(i);
            xpathToRemoveSb.append(CATEGORY_SEPERATOR);
            xpathToRemoveSb.append(node.getNodeName());
            if (node.getCardinality() <= 1) continue;
            cardinality = node.getCardinality();
            pivotPoint = i - xpathNodeStartPoint;
            break;
        }
        String xpathToRemove = xpathToRemoveSb.toString();
        if (xpathRhs.startsWith("/Fields/CustomFields/CustomField[@name=")) {
            xpathToRemove = xpathRhs;
        }
        this.remove(sectionTypeRhs, rootxpathRhs, xpathToRemove, forMatchedRhs, evalResults, titleExt.getTitle());
        if (fields.size() > 0) {
            NormalizationOverrideHelper noh = new NormalizationOverrideHelper();
            try {
                noh.override(fieldType, fields, sectionTypeRhs, rootxpathRhs, xpathRhs, forMatchedRhs, evalResults, titleExt, cardinality, pivotPoint, xpath);
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new RuntimeException(e);
            }
        }
    }

    public static List<XpathNodeCardinality> getXpathCardinality(String sectionType, String xpath) {
        SearchSchemaHelper ssh = new SearchSchemaHelper();
        List nodes = ssh.getXpathCardinality(sectionType, xpath);
        if (xpath.startsWith("/Fields/CustomFields/CustomField[@name=") && !NormalizationActions.customFieldIsMultiValue(sectionType, xpath)) {
            for (XpathNodeCardinality node : nodes) {
                if (!node.getNodeName().equals("CustomField")) continue;
                node.setCardinality(1);
                break;
            }
        }
        return nodes;
    }

    private static boolean customFieldIsMultiValue(String assetType, String xpath) {
        String customFieldName = xpath.substring(xpath.indexOf("=") + 1, xpath.indexOf("]"));
        if (assetType.startsWith("NEW/")) {
            assetType = assetType.substring(4);
        }
        ICustomFieldManager custManager = (ICustomFieldManager)InjectionUtil.injectInstance((String)"cms/CustomFieldManagerService/local", ICustomFieldManager.class);
        for (CustomFieldGroup group : custManager.getAllGroups()) {
            if (!group.getAssetPath().equals(assetType)) continue;
            for (CustomField field : group.getCustomFieldList()) {
                if (!field.getName().equals(customFieldName) || field.getMultiValue() == null) continue;
                return field.getMultiValue().equalsIgnoreCase("Y");
            }
        }
        return false;
    }

    @ActionAnnotations.Action(name="normalizationCopyIncludeBlanksLabel", parms={"fieldType", "sectionType", "rootxpath", "xpath", "forMatched", "sectionTypeRhs", "rootxpathRhs", "xpathRhs", "forMatchedRhs", "matchedItems", "titleExt"}, useSuggestedValues=true, fieldTypesAllowed={FieldType.ASSET, FieldType.LICENSE, FieldType.ENHANCEMENT}, assetTypesDisallowed={})
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.STRING, DataTypes.FLOAT, DataTypes.LONG, DataTypes.BOOLEAN, DataTypes.DATE, DataTypes.TIME, DataTypes.TIMECODE}, valueType={DataTypes.STRING, DataTypes.FLOAT, DataTypes.LONG, DataTypes.BOOLEAN, DataTypes.DATE, DataTypes.TIME, DataTypes.TIMECODE})
    public void copyIncludeBlanks(FieldType fieldType, String sectionType, String rootxpath, String xpath, Boolean forMatched, String sectionTypeRhs, String rootxpathRhs, String xpathRhs, Boolean forMatchedRhs, EvaluatorResults evalResults, TitleExt titleExt) {
        List<Field> childMatchedFields;
        List<? extends IField> fields;
        String value = "";
        if (forMatched.booleanValue()) {
            fields = NormalizationActions.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, titleExt.getTitle(), false);
        } else {
            try {
                fields = titleExt.getFields(fieldType, sectionType, xpath);
            }
            catch (EvaluatorException e) {
                logger.error((Object)e);
                throw new RuntimeException(e);
            }
        }
        if (fields.size() > 0) {
            value = fields.get(0).getValue();
            NormalizationChangeAction changer = new NormalizationChangeAction(sectionTypeRhs, rootxpathRhs, xpathRhs, forMatchedRhs, value, evalResults, titleExt.getTitle());
            changer.change();
        } else if (!forMatched.booleanValue() && titleExt.fieldCanBeThere(fieldType, sectionType, xpath)) {
            this.remove(sectionTypeRhs, rootxpathRhs, xpathRhs, forMatchedRhs, evalResults, titleExt.getTitle());
        } else if (forMatched.booleanValue() && (childMatchedFields = NormalizationActions.findFields(sectionType, rootxpath, rootxpath, forMatched, evalResults, titleExt.getSeries(), true)).size() > 0) {
            this.remove(sectionTypeRhs, rootxpathRhs, xpathRhs, forMatchedRhs, evalResults, titleExt.getTitle());
        }
    }

    @ActionAnnotations.Action(name="normalizationPrefixFromNonPackageLabel", parms={"fieldType", "sectionType", "rootxpath", "xpath", "forMatched", "sectionTypeRhs", "rootxpathRhs", "xpathRhs", "forMatchedRhs", "matchedItems", "titleExt"}, useSuggestedValues=true, fieldTypesAllowed={FieldType.ASSET, FieldType.LICENSE, FieldType.ENHANCEMENT}, assetTypesAllowed={"SERIES.*"}, assetTypesDisallowed={})
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.STRING, DataTypes.FLOAT, DataTypes.LONG, DataTypes.BOOLEAN, DataTypes.DATE, DataTypes.TIME, DataTypes.TIMECODE}, valueType={DataTypes.STRING, DataTypes.STRING, DataTypes.STRING, DataTypes.STRING, DataTypes.STRING, DataTypes.STRING, DataTypes.STRING})
    public void prefixNonPackage(FieldType fieldType, String sectionType, String rootxpath, String xpath, Boolean forMatched, String sectionTypeRhs, String rootxpathRhs, String xpathRhs, Boolean forMatchedRhs, EvaluatorResults evalResults, TitleExt titleExt) {
        List<? extends IField> fields;
        if (forMatched.booleanValue()) {
            fields = NormalizationActions.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, titleExt.getSeries(), false);
        } else {
            try {
                fields = titleExt.getFields(fieldType, sectionType, xpath);
            }
            catch (EvaluatorException e) {
                logger.error((Object)e);
                throw new RuntimeException(e);
            }
        }
        if (fields.size() > 0) {
            String value = fields.get(0).getValue();
            List<Field> fieldsRhs = NormalizationActions.findFields(sectionTypeRhs, rootxpathRhs, xpathRhs, forMatchedRhs, evalResults, titleExt.getTitle(), false);
            for (Field field : fieldsRhs) {
                field.setValue(value + field.getValue());
            }
        }
    }

    @ActionAnnotations.Action(name="normalizationAppendFromNonPackageLabel", parms={"fieldType", "sectionType", "rootxpath", "xpath", "forMatched", "sectionTypeRhs", "rootxpathRhs", "xpathRhs", "forMatchedRhs", "matchedItems", "titleExt"}, useSuggestedValues=true, fieldTypesAllowed={FieldType.ASSET, FieldType.LICENSE, FieldType.ENHANCEMENT}, assetTypesAllowed={"SERIES.*"}, assetTypesDisallowed={})
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.STRING, DataTypes.FLOAT, DataTypes.LONG, DataTypes.BOOLEAN, DataTypes.DATE, DataTypes.TIME, DataTypes.TIMECODE}, valueType={DataTypes.STRING, DataTypes.STRING, DataTypes.STRING, DataTypes.STRING, DataTypes.STRING, DataTypes.STRING, DataTypes.STRING})
    public void appendNonPackage(FieldType fieldType, String sectionType, String rootxpath, String xpath, Boolean forMatched, String sectionTypeRhs, String rootxpathRhs, String xpathRhs, Boolean forMatchedRhs, EvaluatorResults evalResults, TitleExt titleExt) {
        List<? extends IField> fields;
        if (forMatched.booleanValue()) {
            fields = NormalizationActions.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, titleExt.getSeries(), false);
        } else {
            try {
                fields = titleExt.getFields(fieldType, sectionType, xpath);
            }
            catch (EvaluatorException e) {
                logger.error((Object)e);
                throw new RuntimeException(e);
            }
        }
        if (fields.size() > 0) {
            String value = fields.get(0).getValue();
            List<Field> fieldsRhs = NormalizationActions.findFields(sectionTypeRhs, rootxpathRhs, xpathRhs, forMatchedRhs, evalResults, titleExt.getTitle(), false);
            for (Field field : fieldsRhs) {
                field.setValue(field.getValue() + value);
            }
        }
    }

    @ActionAnnotations.Action(name="normalizationCopyAssetLabel", parms={"sectionType", "forMatched", "matchedItems", "titleExt"}, useSuggestedValues=true, assetTypesAllowed={"SERIES.*"}, assetTypesDisallowed={"SERIES/SEASON"}, xpathFilter={""})
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.COMPLEX}, valueType={DataTypes.COMPLEX})
    public void copyAsset(String sectionType, Boolean forMatched, EvaluatorResults evalResults, TitleExt titleExt) {
        List<Object> assetsToCpy;
        if (forMatched.booleanValue()) {
            assetsToCpy = new ArrayList();
            for (Asset asset : evalResults.getMatchedAssets(sectionType)) {
                assetsToCpy.add(asset);
            }
        } else {
            assetsToCpy = titleExt.getAsset(sectionType);
        }
        Asset packAsset = titleExt.getAsset("PACKAGE").get(0);
        for (Asset asset : assetsToCpy) {
            try {
                packAsset.addChild(new TTVSpecHandler().copyAsset(asset, false));
            }
            catch (AssetCopyException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @ActionAnnotations.Action(name="normalizationPrefixLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "matchedItems", "title"})
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.STRING}, valueType={DataTypes.STRING})
    public void prefix(String sectionType, String rootxpath, String xpath, Boolean forMatched, String value, EvaluatorResults evalResults, Title title) {
        List<Field> fields = NormalizationActions.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        for (Field field : fields) {
            field.setTypedValue((Object)(value + field.getValue()));
        }
    }

    @ActionAnnotations.Action(name="normalizationAppendLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "matchedItems", "title"})
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.STRING}, valueType={DataTypes.STRING})
    public void append(String sectionType, String rootxpath, String xpath, Boolean forMatched, String value, EvaluatorResults evalResults, Title title) {
        List<Field> fields = NormalizationActions.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        for (Field field : fields) {
            field.setTypedValue((Object)(field.getValue() + value));
        }
    }

    @ActionAnnotations.Action(name="removeFirstXCharsLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "matchedItems", "title"})
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.STRING}, valueType={DataTypes.LONG})
    public void removeFirstXChars(String sectionType, String rootxpath, String xpath, Boolean forMatched, Long value, EvaluatorResults evalResults, Title title) {
        List<Field> fields = NormalizationActions.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        for (Field field : fields) {
            int charsToTrim;
            String str = field.getValue();
            long longValue = value;
            if (longValue < 0L) {
                charsToTrim = 0;
            } else {
                int n = charsToTrim = longValue >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)longValue;
            }
            if (charsToTrim > str.length()) {
                this.remove(sectionType, rootxpath, xpath, forMatched, evalResults, title);
                continue;
            }
            field.setTypedValue((Object)str.substring(charsToTrim, str.length()));
        }
    }

    @ActionAnnotations.Action(name="removeLastXCharsLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "matchedItems", "title"})
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.STRING}, valueType={DataTypes.LONG})
    public void removeLastXChars(String sectionType, String rootxpath, String xpath, Boolean forMatched, Long value, EvaluatorResults evalResults, Title title) {
        List<Field> fields = NormalizationActions.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        for (Field field : fields) {
            int charsToTrim;
            String str = field.getValue();
            if (value < 0L) {
                charsToTrim = 0;
            } else {
                int n = charsToTrim = value >= Integer.MAX_VALUE ? Integer.MAX_VALUE : value.intValue();
            }
            if (charsToTrim > str.length()) {
                this.remove(sectionType, rootxpath, xpath, forMatched, evalResults, title);
                continue;
            }
            field.setTypedValue((Object)str.substring(0, str.length() - charsToTrim));
        }
    }

    @ActionAnnotations.Action(name="normalizationAddDaysLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "matchedItems", "title"})
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.DATE}, valueType={DataTypes.LONG})
    public void addDays(String sectionType, String rootxpath, String xpath, Boolean forMatched, Long value, EvaluatorResults evalResults, Title title) {
        List<Field> fields = NormalizationActions.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        if (value >= Integer.MAX_VALUE) {
            int n = Integer.MAX_VALUE;
        }
        int daysToAdd = value <= Integer.MIN_VALUE ? Integer.MIN_VALUE : value.intValue();
        for (Field field : fields) {
            if (!field.getParsable().booleanValue()) continue;
            GregorianCalendar fieldValue = new GregorianCalendar();
            fieldValue.setTime((Date)field.getTypedValue());
            fieldValue.add(6, daysToAdd);
            field.setTypedValue((Object)fieldValue.getTime());
        }
    }

    @ActionAnnotations.Action(name="normalizationSetTimeLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "matchedItems", "title"})
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.DATE}, valueType={DataTypes.TIME})
    public void setTime(String sectionType, String rootxpath, String xpath, Boolean forMatched, String value, EvaluatorResults evalResults, Title title) {
        List<Field> fields = NormalizationActions.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        TimeHelper.setTime(value, fields);
    }

    @ActionAnnotations.Action(name="normalizationAddTimeLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "matchedItems", "title"})
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.DATE, DataTypes.TIME}, valueType={DataTypes.TIME, DataTypes.TIME})
    public void addTime(String sectionType, String rootxpath, String xpath, Boolean forMatched, String value, EvaluatorResults evalResults, Title title) {
        List<Field> fields = NormalizationActions.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        TimeHelper.addTime(value, false, fields);
    }

    @ActionAnnotations.Action(name="normalizationSubtractTimeLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "matchedItems", "title"})
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.DATE, DataTypes.TIME}, valueType={DataTypes.TIME, DataTypes.TIME})
    public void subtractTime(String sectionType, String rootxpath, String xpath, Boolean forMatched, String value, EvaluatorResults evalResults, Title title) {
        List<Field> fields = NormalizationActions.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        TimeHelper.addTime(value, true, fields);
    }

    @ActionAnnotations.Action(name="normalizationAddTimeCodeLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "matchedItems", "title"})
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.TIMECODE}, valueType={DataTypes.TIMECODE})
    public void addTimeCode(String sectionType, String rootxpath, String xpath, Boolean forMatched, String value, EvaluatorResults evalResults, Title title) {
        List<Field> fields = NormalizationActions.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        Map<Long, String> frameRateMap = NormalizationActions.getFrameRates(sectionType, title);
        TimeHelper.addTimeCode(value, frameRateMap, false, fields);
    }

    @ActionAnnotations.Action(name="normalizationSubtractTimeCodeLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "matchedItems", "title"})
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.TIMECODE}, valueType={DataTypes.TIMECODE})
    public void subtractTimeCode(String sectionType, String rootxpath, String xpath, Boolean forMatched, String value, EvaluatorResults evalResults, Title title) {
        List<Field> fields = NormalizationActions.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        Map<Long, String> frameRateMap = NormalizationActions.getFrameRates(sectionType, title);
        TimeHelper.addTimeCode(value, frameRateMap, true, fields);
    }

    @ActionAnnotations.Action(name="normalizationCurrentDatePlus", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "matchedItems", "title"})
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.DATE}, valueType={DataTypes.LONG})
    public void currentDatePlus(String sectionType, String rootxpath, String xpath, Boolean forMatched, String value, EvaluatorResults evalResults, Title title) {
        GregorianCalendar rhsValue = new GregorianCalendar();
        String format = "yyyy-MM-dd";
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        rhsValue.add(5, Integer.parseInt(value));
        NormalizationChangeAction changer = new NormalizationChangeAction(sectionType, rootxpath, xpath, forMatched, formatter.format(rhsValue.getTime()), evalResults, title);
        changer.change();
    }

    @ActionAnnotations.Action(name="normalizationTruncateLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "matchedItems", "title"})
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.STRING}, valueType={DataTypes.LONG})
    public void truncate(String sectionType, String rootxpath, String xpath, Boolean forMatched, Long value, EvaluatorResults evalResults, Title title) {
        List<Field> fields = NormalizationActions.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        for (Field field : fields) {
            int endIndex;
            String str = field.getValue();
            if (value < 0L) {
                endIndex = 0;
            } else {
                int n = endIndex = value >= Integer.MAX_VALUE ? Integer.MAX_VALUE : value.intValue();
            }
            if (str.length() < endIndex) {
                endIndex = str.length();
                continue;
            }
            if (endIndex < 1) {
                this.remove(sectionType, rootxpath, xpath, forMatched, evalResults, title);
                continue;
            }
            field.setTypedValue((Object)str.substring(0, endIndex));
        }
    }

    @ActionAnnotations.Action(name="normalizationMultiplyLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "matchedItems", "title"})
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.LONG, DataTypes.FLOAT}, valueType={DataTypes.LONG, DataTypes.FLOAT})
    public void multiply(String sectionType, String rootxpath, String xpath, Boolean forMatched, String value, EvaluatorResults evalResults, Title title) {
        List<Field> fields = NormalizationActions.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        for (Field field : fields) {
            Number fieldValue;
            if (field.getDataType().equals("float")) {
                BigDecimal val2;
                fieldValue = (Float)field.getTypedValue();
                BigDecimal val1 = new BigDecimal(fieldValue + "");
                if (Float.isInfinite(((Float)(fieldValue = Float.valueOf(val1.multiply(val2 = new BigDecimal(value)).floatValue()))).floatValue())) continue;
                field.setTypedValue((Object)fieldValue);
                continue;
            }
            if (!field.getDataType().equals("integer")) continue;
            fieldValue = (Long)field.getTypedValue();
            fieldValue = (long)((Long)fieldValue).intValue() * Long.parseLong(value);
            field.setTypedValue((Object)fieldValue);
        }
    }

    @ActionAnnotations.Action(name="normalizationSubtractLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "matchedItems", "title"})
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.LONG, DataTypes.FLOAT}, valueType={DataTypes.LONG, DataTypes.FLOAT})
    public void subtract(String sectionType, String rootxpath, String xpath, Boolean forMatched, String value, EvaluatorResults evalResults, Title title) {
        List<Field> fields = NormalizationActions.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        for (Field field : fields) {
            Number fieldValue;
            if (field.getDataType().equals("float")) {
                BigDecimal val2;
                fieldValue = (Float)field.getTypedValue();
                BigDecimal val1 = new BigDecimal(fieldValue + "");
                if (Float.isInfinite(((Float)(fieldValue = Float.valueOf(val1.subtract(val2 = new BigDecimal(value)).floatValue()))).floatValue())) continue;
                field.setTypedValue((Object)fieldValue);
                continue;
            }
            if (!field.getDataType().equals("integer")) continue;
            fieldValue = (Long)field.getTypedValue();
            fieldValue = (long)((Long)fieldValue).intValue() - Long.parseLong(value);
            field.setTypedValue((Object)fieldValue);
        }
    }

    @ActionAnnotations.Action(name="normalizationAddLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "matchedItems", "title"})
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.LONG, DataTypes.FLOAT}, valueType={DataTypes.LONG, DataTypes.FLOAT})
    public void add(String sectionType, String rootxpath, String xpath, Boolean forMatched, String value, EvaluatorResults evalResults, Title title) {
        List<Field> fields = NormalizationActions.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        for (Field field : fields) {
            Number fieldValue;
            if (field.getDataType().equals("float")) {
                BigDecimal val2;
                fieldValue = (Float)field.getTypedValue();
                BigDecimal val1 = new BigDecimal(String.valueOf(fieldValue));
                if (Float.isInfinite(((Float)(fieldValue = Float.valueOf(val1.add(val2 = new BigDecimal(value)).floatValue()))).floatValue())) continue;
                field.setTypedValue((Object)fieldValue);
                continue;
            }
            if (!field.getDataType().equals("integer")) continue;
            fieldValue = (Long)field.getTypedValue();
            fieldValue = (long)((Long)fieldValue).intValue() + Long.parseLong(value);
            field.setTypedValue((Object)fieldValue);
        }
    }

    @ActionAnnotations.Action(name="normalizationDivideLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "matchedItems", "title"})
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.LONG, DataTypes.FLOAT}, valueType={DataTypes.LONG, DataTypes.FLOAT})
    public void divide(String sectionType, String rootxpath, String xpath, Boolean forMatched, String value, EvaluatorResults evalResults, Title title) {
        if (Float.parseFloat(value) == 0.0f) {
            return;
        }
        List<Field> fields = NormalizationActions.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        for (Field field : fields) {
            Number fieldValue;
            if (field.getDataType().equals("float")) {
                BigDecimal val2;
                fieldValue = (Float)field.getTypedValue();
                BigDecimal val1 = new BigDecimal(fieldValue + "");
                if (Float.isInfinite(((Float)(fieldValue = Float.valueOf(val1.divide(val2 = new BigDecimal(value), 10, 4).floatValue()))).floatValue())) continue;
                field.setTypedValue((Object)fieldValue);
                continue;
            }
            if (!field.getDataType().equals("integer")) continue;
            fieldValue = (Long)field.getTypedValue();
            fieldValue = (long)((Long)fieldValue).intValue() / Long.parseLong(value);
            field.setTypedValue((Object)fieldValue);
        }
    }

    @ActionAnnotations.Action(name="normalizationRoundLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "matchedItems", "title"})
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.FLOAT}, valueType={DataTypes.LONG})
    public void round(String sectionType, String rootxpath, String xpath, Boolean forMatched, Long value, EvaluatorResults evalResults, Title title) {
        if (value < 0L || value >= Integer.MAX_VALUE) {
            return;
        }
        int roundDigits = value.intValue();
        List<Field> fields = NormalizationActions.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        for (Field field : fields) {
            Float fieldValue = (Float)field.getTypedValue();
            if (roundDigits == 0) {
                field.setTypedValue((Object)new Float(Math.round(fieldValue.floatValue())));
                continue;
            }
            double mult = Math.pow(10.0, roundDigits);
            fieldValue = new Float((double)Math.round((double)fieldValue.floatValue() * mult) / mult);
            field.setTypedValue((Object)fieldValue);
        }
    }

    @ActionAnnotations.Action(name="normalizationRemoveLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "matchedItems", "title"})
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.COMPLEX, DataTypes.STRING, DataTypes.FLOAT, DataTypes.LONG, DataTypes.DATE, DataTypes.BOOLEAN, DataTypes.TIME, DataTypes.TIMECODE}, valueType={DataTypes.COMPLEX, DataTypes.COMPLEX, DataTypes.COMPLEX, DataTypes.COMPLEX, DataTypes.COMPLEX, DataTypes.COMPLEX, DataTypes.COMPLEX, DataTypes.COMPLEX})
    public void remove(String sectionType, String rootxpath, String xpath, Boolean forMatched, EvaluatorResults evalResults, Title title) {
        if (forMatched.booleanValue() && xpath.isEmpty()) {
            this.removeAssets(evalResults.getMatchedAssets(sectionType));
        } else if (xpath.isEmpty()) {
            this.removeAssets(title.getAsset().getAllAssetsWithLineage(this.breakApartAssetType(sectionType)));
        } else {
            List<Field> fields = NormalizationActions.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, true);
            for (Field field : fields) {
                field.getParentAsset().getFields().remove(field);
            }
            if (fields.size() > 0) {
                FieldIndexCleaner.fixIndexOnRemove(sectionType, xpath, title);
            }
        }
    }

    private List<String> breakApartAssetType(String assetType) {
        ArrayList<String> assetTypes = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(assetType, CATEGORY_SEPERATOR);
        while (st.hasMoreTokens()) {
            assetTypes.add(st.nextToken());
        }
        return assetTypes;
    }

    @ActionAnnotations.Action(name="normalizationReplaceLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "value2", "matchedItems", "title"}, parmLabels={"", "", "", "", "find", "replace", "", ""})
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.STRING}, valueType={DataTypes.STRING})
    public void replace(String sectionType, String rootxpath, String xpath, Boolean forMatched, String value, String value2, EvaluatorResults evalResults, Title title) {
        List<Field> fields = NormalizationActions.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        for (Field field : fields) {
            String val = field.getValue().replace(value, value2);
            field.setValue(val);
        }
    }

    @ActionAnnotations.Action(name="normalizationReplaceRegexLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "value2", "matchedItems", "title"}, parmLabels={"", "", "", "", "find", "replace", "", ""})
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.STRING}, valueType={DataTypes.STRING})
    public void replaceRegex(String sectionType, String rootxpath, String xpath, Boolean forMatched, String value, String value2, EvaluatorResults evalResults, Title title) {
        List<Field> fields = NormalizationActions.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        for (Field field : fields) {
            String val = field.getValue().replaceAll(value, value2);
            field.setValue(val);
        }
    }

    @ActionAnnotations.Action(name="normalizationInsertBeforeLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "value2", "matchedItems", "title"}, parmLabels={"", "", "", "", "find", "insert", "", ""}, xpathFilter={"/Fields/Categories/Category/Text"})
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.STRING}, valueType={DataTypes.STRING})
    public void insertBefore(String sectionType, String rootxpath, String xpath, Boolean forMatched, String value, String value2, EvaluatorResults evalResults, Title title) {
        String find = value;
        String insert = value2;
        List<Field> fields = NormalizationActions.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        for (Field field : fields) {
            List<String> categoryList = this.breakApartCategory(field.getValue());
            String result = "";
            for (int i = 0; i < categoryList.size(); ++i) {
                if (categoryList.get(i).equals(find)) {
                    if (i > 0) {
                        result = result + CATEGORY_SEPERATOR;
                    }
                    result = result + insert;
                    if (i == 0) {
                        result = result + CATEGORY_SEPERATOR;
                    }
                }
                if (i > 0) {
                    result = result + CATEGORY_SEPERATOR;
                }
                result = result + categoryList.get(i);
            }
            field.setValue(result);
        }
    }

    @ActionAnnotations.Action(name="normalizationInsertAfterLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "value2", "matchedItems", "title"}, parmLabels={"", "", "", "", "find", "insert", "", ""}, xpathFilter={"/Fields/Categories/Category/Text"})
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.STRING}, valueType={DataTypes.STRING})
    public void insertAfter(String sectionType, String rootxpath, String xpath, Boolean forMatched, String value, String value2, EvaluatorResults evalResults, Title title) {
        String find = value;
        String insert = value2;
        List<Field> fields = NormalizationActions.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        for (Field field : fields) {
            List<String> categoryList = this.breakApartCategory(field.getValue());
            String result = "";
            for (int i = 0; i < categoryList.size(); ++i) {
                if (i > 0) {
                    result = result + CATEGORY_SEPERATOR;
                }
                result = result + categoryList.get(i);
                if (!categoryList.get(i).equals(find)) continue;
                result = result + CATEGORY_SEPERATOR;
                result = result + insert;
            }
            field.setValue(result);
        }
    }

    @ActionAnnotations.Action(name="normalizationReplaceBeforeLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "value2", "matchedItems", "title"}, parmLabels={"", "", "", "", "find", "replace", "", ""}, xpathFilter={"/Fields/Categories/Category/Text"})
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.STRING}, valueType={DataTypes.STRING})
    public void replaceBefore(String sectionType, String rootxpath, String xpath, Boolean forMatched, String value, String value2, EvaluatorResults evalResults, Title title) {
        String find = value;
        String replace = value2;
        List<Field> fields = NormalizationActions.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        for (Field field : fields) {
            List<String> categoryList = this.breakApartCategory(field.getValue());
            for (int i = 0; i < categoryList.size(); ++i) {
                if (!categoryList.get(i).equals(find) || i <= 0) continue;
                categoryList.set(i - 1, replace);
            }
            field.setValue(this.buildCategory(categoryList));
        }
    }

    @ActionAnnotations.Action(name="normalizationReplaceAfterLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "value2", "matchedItems", "title"}, parmLabels={"", "", "", "", "find", "replace", "", ""}, xpathFilter={"/Fields/Categories/Category/Text"})
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.STRING}, valueType={DataTypes.STRING})
    public void replaceAfter(String sectionType, String rootxpath, String xpath, Boolean forMatched, String value, String value2, EvaluatorResults evalResults, Title title) {
        String find = value;
        String replace = value2;
        List<Field> fields = NormalizationActions.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        for (Field field : fields) {
            List<String> categoryList = this.breakApartCategory(field.getValue());
            for (int i = 0; i < categoryList.size(); ++i) {
                if (!categoryList.get(i).equals(find) || i >= categoryList.size() - 1) continue;
                categoryList.set(i + 1, replace);
            }
            field.setValue(this.buildCategory(categoryList));
        }
    }

    @ActionAnnotations.Action(name="normalizationRemoveBeforeLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "matchedItems", "title"}, xpathFilter={"/Fields/Categories/Category/Text"})
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.STRING}, valueType={DataTypes.STRING})
    public void removeBefore(String sectionType, String rootxpath, String xpath, Boolean forMatched, String value, EvaluatorResults evalResults, Title title) {
        String find = value;
        List<Field> fields = NormalizationActions.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        for (Field field : fields) {
            List<String> categoryList = this.breakApartCategory(field.getValue());
            for (int i = 0; i < categoryList.size(); ++i) {
                if (!categoryList.get(i).equals(find) || i <= 0) continue;
                categoryList.remove(i - 1);
                --i;
            }
            field.setValue(this.buildCategory(categoryList));
        }
    }

    @ActionAnnotations.Action(name="normalizationRemoveAfterLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "matchedItems", "title"}, xpathFilter={"/Fields/Categories/Category/Text"})
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.STRING}, valueType={DataTypes.STRING})
    public void removeAfter(String sectionType, String rootxpath, String xpath, Boolean forMatched, String value, EvaluatorResults evalResults, Title title) {
        String find = value;
        List<Field> fields = NormalizationActions.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        for (Field field : fields) {
            List<String> categoryList = this.breakApartCategory(field.getValue());
            for (int i = 0; i < categoryList.size(); ++i) {
                if (!categoryList.get(i).equals(find) || i >= categoryList.size() - 1) continue;
                categoryList.remove(i + 1);
            }
            field.setValue(this.buildCategory(categoryList));
        }
    }

    @ActionAnnotations.Action(name="normalizationReplaceTopLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "matchedItems", "title"}, xpathFilter={"/Fields/Categories/Category/Text"})
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.STRING}, valueType={DataTypes.STRING})
    public void replaceTop(String sectionType, String rootxpath, String xpath, Boolean forMatched, String value, EvaluatorResults evalResults, Title title) {
        List<Field> fields = NormalizationActions.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        for (Field field : fields) {
            String category = field.getValue();
            if (category.startsWith(CATEGORY_SEPERATOR)) {
                category = category.substring(1);
            }
            if (!category.contains(CATEGORY_SEPERATOR)) continue;
            category = category.substring(category.indexOf(CATEGORY_SEPERATOR));
            field.setValue(value + category);
        }
    }

    @ActionAnnotations.Action(name="normalizationReplaceChildLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "matchedItems", "title"}, xpathFilter={"/Fields/Categories/Category/Text"})
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.STRING}, valueType={DataTypes.STRING})
    public void replaceChild(String sectionType, String rootxpath, String xpath, Boolean forMatched, String value, EvaluatorResults evalResults, Title title) {
        List<Field> fields = NormalizationActions.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        for (Field field : fields) {
            String category = field.getValue();
            if (category.endsWith(CATEGORY_SEPERATOR)) {
                category = category.substring(0, category.length() - 1);
            }
            if (!category.contains(CATEGORY_SEPERATOR)) continue;
            category = category.substring(0, category.lastIndexOf(CATEGORY_SEPERATOR) + 1);
            field.setValue(category + value);
        }
    }

    @ActionAnnotations.Action(name="normalizationReplaceParents", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "matchedItems", "title"}, xpathFilter={"/Fields/Categories/Category/Text"})
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.STRING}, valueType={DataTypes.STRING})
    public void replaceParents(String sectionType, String rootxpath, String xpath, Boolean forMatched, String value, EvaluatorResults evalResults, Title title) {
        List<Field> fields = NormalizationActions.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        for (Field field : fields) {
            String category = field.getValue();
            if (category.endsWith(CATEGORY_SEPERATOR)) {
                category = category.substring(0, category.length() - 1);
            }
            if (!category.contains(CATEGORY_SEPERATOR)) continue;
            category = category.substring(category.lastIndexOf(CATEGORY_SEPERATOR), category.length());
            field.setValue(value + category);
        }
    }

    @ActionAnnotations.Action(name="normalizationRemoveParents", parms={"sectionType", "rootxpath", "xpath", "forMatched", "matchedItems", "title"}, xpathFilter={"/Fields/Categories/Category/Text"})
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.STRING}, valueType={DataTypes.COMPLEX})
    public void removeParents(String sectionType, String rootxpath, String xpath, Boolean forMatched, EvaluatorResults evalResults, Title title) {
        List<Field> fields = NormalizationActions.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        for (Field field : fields) {
            String category = field.getValue();
            if (category.endsWith(CATEGORY_SEPERATOR)) {
                category = category.substring(0, category.length() - 1);
            }
            if (!category.contains(CATEGORY_SEPERATOR)) continue;
            category = category.substring(category.lastIndexOf(CATEGORY_SEPERATOR) + 1, category.length());
            field.setValue(category);
        }
    }

    @ActionAnnotations.Action(name="normalizationRemoveTop", parms={"sectionType", "rootxpath", "xpath", "forMatched", "matchedItems", "title"}, xpathFilter={"/Fields/Categories/Category/Text"})
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.STRING}, valueType={DataTypes.COMPLEX})
    public void removeTop(String sectionType, String rootxpath, String xpath, Boolean forMatched, EvaluatorResults evalResults, Title title) {
        List<Field> fields = NormalizationActions.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        for (Field field : fields) {
            String category = field.getValue();
            if (category.startsWith(CATEGORY_SEPERATOR)) {
                category = category.substring(1);
            }
            if (!category.contains(CATEGORY_SEPERATOR)) continue;
            category = category.substring(category.indexOf(CATEGORY_SEPERATOR) + 1);
            field.setValue(category);
        }
    }

    private String buildCategory(List<String> category) {
        String result = "";
        for (int i = 0; i < category.size(); ++i) {
            if (i > 0) {
                result = result + CATEGORY_SEPERATOR;
            }
            result = result + category.get(i);
        }
        return result;
    }

    private List<String> breakApartCategory(String category) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(category, CATEGORY_SEPERATOR);
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken());
        }
        return result;
    }

    @ActionAnnotations.Action(name="normalizationAddTopLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "matchedItems", "title"}, xpathFilter={"/Fields/Categories/Category/Text"})
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.STRING}, valueType={DataTypes.STRING})
    public void addTop(String sectionType, String rootxpath, String xpath, Boolean forMatched, String value, EvaluatorResults evalResults, Title title) {
        String top = value;
        List<Field> fields = NormalizationActions.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        for (Field field : fields) {
            String category = field.getValue();
            if (!category.startsWith(CATEGORY_SEPERATOR)) {
                category = CATEGORY_SEPERATOR + category;
            }
            field.setValue(top + category);
        }
    }

    @ActionAnnotations.Action(name="normalizationAddChildLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "matchedItems", "title"}, xpathFilter={"/Fields/Categories/Category/Text"})
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.STRING}, valueType={DataTypes.STRING})
    public void addChild(String sectionType, String rootxpath, String xpath, Boolean forMatched, String value, EvaluatorResults evalResults, Title title) {
        String child = value;
        List<Field> fields = NormalizationActions.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        for (Field field : fields) {
            String category = field.getValue();
            if (!category.endsWith(CATEGORY_SEPERATOR)) {
                category = category + CATEGORY_SEPERATOR;
            }
            field.setValue(category + child);
        }
    }

    @ActionAnnotations.Action(name="normalizationReplaceTier1Label", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "matchedItems", "title"}, xpathFilter={"/Fields/Categories/Category/Text"})
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.STRING}, valueType={DataTypes.STRING})
    public void replaceTier1(String sectionType, String rootxpath, String xpath, Boolean forMatched, String value, EvaluatorResults evalResults, Title title) {
        this.replaceTier(sectionType, rootxpath, xpath, forMatched, value, evalResults, title, 1);
    }

    @ActionAnnotations.Action(name="normalizationReplaceTier2Label", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "matchedItems", "title"}, xpathFilter={"/Fields/Categories/Category/Text"})
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.STRING}, valueType={DataTypes.STRING})
    public void replaceTier2(String sectionType, String rootxpath, String xpath, Boolean forMatched, String value, EvaluatorResults evalResults, Title title) {
        this.replaceTier(sectionType, rootxpath, xpath, forMatched, value, evalResults, title, 2);
    }

    @ActionAnnotations.Action(name="normalizationReplaceTier3Label", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "matchedItems", "title"}, xpathFilter={"/Fields/Categories/Category/Text"})
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.STRING}, valueType={DataTypes.STRING})
    public void replaceTier3(String sectionType, String rootxpath, String xpath, Boolean forMatched, String value, EvaluatorResults evalResults, Title title) {
        this.replaceTier(sectionType, rootxpath, xpath, forMatched, value, evalResults, title, 3);
    }

    @ActionAnnotations.Action(name="normalizationReplaceTier4Label", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "matchedItems", "title"}, xpathFilter={"/Fields/Categories/Category/Text"})
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.STRING}, valueType={DataTypes.STRING})
    public void replaceTier4(String sectionType, String rootxpath, String xpath, Boolean forMatched, String value, EvaluatorResults evalResults, Title title) {
        this.replaceTier(sectionType, rootxpath, xpath, forMatched, value, evalResults, title, 4);
    }

    @ActionAnnotations.Action(name="removeAllOthersLabel", parms={"sectionType", "matchedItems", "title"}, matchedOnly=true, xpathFilter={""})
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.COMPLEX}, valueType={DataTypes.COMPLEX})
    public void removeAllOthers(String sectionType, EvaluatorResults evalResults, Title title) {
        List<Asset> assets = evalResults.getMatchedAssets(sectionType);
        String workingSectionType = sectionType;
        if (sectionType.startsWith("NEW/")) {
            workingSectionType = sectionType.substring(4);
        }
        for (Asset currKeepAsset : assets) {
            Asset parent = currKeepAsset.getRoot().getAssetsParent(currKeepAsset);
            Iterator iterator = parent.getRelations().iterator();
            while (iterator.hasNext()) {
                Relation relation = (Relation)iterator.next();
                boolean assetIsSaved = false;
                if (!relation.getTargetAsset().getPath().equals(workingSectionType)) continue;
                for (Asset keepAsset : assets) {
                    if (relation.getTargetAsset() != keepAsset) continue;
                    assetIsSaved = true;
                    break;
                }
                if (assetIsSaved) continue;
                iterator.remove();
            }
        }
    }

    @ActionAnnotations.Action(name="normalizationToUpperCaseLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "matchedItems", "title"})
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.STRING}, valueType={DataTypes.STRING})
    public void toUpperCase(String sectionType, String rootxpath, String xpath, Boolean forMatched, EvaluatorResults evalResults, Title title) {
        List<Field> fields = NormalizationActions.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        for (Field field : fields) {
            field.setTypedValue((Object)field.getValue().toUpperCase());
        }
    }

    @ActionAnnotations.Action(name="normalizationToLowerCaseLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "matchedItems", "title"})
    @ActionAnnotations.GenericTypeMapping(dataType={DataTypes.STRING}, valueType={DataTypes.STRING})
    public void toLowerCase(String sectionType, String rootxpath, String xpath, Boolean forMatched, EvaluatorResults evalResults, Title title) {
        List<Field> fields = NormalizationActions.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        for (Field field : fields) {
            field.setTypedValue((Object)field.getValue().toLowerCase());
        }
    }

    private void replaceTier(String sectionType, String rootxpath, String xpath, Boolean forMatched, String value, EvaluatorResults evalResults, Title title, int tier) {
        List<Field> fields = NormalizationActions.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        for (Field field : fields) {
            int currTier;
            StringTokenizer tokenizer = new StringTokenizer(field.getValue(), CATEGORY_SEPERATOR);
            StringBuilder newVal = new StringBuilder();
            for (currTier = 1; currTier < tier && tokenizer.hasMoreTokens(); ++currTier) {
                if (currTier > 1) {
                    newVal.append(CATEGORY_SEPERATOR);
                }
                newVal.append(tokenizer.nextToken());
            }
            if (tokenizer.hasMoreTokens()) {
                if (currTier > 1) {
                    newVal.append(CATEGORY_SEPERATOR);
                }
                newVal.append(value);
                tokenizer.nextToken();
                ++currTier;
            }
            while (tokenizer.hasMoreTokens()) {
                if (currTier > 1) {
                    newVal.append(CATEGORY_SEPERATOR);
                }
                newVal.append(tokenizer.nextToken());
                ++currTier;
            }
            field.setValue(newVal.toString());
        }
    }

    private void removeAssets(List<Asset> assetsToRemove) {
        for (Asset assetToRemove : assetsToRemove) {
            Asset parent = assetToRemove.getRoot().getAssetsParent(assetToRemove);
            Iterator iterator = parent.getRelations().iterator();
            while (iterator.hasNext()) {
                Relation r = (Relation)iterator.next();
                if (r.getTargetAsset() != assetToRemove) continue;
                iterator.remove();
            }
        }
    }

    public static List<Field> findFields(String assetType, String rootxpath, String xpath, Boolean forMatched, EvaluatorResults evalResults, Title title, boolean addChildren) {
        List<Asset> matchedAssets = evalResults.getMatchedAssets(assetType);
        List<Object> fields = new ArrayList<Field>();
        if (forMatched.booleanValue() && !rootxpath.isEmpty() && DataTypeMappingReader.getInstance().determineDataType(rootxpath) != null) {
            return evalResults.getMatchedFields(assetType, xpath);
        }
        if (forMatched.booleanValue() && !rootxpath.isEmpty()) {
            List<MatchedItem> matchedFieldTrees = evalResults.getMatchedItems();
            if (matchedFieldTrees != null) {
                for (MatchedItem mi : matchedFieldTrees) {
                    FieldTree fieldTree = mi.getFieldTree();
                    List ftn = fieldTree.toList();
                    if (!fieldTree.getRootElement().getName().equals(rootxpath)) continue;
                    for (FieldTreeNode node : ftn) {
                        Field field = node.getField();
                        if (field == null) continue;
                        String fieldAssetType = NormalizationActions.getFullAssetType(field.getParentAsset());
                        if (field.getTtvXPath().equals(xpath) && fieldAssetType.equals(assetType)) {
                            fields.add(field);
                            continue;
                        }
                        if (!addChildren || !field.getTtvXPath().startsWith(xpath + CATEGORY_SEPERATOR) || !fieldAssetType.equals(assetType)) continue;
                        fields.add(field);
                    }
                }
            }
        } else if (forMatched.booleanValue() && matchedAssets != null && matchedAssets.size() > 0 && !assetType.endsWith("/FILE")) {
            for (Asset asset : matchedAssets) {
                fields.addAll(NormalizationActions.getFieldsForXpath(asset, xpath));
            }
        } else {
            fields = title.getAsset().getAllFieldsForXpath(Arrays.asList(assetType.split(CATEGORY_SEPERATOR)), xpath);
        }
        return fields;
    }

    public static Map<Long, String> getFrameRates(String assetType, Title title) {
        HashMap<Long, String> frameRateMap = new HashMap();
        String xpath = "/Fields/Content/FrameRate";
        frameRateMap = title.getAsset().getAssetIdMapWithFieldValueForXpath(Arrays.asList(assetType.split(CATEGORY_SEPERATOR)), xpath);
        return frameRateMap;
    }

    private static String getFullAssetType(Asset asset) {
        ArrayList<String> assetTypes = new ArrayList<String>();
        if (asset.getRoot() == null) {
            return asset.getAssetType();
        }
        NormalizationActions.getFullAsseetType(assetTypes, asset, asset.getRoot());
        StringBuilder sb = new StringBuilder();
        if (assetTypes.size() == 0) {
            return "";
        }
        sb.append((String)assetTypes.get(assetTypes.size() - 1));
        for (int i = assetTypes.size() - 2; i >= 0; --i) {
            sb.append(CATEGORY_SEPERATOR);
            sb.append((String)assetTypes.get(i));
        }
        return sb.toString();
    }

    private static boolean getFullAsseetType(List<String> assetTypes, Asset targetAsset, Asset currAsset) {
        boolean found = false;
        for (Relation r : currAsset.getRelations()) {
            Asset currTarget = r.getTargetAsset();
            if (currTarget == targetAsset) {
                assetTypes.add(r.getTargetAsset().getAssetType());
                found = true;
                break;
            }
            if (!NormalizationActions.getFullAsseetType(assetTypes, targetAsset, currTarget)) continue;
            found = true;
        }
        if (found) {
            assetTypes.add(currAsset.getAssetType());
            return true;
        }
        return false;
    }

    private static ArrayList<Field> getFieldsForXpath(Asset asset, String xpath) {
        ArrayList<Field> list = new ArrayList<Field>();
        for (Field f : asset.getFields()) {
            if (!f.getTtvXPath().startsWith(xpath)) continue;
            list.add(f);
        }
        return list;
    }
}

