/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.actions;

import com.tandbergtv.marvin.actions.Action;
import com.tandbergtv.marvin.actions.ProcessingActionResult;
import com.tandbergtv.marvin.metadata.ActionAnnotations;
import com.tandbergtv.marvin.udt.ActionMessage;
import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.routing.SoapRouter;
import com.tandbergtv.workflow.comm.routing.CommunicationException;
import com.tandbergtv.workflow.comm.routing.IRoutingService;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IPayload;
import com.tandbergtv.workflow.message.MessageImpl;
import com.tandbergtv.workflow.message.StringPayload;
import com.tandbergtv.workflow.message.WPCLCommand;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import com.tandbergtv.workflow.message.util.Marshaller;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

@ActionAnnotations(name="PROCESSING")
public class ProcessingActions
extends Action {
    private static final String NEPTUNE_SETTINGS_PATH = "com.ericsson.cms.rules";
    private static final String TEMPLATE_NAME_PARAM = "_template";
    private static final String COMMAND_NAME = "create";
    private static final String UID = "re0101";
    private static final Logger logger = Logger.getLogger(ProcessingActions.class);
    private static final int DEFAULT_RETRY_DELAY = 30000;
    private static final int DEFAULT_MAX_NUM_RETRIES = 10;
    private static final String PROPERTY_NAME_RETRY_DELAY = "retryDelayMilliseconds";
    private static final String PROPERTY_NAME_MAX_RETRIES = "maxRetries";
    private static final int MIN_RETRY_DELAY_ALLOWED = 1000;
    private static final int MAX_RETRY_DELAY_ALLOWED = 300000;
    private static final int MIN_MAX_RETRIES_ALLOWED = 0;
    private static final int MAX_MAX_RETRIES_ALLOWED = 100;
    private static IConfigurationService configReaderService = (IConfigurationService)InjectionUtil.injectInstance((String)"cms/ConfigurationService/local", IConfigurationService.class);

    @ActionAnnotations.Action(name="startWorkOrderLabel", parms={"templateName", "title"})
    public ProcessingActionResult startWorkOrder(String templateName, Title title) {
        WorkflowMessage message = WorkflowMessageFactory.createControlMessage((String)UID);
        WPCLCommand command = new WPCLCommand(COMMAND_NAME);
        command.addParameter(TEMPLATE_NAME_PARAM, templateName);
        message.setCommand(command);
        message.getPayload().putValue("titleId", title.getId().toString());
        SoapRouter router = new SoapRouter();
        ActionMessage resultMessage = new ActionMessage();
        int numRetries = 0;
        try {
            this.sendToRouter((IRoutingService)router, message, resultMessage, templateName, title, numRetries);
        }
        catch (Exception e) {
            String stringMessage = "DUDE, there was an error when kicking off " + templateName + " from the actionator for titleId " + title.getId() + ".";
            logger.error((Object)stringMessage, (Throwable)e);
            resultMessage.setMessage(stringMessage);
        }
        ProcessingActionResult rr = new ProcessingActionResult(resultMessage, templateName);
        return rr;
    }

    private IMessage getMessage(WorkflowMessage wpcl) throws Exception {
        Document document = Marshaller.newMarshaller().marshal(wpcl);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(document.getDocumentElement()), new StreamResult(writer));
        return new MessageImpl((IPayload)new StringPayload(writer.getBuffer().toString()));
    }

    private void sendToRouter(IRoutingService router, WorkflowMessage message, ActionMessage resultMessage, String templateName, Title title, int numRetries) throws Exception {
        block5: {
            boolean canPingRouter = false;
            try {
                router.send(this.getMessage(message));
                canPingRouter = true;
                String stringMessage = "Kicked off " + templateName + " template for titleId " + title.getId() + ".";
                logger.info((Object)stringMessage);
                resultMessage.setMessage(stringMessage);
            }
            catch (CommunicationException ce) {
                String warnMsg = "Failed to send message to Router";
                logger.warn((Object)warnMsg, (Throwable)ce);
                if (canPingRouter) break block5;
                int retryDelay = this.getRetryDelay();
                int maxRetries = this.getMaxNumRetries();
                logger.info((Object)("retryDelay : " + retryDelay + ", maxRetries : " + maxRetries));
                try {
                    logger.info((Object)("Sleeping for " + retryDelay + " milliseconds..."));
                    Thread.sleep(retryDelay);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
                if (numRetries <= maxRetries) {
                    logger.info((Object)"Resending to Router...");
                    this.sendToRouter(router, message, resultMessage, templateName, title, ++numRetries);
                }
                String errMsg = "Failed to kick off " + templateName + " template for titleId " + title.getId() + ". Max Retries = " + maxRetries + " reached for pinging router with retryDelay : " + retryDelay + " milliseconds. Abandoning attempts to connect to router.";
                logger.error((Object)errMsg);
                throw new RuntimeException(errMsg);
            }
        }
    }

    private int getRetryDelay() {
        int retryDelay = 30000;
        try {
            retryDelay = Integer.parseInt((String)configReaderService.getProperties(NEPTUNE_SETTINGS_PATH).get(PROPERTY_NAME_RETRY_DELAY));
        }
        catch (NumberFormatException e) {
            logger.warn((Object)"Could not parse integer value from rules property : retryDelayMilliseconds");
        }
        if (retryDelay < 1000) {
            retryDelay = 1000;
        }
        if (retryDelay > 300000) {
            retryDelay = 300000;
        }
        return retryDelay;
    }

    private int getMaxNumRetries() {
        int maxRetries = 10;
        try {
            maxRetries = Integer.parseInt((String)configReaderService.getProperties(NEPTUNE_SETTINGS_PATH).get(PROPERTY_NAME_MAX_RETRIES));
        }
        catch (NumberFormatException e) {
            logger.warn((Object)"Could not parse integer value from rules property : maxRetries");
        }
        if (maxRetries < 0) {
            maxRetries = 0;
        }
        if (maxRetries > 100) {
            maxRetries = 100;
        }
        return maxRetries;
    }
}

