/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.engine;

import com.ericsson.cms.criteria.FieldType;
import com.tandbergtv.marvin.actions.Action;
import com.tandbergtv.marvin.actions.IndexGetter;
import com.tandbergtv.marvin.actions.NormalizationActions;
import com.tandbergtv.marvin.actions.ProcessingActionResult;
import com.tandbergtv.marvin.engine.EvaluatorResults;
import com.tandbergtv.marvin.engine.TitleExt;
import com.tandbergtv.marvin.metadata.ActionAnnotations;
import com.tandbergtv.marvin.udt.ActionMessage;
import com.tandbergtv.marvin.udt.NormalizationActionChange;
import com.tandbergtv.marvin.udt.Priority;
import com.tandbergtv.marvin.udt.RuleResults;
import com.tandbergtv.marvin.udt.TreAction;
import com.tandbergtv.marvin.udt.TreActionParameterValue;
import com.tandbergtv.metadatamanager.model.ChangeListener;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class Actionator {
    private static final Logger logger = Logger.getLogger(Actionator.class);
    private static String PACKAGE = "com.tandbergtv.marvin.actions";
    private Map<String, ActionMethod> methodLookup = new HashMap<String, ActionMethod>();
    private Map<String, Map<String, Method>> methods = new HashMap<String, Map<String, Method>>();
    private static Actionator actionator;

    private Actionator() throws ClassNotFoundException {
        ArrayList<Class<Object>> classes = new ArrayList<Class<Object>>();
        for (String string : IndexGetter.getInstance().getClassList()) {
            Class<Object> clazz = Class.forName(PACKAGE + '.' + string);
            if (!Actionator.isAnnotatedClass(clazz)) continue;
            classes.add(clazz);
        }
        for (Class clazz : classes) {
            List<Method> methodList = Actionator.getAnnotatedMethods(clazz);
            HashMap<String, Method> methodMap = new HashMap<String, Method>();
            for (Method method : methodList) {
                String methodSignature = method.getDeclaringClass().getCanonicalName() + "." + method.getName() + "(";
                for (Class<?> parameter : method.getParameterTypes()) {
                    methodSignature = methodSignature + parameter.getSimpleName() + ", ";
                }
                methodSignature = methodSignature.replaceFirst(", $", ")").replaceFirst("\\($", "()");
                String actionDisplayNameKey = null;
                for (Annotation annotation : method.getAnnotations()) {
                    if (!(annotation instanceof ActionAnnotations.Action)) continue;
                    actionDisplayNameKey = ((ActionAnnotations.Action)annotation).name();
                    break;
                }
                methodMap.put(methodSignature, method);
                this.methodLookup.put(methodSignature, new ActionMethod(clazz, method, actionDisplayNameKey));
            }
            this.methods.put(clazz.getName(), methodMap);
        }
    }

    public static synchronized Actionator getActionator() throws ClassNotFoundException {
        if (actionator == null) {
            actionator = new Actionator();
        }
        return actionator;
    }

    private static List<Method> getAnnotatedMethods(Class<Object> class1) {
        Method[] methods;
        ArrayList<Method> list = new ArrayList<Method>();
        for (Method method : methods = class1.getDeclaredMethods()) {
            if (!Actionator.isAnnotatedMethod(method)) continue;
            list.add(method);
        }
        return list;
    }

    private static boolean isAnnotatedMethod(Method method) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = method.getAnnotations()) {
            if (!(annotation instanceof ActionAnnotations.Action)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAnnotatedClass(Class<Object> c) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = c.getAnnotations()) {
            if (!(annotation instanceof ActionAnnotations)) continue;
            return true;
        }
        return false;
    }

    public Map<String, Map<String, Method>> getMethods() {
        return this.methods;
    }

    public void actionate(List<TreAction> actions, TitleExt titleExt, EvaluatorResults evalResults, final RuleResults ruleResults, final int ruleId, final int ruleSetId, final String ruleSetName) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, InstantiationException {
        logger.debug((Object)("running actionator: " + titleExt.getTitle()));
        long t0 = System.currentTimeMillis();
        for (final TreAction action : actions) {
            ChangeListener changeListener = new ChangeListener(){

                public void handleChange(String xpath, String assetPath, String previousValue, String newValue) {
                    String actionDisplayNameKey = ((ActionMethod)((Actionator)Actionator.this).methodLookup.get((Object)action.getMethod())).actionDisplayNameKey;
                    ruleResults.addChange(new NormalizationActionChange(ruleSetId, ruleSetName, ruleId, actionDisplayNameKey, action.getMethod(), assetPath, xpath, previousValue, newValue));
                }
            };
            titleExt.getTitle().getAsset().registerListener(changeListener);
            logger.debug((Object)("ACTION:" + action.getMethod()));
            Method method = this.methodLookup.get((Object)action.getMethod()).method;
            Object[] params = action.getParams().toArray();
            Object[] outParams = new Object[params.length];
            Class<?>[] paramTypes = method.getParameterTypes();
            for (int i = 0; i < params.length; ++i) {
                TreActionParameterValue tapv = (TreActionParameterValue)params[i];
                if (tapv.getName().equals("title")) {
                    logger.debug((Object)("MODIFIED TITLE:" + titleExt.getTitle()));
                    outParams[i] = titleExt.getTitle();
                    continue;
                }
                if (tapv.getName().equals("matchedItems")) {
                    logger.debug((Object)("ITEMS HAVE BEEN MATCHED:" + evalResults));
                    outParams[i] = evalResults;
                    continue;
                }
                if (tapv.getName().equals("titleExt")) {
                    outParams[i] = titleExt;
                    continue;
                }
                if (tapv.getName().equals("ruleResults")) {
                    outParams[i] = ruleResults;
                    continue;
                }
                logger.debug((Object)"NO MODIFICATIONS");
                if (paramTypes[i].equals(String.class)) {
                    outParams[i] = tapv.getValue() == null ? "" : tapv.getValue();
                    continue;
                }
                if (paramTypes[i].equals(Boolean.TYPE) || paramTypes[i].equals(Boolean.class)) {
                    outParams[i] = Boolean.parseBoolean(tapv.getValue());
                    continue;
                }
                if (paramTypes[i].equals(Integer.TYPE) || paramTypes[i].equals(Integer.class)) {
                    outParams[i] = Integer.parseInt(tapv.getValue());
                    continue;
                }
                if (paramTypes[i].equals(Float.TYPE) || paramTypes[i].equals(Float.class)) {
                    outParams[i] = Float.valueOf(Float.parseFloat(tapv.getValue()));
                    continue;
                }
                if (paramTypes[i].equals(Long.TYPE) || paramTypes[i].equals(Long.class)) {
                    outParams[i] = Long.parseLong(tapv.getValue());
                    continue;
                }
                if (!paramTypes[i].equals(FieldType.class)) continue;
                outParams[i] = FieldType.valueOf((String)tapv.getValue());
            }
            Action actionClass = (Action)this.methodLookup.get((Object)action.getMethod()).clazz.newInstance();
            Object result = method.invoke((Object)actionClass, outParams);
            if (result != null) {
                if (result instanceof ActionMessage) {
                    ActionMessage am = (ActionMessage)result;
                    am.setRuleSetId(ruleSetId);
                    ruleResults.getMessages().add(am);
                } else if (result instanceof ProcessingActionResult) {
                    ProcessingActionResult par = (ProcessingActionResult)result;
                    if (par.getMessage() != null) {
                        ruleResults.getMessages().add(par.getMessage());
                    }
                    ruleResults.getTemplateNames().add(par.getTemplateNames());
                } else if (result instanceof Priority) {
                    Priority priority = (Priority)result;
                    ruleResults.setPriority(priority);
                }
            }
            if (method.getDeclaringClass().equals(NormalizationActions.class)) {
                ruleResults.setModified(true);
                if (method.getName().contains("addAsset")) {
                    ruleResults.setAddedAssets(true);
                }
            }
            logger.debug((Object)("ACTIONATED:" + result));
            titleExt.getTitle().getAsset().unregisterListener(changeListener);
            long t1 = System.currentTimeMillis();
            logger.debug((Object)("********** actionate = " + (t1 - t0) + " ms RuleId = " + ruleSetName));
        }
    }

    private class ActionMethod {
        Class<?> clazz;
        Method method;
        protected String actionDisplayNameKey;

        public ActionMethod(Class<?> clazz, Method method, String actionDisplayNameKey) {
            this.clazz = clazz;
            this.method = method;
            this.actionDisplayNameKey = actionDisplayNameKey;
        }
    }
}

