/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.engine;

import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightField;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.tandbergtv.marvin.actions.TimeHelper;
import com.tandbergtv.marvin.engine.EvaluatorException;
import com.tandbergtv.marvin.engine.IDeterminating;
import com.tandbergtv.marvin.engine.IllegalOperationException;
import com.tandbergtv.metadatamanager.model.IField;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateDeterminating
implements IDeterminating {
    private String exceptionMsg = "value must be a date";
    private IField fieldLhs;
    private IField fieldRhs;
    private Predicate predicate;

    public DateDeterminating(Predicate predicate, IField fieldLhs, IField fieldRhs) throws EvaluatorException {
        if (fieldLhs != null && !fieldLhs.getDataType().equals("date")) {
            throw new EvaluatorException(this.exceptionMsg + " " + fieldLhs.getDataType());
        }
        this.fieldLhs = fieldLhs;
        this.fieldRhs = fieldRhs;
        this.predicate = predicate;
    }

    private boolean rhsContainsUnParasable() {
        return this.fieldRhs != null && this.fieldRhs.getParsable() == false;
    }

    private Date getDateRhs() throws EvaluatorException {
        if (this.predicate instanceof PredicateRightField && this.fieldRhs != null && this.fieldRhs.getParsable().booleanValue()) {
            return (Date)this.fieldRhs.getTypedValue();
        }
        if (this.predicate instanceof PredicateRightField) {
            return null;
        }
        try {
            String s = (String)((PredicateRightValue)this.predicate).getValue().get(0);
            Date date = this.isInteger(s) ? this.getRelativeDate(s) : this.parseDate(s);
            return this.firstDateHell(date);
        }
        catch (ParseException ide) {
            throw new EvaluatorException(this.exceptionMsg, ide);
        }
    }

    public Date getRelativeDate(String s) {
        int numDays = this.getInteger(s);
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(new Date());
        cal.add(10, numDays * 24);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    private Date parseDate(String date) throws ParseException {
        String format = "yyyy-MM-dd";
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.parse(date.substring(0, format.length()));
    }

    private boolean isInteger(String s) {
        try {
            if (!s.isEmpty()) {
                Integer.parseInt(s);
            }
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    private int getInteger(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private Date getDateLhs() {
        if (this.fieldLhs == null || this.containsUnparsable()) {
            return null;
        }
        Date date = (Date)this.fieldLhs.getTypedValue();
        if (date != null) {
            return this.firstDateHell(date);
        }
        return null;
    }

    private Date firstDateHell(Date date) {
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    @Override
    public boolean equal() throws EvaluatorException {
        Date lhs = this.getDateLhs();
        Date rhs = this.getDateRhs();
        if (this.containsUnparsable() || this.rhsContainsUnParasable()) {
            return false;
        }
        if (lhs == null && rhs == null) {
            return true;
        }
        return lhs != null && rhs != null && lhs.equals(rhs);
    }

    @Override
    public boolean greaterThan() throws EvaluatorException {
        Date lhs = this.getDateLhs();
        Date rhs = this.getDateRhs();
        if (this.containsUnparsable() || this.rhsContainsUnParasable()) {
            return false;
        }
        return lhs != null && rhs != null && lhs.after(rhs);
    }

    @Override
    public boolean greaterThanEqual() throws EvaluatorException {
        Date lhs = this.getDateLhs();
        Date rhs = this.getDateRhs();
        if (this.containsUnparsable() || this.rhsContainsUnParasable()) {
            return false;
        }
        return lhs != null && rhs != null && (lhs.after(rhs) || lhs.equals(rhs));
    }

    @Override
    public boolean in() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean isEmpty() throws IllegalOperationException {
        return this.fieldLhs == null;
    }

    @Override
    public boolean isNotEmpty() {
        return this.fieldLhs != null;
    }

    @Override
    public boolean lessThan() throws EvaluatorException {
        Date lhs = this.getDateLhs();
        Date rhs = this.getDateRhs();
        if (this.containsUnparsable() || this.rhsContainsUnParasable()) {
            return false;
        }
        return lhs != null && rhs != null && lhs.before(rhs);
    }

    @Override
    public boolean lessThanEqual() throws EvaluatorException {
        Date lhs = this.getDateLhs();
        Date rhs = this.getDateRhs();
        if (this.containsUnparsable() || this.rhsContainsUnParasable()) {
            return false;
        }
        return lhs != null && rhs != null && (lhs.before(rhs) || lhs.equals(rhs));
    }

    @Override
    public boolean contains() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean notEqual() throws EvaluatorException {
        return !this.equal();
    }

    @Override
    public boolean notIn() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean lengthEquals() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean lengthGreaterThan() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean lengthLessThan() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean regex() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean isValidTimeCode() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean startsWith() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean endsWith() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean greaterThanToday() throws EvaluatorException {
        return this.greaterThan();
    }

    @Override
    public boolean lessThanToday() throws EvaluatorException {
        return this.lessThan();
    }

    @Override
    public boolean containsUnparsable() {
        if (this.fieldLhs == null) {
            return false;
        }
        return this.fieldLhs.getParsable() == false;
    }

    @Override
    public boolean doesNotContain() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean tierEquals(int tier) throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean timeEquals() throws EvaluatorException {
        Integer secsLhs = this.getTimeLhs();
        Integer secsRhs = this.getTimeRhs();
        if (secsLhs == null || secsRhs == null) {
            return false;
        }
        return secsLhs.equals(secsRhs);
    }

    @Override
    public boolean timeGreaterThan() throws IllegalOperationException, EvaluatorException {
        Integer secsLhs = this.getTimeLhs();
        Integer secsRhs = this.getTimeRhs();
        if (secsLhs == null || secsRhs == null) {
            return false;
        }
        return secsLhs.compareTo(secsRhs) > 0;
    }

    @Override
    public boolean timeLessThan() throws IllegalOperationException, EvaluatorException {
        Integer secsLhs = this.getTimeLhs();
        Integer secsRhs = this.getTimeRhs();
        if (secsLhs == null || secsRhs == null) {
            return false;
        }
        return secsLhs.compareTo(secsRhs) < 0;
    }

    private Integer getTimeLhs() {
        if (this.fieldLhs != null && this.fieldLhs.getParsable().booleanValue()) {
            return TimeHelper.getTimeFromDate((Date)this.fieldLhs.getTypedValue());
        }
        return null;
    }

    private Integer getTimeRhs() throws EvaluatorException {
        if (this.predicate instanceof PredicateRightValue) {
            String strTime = (String)((PredicateRightValue)this.predicate).getValue().get(0);
            return TimeHelper.getTimeSeconds(strTime);
        }
        if (this.predicate instanceof PredicateRightField) {
            if (this.fieldRhs.getParsable().booleanValue()) {
                return TimeHelper.getTimeFromDate((Date)this.fieldRhs.getTypedValue());
            }
            return null;
        }
        throw new EvaluatorException("get time rhs for predicate type: " + this.predicate.getClass().getName());
    }

    @Override
    public boolean equalToToday() throws IllegalOperationException, EvaluatorException {
        Date fieldDate = this.getDateLhs();
        if (fieldDate == null) {
            return false;
        }
        Date currDate = this.getRelativeDate("0");
        return fieldDate.equals(currDate);
    }

    @Override
    public boolean validateCategory() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean listContains() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean doesNotListContain() throws IllegalOperationException {
        throw new IllegalOperationException();
    }
}

