/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.engine;

import com.ericsson.cms.criteria.LogicalOperator;
import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightField;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.tandbergtv.marvin.engine.DeterminatingFactory;
import com.tandbergtv.marvin.engine.EvaluatorException;
import com.tandbergtv.marvin.engine.IDeterminating;
import com.tandbergtv.marvin.engine.IllegalOperationException;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.IField;
import org.apache.log4j.Logger;

public class Determinator {
    private static final Logger logger = Logger.getLogger(Determinator.class);

    public static boolean determine(Predicate predicate, IField fieldLhs) throws EvaluatorException, IllegalOperationException {
        IDeterminating determinating = DeterminatingFactory.getDeterminating(predicate, fieldLhs);
        boolean evalationResult = Determinator.determineHelper(predicate, determinating);
        String fieldLhsValue = fieldLhs == null ? "NULL" : fieldLhs.getValue();
        logger.trace((Object)(Determinator.getPredicateLoggingInfo(predicate) + "FieldLhs=\"" + fieldLhsValue + " == " + evalationResult));
        return evalationResult;
    }

    public static boolean determine(Predicate predicate, IField fieldLhs, IField fieldRhs) throws EvaluatorException, IllegalOperationException {
        IDeterminating determinating = DeterminatingFactory.getDeterminating(predicate, fieldLhs, fieldRhs);
        boolean evalationResult = Determinator.determineHelper(predicate, determinating);
        String fieldLhsValue = fieldLhs == null ? "NULL" : fieldLhs.getValue();
        String fieldRhsValue = fieldRhs == null ? "NULL" : fieldRhs.getValue();
        logger.trace((Object)(Determinator.getPredicateLoggingInfo(predicate) + "FieldLhs=\"" + fieldLhsValue + "\"FieldRhs=\"" + fieldRhsValue + "\" == " + evalationResult));
        return evalationResult;
    }

    public static boolean determine(Predicate predicate, Asset asset) throws IllegalOperationException, EvaluatorException {
        IDeterminating determinating = DeterminatingFactory.getDeterminating(predicate, asset);
        boolean evalationResult = Determinator.determineHelper(predicate, determinating);
        logger.trace((Object)(Determinator.getPredicateLoggingInfo(predicate) + " == " + evalationResult));
        return evalationResult;
    }

    public static boolean determine(Predicate predicate) throws IllegalOperationException, EvaluatorException {
        IDeterminating determinating = DeterminatingFactory.getDeterminating(predicate);
        boolean evalationResult = Determinator.determineHelper(predicate, determinating);
        logger.trace((Object)(predicate.getFieldLeft() + " " + predicate.getOperator() + "  == " + evalationResult));
        return evalationResult;
    }

    private static String getPredicateLoggingInfo(Predicate pred) {
        if (pred instanceof PredicateRightValue) {
            return pred.getFieldLeft() + " " + pred.getOperator() + ((PredicateRightValue)pred).getValue();
        }
        if (pred instanceof PredicateRightField) {
            return pred.getFieldLeft() + " " + pred.getOperator() + ((PredicateRightField)pred).getFieldRight();
        }
        return pred.getFieldLeft() + " " + pred.getOperator();
    }

    private static boolean determineHelper(Predicate predicate, IDeterminating determinating) throws IllegalOperationException, EvaluatorException {
        boolean result;
        LogicalOperator operator = predicate.getOperator();
        switch (operator) {
            case EQUAL: {
                result = determinating.equal();
                break;
            }
            case LESSTHAN: {
                result = determinating.lessThan();
                break;
            }
            case GREATERTHAN: {
                result = determinating.greaterThan();
                break;
            }
            case LESSTHANEQUAL: {
                result = determinating.lessThanEqual();
                break;
            }
            case GREATERTHANEQUAL: {
                result = determinating.greaterThanEqual();
                break;
            }
            case ISEMPTY: {
                result = determinating.isEmpty();
                break;
            }
            case ISNOTEMPTY: {
                result = determinating.isNotEmpty();
                break;
            }
            case NOTEQUAL: {
                result = determinating.notEqual();
                break;
            }
            case CONTAINS: {
                result = determinating.contains();
                break;
            }
            case DOESNOTCONTAIN: {
                result = determinating.doesNotContain();
                break;
            }
            case LISTCONTAINS: {
                result = determinating.listContains();
                break;
            }
            case DOESNOTLISTCONTAIN: {
                result = determinating.doesNotListContain();
                break;
            }
            case IN: {
                result = determinating.in();
                break;
            }
            case NOTIN: {
                result = determinating.notIn();
                break;
            }
            case LENGTHEQUALS: {
                result = determinating.lengthEquals();
                break;
            }
            case LENGTHLESSTHAN: {
                result = determinating.lengthLessThan();
                break;
            }
            case LENGTHGREATERTHAN: {
                result = determinating.lengthGreaterThan();
                break;
            }
            case REGEX: {
                result = determinating.regex();
                break;
            }
            case ISVALIDTIMECODE: {
                result = determinating.isValidTimeCode();
                break;
            }
            case STARTSWITH: {
                result = determinating.startsWith();
                break;
            }
            case ENDSWITH: {
                result = determinating.endsWith();
                break;
            }
            case GREATERTHANTODAY: {
                result = determinating.greaterThanToday();
                break;
            }
            case LESSTHANTODAY: {
                result = determinating.lessThanToday();
                break;
            }
            case EQUALTOTODAY: {
                result = determinating.equalToToday();
                break;
            }
            case CONTAINSUNPARSABLE: {
                result = determinating.containsUnparsable();
                break;
            }
            case TIER1EQUALS: {
                result = determinating.tierEquals(1);
                break;
            }
            case TIER2EQUALS: {
                result = determinating.tierEquals(2);
                break;
            }
            case TIER3EQUALS: {
                result = determinating.tierEquals(3);
                break;
            }
            case TIER4EQUALS: {
                result = determinating.tierEquals(4);
                break;
            }
            case TIMEEQUALS: {
                result = determinating.timeEquals();
                break;
            }
            case TIMELESSTHAN: {
                result = determinating.timeLessThan();
                break;
            }
            case TIMEGREATERTHAN: {
                result = determinating.timeGreaterThan();
                break;
            }
            default: {
                String msg = "cannot get determinator: " + operator;
                logger.error((Object)msg);
                throw new EvaluatorException(msg);
            }
        }
        if (predicate.getNot().booleanValue()) {
            result = !result;
        }
        return result;
    }
}

