/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.engine;

import com.tandbergtv.marvin.engine.MatchedItem;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.FieldBase;
import com.tandbergtv.metadatamanager.model.FieldTree;
import com.tandbergtv.metadatamanager.model.FieldTreeNode;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class EvaluatorResults {
    private static final Logger logger = Logger.getLogger(EvaluatorResults.class);
    private List<String> matchedItemKeys;
    private List<MatchedItem> matchedItems;
    private List<Field> matchedFields;
    private List<Asset> matchedAssets;
    private List<Asset> newAssets;
    private boolean passed;

    public EvaluatorResults() {
        this(false);
    }

    public EvaluatorResults(boolean passed) {
        this.passed = passed;
    }

    public List<MatchedItem> getMatchedItems() {
        return this.matchedItems;
    }

    public List<MatchedItem> getMatchedItems(String assetType, String rootxpath) {
        if (this.matchedItems == null) {
            return new ArrayList<MatchedItem>(0);
        }
        ArrayList<MatchedItem> result = new ArrayList<MatchedItem>();
        for (MatchedItem mi : this.matchedItems) {
            if (!mi.getAssetPath().equals(assetType) || !mi.getFieldTree().getRootElement().getName().equals(rootxpath)) continue;
            result.add(mi);
        }
        return result;
    }

    public void addMatchedItem(MatchedItem matchedItem) {
        if (this.matchedItems == null) {
            this.matchedItems = new ArrayList<MatchedItem>(5);
            this.matchedItemKeys = new ArrayList<String>(5);
        }
        if (matchedItem != null && !this.matchedItemsContainsValue(matchedItem)) {
            int hashCode = matchedItem.getAsset().hashCode();
            String name = matchedItem.getFieldTree().getRootElement().getName();
            List<Integer> indices = this.getBaseIndices(matchedItem.getFieldTree());
            this.matchedItems.add(matchedItem);
            this.matchedItemKeys.add(hashCode + FieldBase.buildTtvXPathWithIndices((String)name, indices));
        }
    }

    private boolean matchedItemsContainsValue(MatchedItem matchedItem) {
        for (MatchedItem mi : this.matchedItems) {
            FieldTreeNode rootElement = mi.getFieldTree().getRootElement();
            if (!rootElement.equals((Object)matchedItem.getFieldTree().getRootElement())) continue;
            Asset rootElementAsset = this.findAsset(rootElement);
            Asset matchedAsset = this.findAsset(matchedItem.getFieldTree().getRootElement());
            if (matchedAsset != rootElementAsset) continue;
            return true;
        }
        return false;
    }

    private Asset findAsset(FieldTreeNode node) {
        if (node.getField() != null) {
            return node.getField().getParentAsset();
        }
        for (FieldTreeNode child : node.getChildren()) {
            Asset childResult = this.findAsset(child);
            if (childResult == null) continue;
            return childResult;
        }
        return null;
    }

    public void setPassed(boolean passed) {
        this.passed = passed;
    }

    public boolean passed() {
        return this.passed;
    }

    public List<Asset> getMatchedAssets(String assetPath) {
        boolean onlyNew = false;
        if (assetPath.startsWith("NEW/")) {
            onlyNew = true;
            assetPath = assetPath.substring(4);
        }
        if (onlyNew && this.newAssets != null) {
            return this.getMatchedAssets(this.newAssets, assetPath);
        }
        if (this.matchedAssets != null) {
            return this.getMatchedAssets(this.matchedAssets, assetPath);
        }
        return new ArrayList<Asset>(0);
    }

    private List<Asset> getMatchedAssets(List<Asset> assets, String assetPath) {
        ArrayList<Asset> results = new ArrayList<Asset>();
        for (Asset a : assets) {
            if (a == null) {
                logger.warn((Object)("Asset is null. Looking for asset path: " + assetPath));
                continue;
            }
            if (a.getPath() == null) {
                logger.warn((Object)("Asset path is null. AssetType = " + a.getAssetType() + ". Looking for asset path: " + assetPath));
                continue;
            }
            if (!a.getPath().equals(assetPath)) continue;
            results.add(a);
        }
        return results;
    }

    public void addNewAsset(Asset newAsset) {
        if (this.newAssets == null) {
            this.newAssets = new ArrayList<Asset>();
        }
        this.newAssets.add(newAsset);
    }

    public void addMatchedAsset(Asset matchedAsset) {
        if (matchedAsset == null) {
            return;
        }
        if (this.matchedAssets == null) {
            this.matchedAssets = new ArrayList<Asset>(3);
        }
        for (Asset asset : this.matchedAssets) {
            if (asset != matchedAsset) continue;
            return;
        }
        this.matchedAssets.add(matchedAsset);
    }

    public void addMatchedField(Field field) {
        if (this.matchedFields == null) {
            this.matchedFields = new ArrayList<Field>(5);
        }
        for (Field f : this.matchedFields) {
            if (f != field) continue;
            return;
        }
        this.matchedFields.add(field);
    }

    public List<Field> getMatchedFields(String assetType, String xpath) {
        ArrayList<Field> results = new ArrayList<Field>(5);
        if (this.matchedFields == null) {
            return results;
        }
        for (Field field : this.matchedFields) {
            if (!field.getTtvXPath().equals(xpath) || !field.getParentAsset().getPath().equals(assetType)) continue;
            results.add(field);
        }
        return results;
    }

    public List<Field> getMatchedFields() {
        return this.matchedFields;
    }

    public void updateMatchedItems(Field field, List<String> fieldTokenizededPath) {
        if (this.matchedItemKeys == null) {
            return;
        }
        String key = field.getParentAsset().hashCode() + field.getTtvXPathWithIndices();
        for (int i = 0; i < this.matchedItemKeys.size(); ++i) {
            if (!(key = key + "/").startsWith(this.matchedItemKeys.get(i) + "/")) continue;
            FieldTreeNode node = (FieldTreeNode)this.matchedItems.get(i).getFieldTree().getRootElement().getChildren().get(0);
            this.addFieldToFieldTree(node, field, fieldTokenizededPath, 1);
        }
    }

    private boolean addFieldToFieldTree(FieldTreeNode node, Field field, List<String> fieldTokenizededPath, int fieldIndicePos) {
        boolean added = false;
        if (node.getName().equals(fieldTokenizededPath.get(fieldIndicePos)) && node.getCurrentIndex().equals(field.getIndices().get(fieldIndicePos))) {
            List children = node.getChildren();
            for (int i = 0; !added && i < children.size(); ++i) {
                added = this.addFieldToFieldTree((FieldTreeNode)children.get(i), field, fieldTokenizededPath, fieldIndicePos + 1);
            }
            if (!added) {
                added = true;
                FieldTreeNode newNode = this.buildFieldTreeNode(field, fieldTokenizededPath, fieldIndicePos + 1);
                node.addChild(newNode);
            }
        }
        return added;
    }

    private FieldTreeNode buildFieldTreeNode(Field field, List<String> tokenizedXpath, int currPos) {
        FieldTreeNode fieldTreeNode;
        FieldTreeNode root = null;
        FieldTreeNode curr = null;
        for (int i = currPos; i < tokenizedXpath.size() - 1; ++i) {
            fieldTreeNode = new FieldTreeNode();
            fieldTreeNode.setName(tokenizedXpath.get(i));
            fieldTreeNode.setCurrentIndex((Integer)field.getIndices().get(i));
            if (curr == null) {
                root = fieldTreeNode;
                curr = fieldTreeNode;
                continue;
            }
            curr.addChild(fieldTreeNode);
            curr = fieldTreeNode;
        }
        int finalPos = tokenizedXpath.size() - 1;
        fieldTreeNode = new FieldTreeNode();
        fieldTreeNode.setField(field);
        String name = tokenizedXpath.get(finalPos);
        if (name.startsWith("@")) {
            name = name.substring(1);
            fieldTreeNode.setAttribute(true);
        }
        fieldTreeNode.setName(tokenizedXpath.get(finalPos));
        if (finalPos < field.getIndices().size()) {
            fieldTreeNode.setCurrentIndex((Integer)field.getIndices().get(finalPos));
        } else {
            fieldTreeNode.setCurrentIndex(Integer.valueOf(1));
        }
        if (curr == null) {
            return fieldTreeNode;
        }
        curr.addChild(fieldTreeNode);
        return root;
    }

    private List<Integer> getBaseIndices(FieldTree tree) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        String name = tree.getRootElement().getName();
        StringTokenizer tokenizer = new StringTokenizer(name, "/");
        FieldTreeNode startingNode = (FieldTreeNode)tree.getRootElement().getChildren().get(0);
        int depth = tokenizer.countTokens();
        if (!startingNode.getName().equalsIgnoreCase("Fields")) {
            --depth;
            indices.add(1);
        }
        this.getBaseIndices(startingNode, indices, depth);
        return indices;
    }

    private void getBaseIndices(FieldTreeNode node, List<Integer> indices, int depth) {
        List children = node.getChildren();
        if (depth > 0) {
            indices.add(node.getCurrentIndex());
            if (children.size() == 1) {
                this.getBaseIndices(node, indices, --depth);
            }
        }
    }

    public void mergeResults(EvaluatorResults evalResult) {
        if (this.matchedFields == null && evalResult.matchedFields != null) {
            this.matchedFields = evalResult.matchedFields;
        } else if (evalResult.matchedFields != null) {
            for (Field mf : evalResult.matchedFields) {
                this.addMatchedField(mf);
            }
        }
        if (this.matchedItems == null && evalResult.matchedItems != null) {
            this.matchedItems = evalResult.matchedItems;
        } else if (evalResult.matchedItems != null) {
            for (MatchedItem mi : evalResult.matchedItems) {
                this.addMatchedItem(mi);
            }
        }
        if (this.matchedAssets == null && evalResult.matchedAssets != null) {
            this.matchedAssets = evalResult.matchedAssets;
        } else if (evalResult.matchedAssets != null) {
            for (Asset asset : evalResult.matchedAssets) {
                this.addMatchedAsset(asset);
            }
        }
    }
}

