/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.engine;

import com.ericsson.cms.neptune.cluster.Cluster;
import com.ericsson.cms.neptune.cluster.service.IClusterService;
import com.ericsson.cms.neptune.cluster.service.ITopicMessageListener;
import com.ericsson.neptune.clustermgmt.service.ClusterConstant;
import com.hazelcast.core.HazelcastInstance;
import com.tandbergtv.cms.rules.service.category.IPackageManager;
import com.tandbergtv.cms.rules.service.category.IRuleManagerCache;
import com.tandbergtv.cms.rules.service.category.TreRuleSetCachable;
import com.tandbergtv.marvin.engine.UpdateRulesCacheMessage;
import com.tandbergtv.marvin.udt.TrePackage;
import com.tandbergtv.marvin.udt.TreRuleSet;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.util.DistributedTopic;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.DependsOn;
import javax.ejb.Local;
import javax.ejb.Singleton;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;

@Singleton
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
@Local(value={IRuleManagerCache.class})
@DependsOn(value={"Neptune:service=com.tandbergtv.neptune.clustermgmt.service.IClusterConfigurationService"})
public class RuleManagerCache
implements IRuleManagerCache,
ITopicMessageListener<UpdateRulesCacheMessage> {
    private static final String DISTRIBUTED_RULES_TOPIC_NAME = "DistributedRulesTopic";
    private Map<String, List<TreRuleSetCachable>> rulesByPackage = new ConcurrentHashMap<String, List<TreRuleSetCachable>>();
    private Map<Integer, TreRuleSetCachable> rulesById = new ConcurrentHashMap<Integer, TreRuleSetCachable>();
    private Map<String, TreRuleSetCachable> rulesByUuid = new ConcurrentHashMap<String, TreRuleSetCachable>();
    private static final Logger logger = Logger.getLogger(RuleManagerCache.class);
    private TransactionManager transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
    private IPackageManager packageManager = (IPackageManager)InjectionUtil.injectInstance((String)"cms/PackageManagerImpl/local", IPackageManager.class);
    private DistributedTopic<UpdateRulesCacheMessage> distributedTitleTopic;
    private IClusterService hzcs;
    private HazelcastInstance haz;

    public RuleManagerCache() throws Exception {
        boolean isTransactionOwner;
        logger.info((Object)"Bringing up the RuleManagerCache.");
        this.hzcs = Cluster.getService((String)ClusterConstant.CLUSTER_CONFIG_PATH);
        this.haz = this.hzcs.getInstance();
        if (this.haz.getConfig() != null) {
            logger.info((Object)("RuleManagerCache is a part of cluster: " + this.haz.getConfig().getGroupConfig().getName()));
        }
        this.distributedTitleTopic = new DistributedTopic(DISTRIBUTED_RULES_TOPIC_NAME);
        ServiceRegistry.getDefault().register(this.distributedTitleTopic.getServiceName(), this.distributedTitleTopic);
        this.distributedTitleTopic.start();
        this.distributedTitleTopic.subscribe((ITopicMessageListener)this);
        boolean bl = isTransactionOwner = this.transactionManager.getTransaction() == null;
        if (!isTransactionOwner) {
            this.load();
        } else {
            this.transactionManager.begin();
            this.load();
            this.transactionManager.commit();
        }
        logger.info((Object)"RuleManagerCache loaded.");
    }

    public void onMessage(UpdateRulesCacheMessage msg) {
        logger.info((Object)("Got message rulesCache message from " + msg.getSender()));
        if (this.hzcs.isLocalMember(msg.getSender())) {
            logger.info((Object)("Skipping local message from " + msg.getSender()));
            return;
        }
        try {
            this.transactionManager.begin();
            if (msg.getTreRuleSet() != null) {
                this.updateCache(msg.getTreRuleSet(), msg.isDelete(), false);
            } else {
                TrePackage pack = this.packageManager.getPackageByNameFirstMatching(msg.getPackageToReload());
                this.loadCacheHelper(pack);
                msg.setPackageToReload(pack.getName());
            }
            this.transactionManager.commit();
        }
        catch (Exception e) {
            try {
                this.transactionManager.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            logger.error((Object)e);
        }
    }

    public void load() {
        this.rulesById = new ConcurrentHashMap<Integer, TreRuleSetCachable>();
        this.rulesByUuid = new ConcurrentHashMap<String, TreRuleSetCachable>();
        List packs = this.packageManager.getPackages();
        for (TrePackage p : packs) {
            this.loadCacheHelper(p);
        }
    }

    public void updateCache(TreRuleSet ruleSet, boolean isDelete) {
        this.updateCache(ruleSet, isDelete, true);
    }

    public synchronized Integer getPackageRuleSetCount(String packageName) {
        Integer currentCount = 0;
        try {
            this.packageManager.getPackageByNameFirstMatching(packageName).getRuleSets().size();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return currentCount;
    }

    private void reSyncOrder(String pkgName) {
        List<TreRuleSetCachable> ruleSets = this.getRuleSetsByPackage(pkgName);
        int ndx = 0;
        for (TreRuleSetCachable trsc : ruleSets) {
            if (trsc.getOrder() != ndx) {
                logger.debug((Object)("Cache: Changing order number of ruleset " + trsc.getRuleName() + " from " + trsc.getOrder() + " to " + ndx));
                trsc.setOrder(ndx);
                TreRuleSetCachable id_rs = this.rulesById.get(trsc.getRuleSetId());
                id_rs.setOrder(ndx);
                TreRuleSetCachable uuid_rs = this.rulesByUuid.get(trsc.getUuid());
                uuid_rs.setOrder(ndx);
            }
            ++ndx;
        }
    }

    private synchronized void updateCache(TreRuleSet ruleSet, boolean isDelete, boolean clusterSend) {
        TreRuleSetCachable rs = new TreRuleSetCachable(ruleSet);
        logger.debug((Object)("Updating cache for ruleset [" + ruleSet.getRuleName() + "] ClusterSend: " + clusterSend));
        List<TreRuleSetCachable> ruleSets = this.getRuleSetsByPackage(ruleSet.getTpackage().getName());
        if (this.rulesByPackage.get(ruleSet.getTpackage().getName()) == null) {
            this.rulesByPackage.put(ruleSet.getTpackage().getName(), new ArrayList());
        }
        int ndx = 0;
        boolean isNew = true;
        Iterator<TreRuleSetCachable> iterator = ruleSets.iterator();
        while (iterator.hasNext()) {
            TreRuleSetCachable trsc = iterator.next();
            if (trsc.getRuleSetId().equals(ruleSet.getRuleSetId())) {
                isNew = false;
                if (!isDelete) {
                    logger.debug((Object)("Replaced ruleset [" + trsc.getRuleName() + "]"));
                    ruleSets.set(ndx, rs);
                    break;
                }
                logger.debug((Object)("Removed ruleset [" + trsc.getRuleName() + "]"));
                iterator.remove();
            }
            ++ndx;
        }
        if (!isDelete && isNew) {
            logger.debug((Object)("Cache: Add new ruleset: " + rs.getRuleName() + " order number: " + rs.getOrder()));
            ruleSets.add(rs);
        }
        this.rulesByPackage.put(ruleSet.getTpackage().getName(), ruleSets);
        this.rulesById.remove(ruleSet.getRuleSetId());
        this.rulesByUuid.remove(ruleSet.getUuid().toString());
        if (!isDelete) {
            if (!this.rulesById.containsKey(ruleSet.getRuleSetId())) {
                this.rulesById.put(ruleSet.getRuleSetId(), rs);
                this.rulesByUuid.put(ruleSet.getUuid().toString(), rs);
            }
        } else {
            this.reSyncOrder(ruleSet.getTpackage().getName());
        }
        if (clusterSend) {
            UpdateRulesCacheMessage msg = new UpdateRulesCacheMessage();
            msg.setTreRuleSet(ruleSet);
            msg.setDelete(isDelete);
            msg.setPackageToReload(rs.getTpackage().getName());
            this.updateOtherNodes(msg);
        }
    }

    private void updateOtherNodes(final UpdateRulesCacheMessage msg) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                RuleManagerCache.this.distributedTitleTopic.publish((Object)msg);
            }
        };
        thread.start();
    }

    private synchronized void loadCacheHelper(TrePackage pack) {
        if (pack == null) {
            return;
        }
        ArrayList<TreRuleSetCachable> newPack = new ArrayList<TreRuleSetCachable>();
        if (pack.getRuleSets() != null) {
            for (TreRuleSet rs : pack.getRuleSets()) {
                if (rs == null) continue;
                TreRuleSetCachable rsc = new TreRuleSetCachable(rs);
                newPack.add(rsc);
                logger.debug((Object)("Adding RuleSet to Cache: " + rs.getRuleName() + " (" + rs.getRuleSetId() + ")"));
            }
        }
        this.rulesByPackage.put(pack.getName(), newPack);
        for (TreRuleSetCachable rsc : newPack) {
            this.rulesById.put(rsc.getRuleSetId(), rsc);
            this.rulesByUuid.put(rsc.getUuid(), rsc);
        }
    }

    public void loadCache(String packageName) {
        UpdateRulesCacheMessage msg = new UpdateRulesCacheMessage();
        boolean triedToCreateTransaction = false;
        try {
            if (this.transactionManager.getStatus() == 0) {
                TrePackage pack = this.packageManager.getPackageByNameFirstMatching(packageName);
                this.loadCacheHelper(pack);
                msg.setPackageToReload(pack.getName());
            } else {
                triedToCreateTransaction = true;
                this.transactionManager.begin();
                TrePackage pack = this.packageManager.getPackageByNameFirstMatching(packageName);
                this.loadCacheHelper(pack);
                msg.setPackageToReload(pack.getName());
                this.transactionManager.commit();
            }
            this.distributedTitleTopic.publish((Object)msg);
        }
        catch (Exception e) {
            if (triedToCreateTransaction) {
                try {
                    this.transactionManager.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new RuntimeException(e);
        }
    }

    public TreRuleSetCachable getRuleSet(Integer ruleSetId) {
        return this.rulesById.get(ruleSetId);
    }

    public TreRuleSetCachable getRuleSet(String uuid) {
        return this.rulesByUuid.get(uuid);
    }

    public Collection<TreRuleSetCachable> getRuleSets(Collection<Integer> ruleSetIds) {
        LinkedList<TreRuleSetCachable> result = new LinkedList<TreRuleSetCachable>();
        for (Integer id : ruleSetIds) {
            TreRuleSetCachable rs = this.rulesById.get(id);
            if (rs == null) continue;
            boolean inserted = false;
            for (int i = 0; !inserted && i < result.size(); ++i) {
                TreRuleSetCachable current = (TreRuleSetCachable)result.get(i);
                if (current.getOrder() <= rs.getOrder()) continue;
                result.add(i, rs);
                inserted = true;
            }
            if (inserted) continue;
            result.add(rs);
        }
        return result;
    }

    public List<TreRuleSetCachable> getRuleSetsByPackage(String packageName) {
        return this.rulesByPackage.get(packageName);
    }
}

