/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.engine;

import com.ericsson.cms.categorymgmt.exception.CategoryManagerException;
import com.ericsson.cms.categorymgmt.service.ICategoryManagerLocal;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.FieldTree;
import com.tandbergtv.metadatamanager.model.IField;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.entities.metadataconfig.Genre;
import com.tandbergtv.watchpoint.pmm.entities.metadataconfig.Product;
import com.tandbergtv.watchpoint.pmm.entities.metadataconfig.Rating;
import com.tandbergtv.watchpoint.pmm.entities.metadataconfig.Studio;
import com.tandbergtv.watchpoint.pmm.metadataconfig.IMetadataConfigurationReader;
import java.util.List;

public class StrictFieldValidator {
    private static final IMetadataConfigurationReader optionProvider = (IMetadataConfigurationReader)InjectionUtil.injectInstance((String)"cms/MetadataConfigReaderProxy/local", IMetadataConfigurationReader.class);
    private static final ICategoryManagerLocal categoryManager = (ICategoryManagerLocal)InjectionUtil.injectInstance((String)"cms/CategoryManager/local", ICategoryManagerLocal.class);
    private static final String RATING = "/Fields/Rating/RatingValues/RatingValue";
    private static final String RATING_VALUE = "/Fields/Rating/RatingValues/RatingValue/Value";
    private static final String RATING_SYSTEM = "/Fields/Rating/RatingValues/RatingValue/System";
    private static final String GENRE = "/Fields/Genres/Genre/Value";
    private static final String PRODUCT = "/Fields/ProductInfo/Name";
    private static final String STUDIO = "/Fields/CreationInfo/Studio";
    private static final String STUDIO_DISPLAY = "/Fields/CreationInfo/Studio/DisplayName";
    private static final String STUDIO_NAME = "/Fields/CreationInfo/Studio/Name";
    private static final String STUDIO_CODE = "/Fields/CreationInfo/Studio/Code";
    private static final String CATEGORY = "/Fields/Categories/Category/Text";

    public static boolean isInvalidFieldValue(IField field) {
        if (field == null) {
            return false;
        }
        String xpath = field.getTtvXPath();
        if (xpath.equals(RATING_VALUE)) {
            List ratings = optionProvider.getAllRatings(null, Boolean.valueOf(false));
            for (Rating rating : ratings) {
                if (!rating.getRating().equals(field.getValue())) continue;
                return false;
            }
        } else if (xpath.equals(RATING_SYSTEM)) {
            List ratings = optionProvider.getAllRatings(null, Boolean.valueOf(false));
            for (Rating rating : ratings) {
                if (!rating.getRatingSystem().equals(field.getValue())) continue;
                return false;
            }
        } else if (xpath.equals(GENRE)) {
            List genres = optionProvider.getAllGenre(null, Boolean.valueOf(false));
            for (Genre genre : genres) {
                if (!genre.getGenre().equals(field.getValue())) continue;
                return false;
            }
        } else if (xpath.equals(PRODUCT)) {
            List products = optionProvider.getAllProducts(null, Boolean.valueOf(false));
            for (Product product : products) {
                if (!product.getProductCode().equals(field.getValue())) continue;
                return false;
            }
        } else if (xpath.equals(STUDIO_DISPLAY)) {
            List studios = optionProvider.getAllStudios(null, Boolean.valueOf(false));
            for (Studio studio : studios) {
                if (!studio.getDisplayName().equals(field.getValue())) continue;
                return false;
            }
        } else if (xpath.equals(STUDIO_NAME)) {
            List studios = optionProvider.getAllStudios(null, Boolean.valueOf(false));
            for (Studio studio : studios) {
                if (!studio.getOrganizationName().equals(field.getValue())) continue;
                return false;
            }
        } else if (xpath.equals(STUDIO_CODE)) {
            List studios = optionProvider.getAllStudios(null, Boolean.valueOf(false));
            for (Studio studio : studios) {
                if (!studio.getOrganizationCode().equals(field.getValue())) continue;
                return false;
            }
        } else {
            if (xpath.equals(CATEGORY)) {
                try {
                    return !categoryManager.isCategoryExists(field.getValue());
                }
                catch (CategoryManagerException e) {
                    throw new RuntimeException(e);
                }
            }
            throw new RuntimeException("Unsupported Field: " + xpath);
        }
        return true;
    }

    public static boolean isInvalidFieldTreeValues(FieldTree tree) {
        if (tree == null) {
            return false;
        }
        if (tree.getRootElement().getName().equals(RATING)) {
            return StrictFieldValidator.validateRatingComplex(tree);
        }
        if (tree.getRootElement().getName().equals(STUDIO)) {
            return StrictFieldValidator.validateStudioComlex(tree);
        }
        List fields = tree.depthFirstTraversal();
        for (Field field : fields) {
            if (!field.getTtvXPath().equals(RATING_VALUE) && !field.getTtvXPath().equals(RATING_SYSTEM) && !field.getTtvXPath().equals(GENRE) && !field.getTtvXPath().equals(PRODUCT) && !field.getTtvXPath().equals(STUDIO_DISPLAY) && !field.getTtvXPath().equals(STUDIO_NAME) && !field.getTtvXPath().equals(STUDIO_CODE)) continue;
            return StrictFieldValidator.isInvalidFieldValue((IField)field);
        }
        throw new RuntimeException("unsupported field " + tree.getRootElement().getName());
    }

    private static boolean validateRatingComplex(FieldTree tree) {
        List fields = tree.depthFirstTraversal();
        List ratings = optionProvider.getAllRatings(null, Boolean.valueOf(false));
        Field ratingValue = null;
        Field ratingSystem = null;
        for (Field field : fields) {
            if (field.getTtvXPath().equals(RATING_VALUE)) {
                ratingValue = field;
                continue;
            }
            if (!field.getTtvXPath().equals(RATING_SYSTEM)) continue;
            ratingSystem = field;
        }
        if (ratingValue == null) {
            return StrictFieldValidator.isInvalidFieldValue(ratingValue);
        }
        if (ratingSystem == null) {
            return StrictFieldValidator.isInvalidFieldValue(ratingSystem);
        }
        for (Rating rating : ratings) {
            if (!rating.getRating().equals(ratingValue.getValue()) || !rating.getRatingSystem().equals(ratingSystem.getValue())) continue;
            return false;
        }
        return true;
    }

    private static boolean validateStudioComlex(FieldTree tree) {
        List fields = tree.depthFirstTraversal();
        List studios = optionProvider.getAllStudios(null, Boolean.valueOf(false));
        String code = "";
        String display = "";
        String name = "";
        for (Field field : fields) {
            if (field.getTtvXPath().equals(STUDIO_CODE)) {
                code = field.getValue();
                continue;
            }
            if (field.getTtvXPath().equals(STUDIO_DISPLAY)) {
                display = field.getValue();
                continue;
            }
            if (!field.getTtvXPath().equals(STUDIO_NAME)) continue;
            name = field.getValue();
        }
        for (Studio studio : studios) {
            String sDisplay = studio.getDisplayName();
            String sCode = studio.getOrganizationCode();
            String sName = studio.getOrganizationName();
            if (sCode == null || sCode.isEmpty()) {
                sCode = sName;
            }
            if (code.equals(sCode) && display.equals(sDisplay) && name.equals(sName)) {
                return false;
            }
            if (code.isEmpty() && display.equals(sDisplay) && name.equals(sName)) {
                return false;
            }
            if (code.isEmpty() && display.isEmpty() && name.equals(sName)) {
                return false;
            }
            if (code.equals(sCode) && display.isEmpty() && name.equals(sName)) {
                return false;
            }
            if (code.equals(sCode) && display.isEmpty() && name.isEmpty()) {
                return false;
            }
            if (code.equals(sCode) && display.equals(sDisplay) && name.isEmpty()) {
                return false;
            }
            if (!code.isEmpty() || !display.equals(sDisplay) || !name.isEmpty()) continue;
            return false;
        }
        return true;
    }
}

