/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.engine;

import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightField;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.tandbergtv.marvin.engine.EvaluatorException;
import com.tandbergtv.marvin.engine.IDeterminating;
import com.tandbergtv.marvin.engine.IllegalOperationException;
import com.tandbergtv.metadatamanager.model.IField;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class StringDeterminating
implements IDeterminating {
    private static final Logger logger = Logger.getLogger(StringDeterminating.class);
    private Predicate predicate;
    private IField fieldLhs;
    private IField fieldRhs;

    public StringDeterminating(Predicate predicate, IField fieldLhs, IField fieldRhs) {
        this.predicate = predicate;
        this.fieldLhs = fieldLhs;
        this.fieldRhs = fieldRhs;
    }

    private String getStringLhs() {
        if (this.fieldLhs == null) {
            return null;
        }
        if (this.predicate.getIgnoreCase()) {
            return this.fieldLhs.getValue().toUpperCase();
        }
        return this.fieldLhs.getValue();
    }

    private String getStringLhsRegex() {
        if (this.fieldLhs == null) {
            return null;
        }
        return this.fieldLhs.getValue();
    }

    private String getStringRhs() {
        String value = this.predicate instanceof PredicateRightField ? (this.fieldRhs != null ? this.fieldRhs.getValue() : null) : (String)((PredicateRightValue)this.predicate).getValue().get(0);
        if (value == null) {
            return null;
        }
        return this.predicate.getIgnoreCase() ? value.toUpperCase() : value;
    }

    private String getStringRhsRegex() {
        String value = this.predicate instanceof PredicateRightField ? (this.fieldRhs != null ? this.fieldRhs.getValue() : null) : (String)((PredicateRightValue)this.predicate).getValue().get(0);
        if (value == null) {
            return null;
        }
        return value;
    }

    private List<String> getStringRhsAsList() {
        PredicateRightValue rightPred = (PredicateRightValue)this.predicate;
        if (this.predicate.getIgnoreCase()) {
            ArrayList<String> result = new ArrayList<String>(rightPred.getValue().size());
            for (String value : rightPred.getValue()) {
                result.add(value.toUpperCase());
            }
            return result;
        }
        return rightPred.getValue();
    }

    @Override
    public boolean equal() {
        String lhs = this.getStringLhs();
        String rhs = this.getStringRhs();
        if (lhs == null && rhs == null) {
            return true;
        }
        return lhs != null && rhs != null && lhs.equals(rhs);
    }

    @Override
    public boolean greaterThan() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean in() {
        String lhs = this.getStringLhs();
        if (lhs != null) {
            for (String compVal : this.getStringRhsAsList()) {
                if (!lhs.equals(compVal)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean lessThan() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean contains() {
        String lhs = this.getStringLhs();
        String rhs = this.getStringRhs();
        return lhs != null && rhs != null && lhs.toUpperCase().contains(rhs.toUpperCase());
    }

    @Override
    public boolean listContains() {
        String lhs = this.getStringLhs();
        String rhs = this.getStringRhs();
        return lhs != null && rhs != null && lhs.toUpperCase().equals(rhs.toUpperCase());
    }

    @Override
    public boolean notEqual() {
        return !this.equal();
    }

    @Override
    public boolean notIn() {
        return !this.in();
    }

    @Override
    public boolean greaterThanEqual() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean isEmpty() {
        String lhs = this.getStringLhs();
        return lhs == null || this.getStringLhs().isEmpty();
    }

    @Override
    public boolean isNotEmpty() {
        String lhs = this.getStringLhs();
        return lhs != null && !this.getStringLhs().isEmpty();
    }

    @Override
    public boolean lessThanEqual() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean lengthEquals() throws IllegalOperationException {
        String lhs = this.getStringLhs();
        if (lhs == null) {
            return 0 == this.getComparisonLength();
        }
        return lhs != null && lhs.length() == this.getComparisonLength();
    }

    @Override
    public boolean lengthGreaterThan() throws IllegalOperationException {
        String lhs = this.getStringLhs();
        if (lhs == null) {
            return 0 > this.getComparisonLength();
        }
        return lhs != null && lhs.length() > this.getComparisonLength();
    }

    @Override
    public boolean lengthLessThan() throws IllegalOperationException {
        String lhs = this.getStringLhs();
        if (lhs == null) {
            return 0 < this.getComparisonLength();
        }
        return lhs.length() < this.getComparisonLength();
    }

    @Override
    public boolean regex() throws IllegalOperationException {
        String lhs = this.getStringLhsRegex();
        String regexStr = this.getStringRhsRegex();
        try {
            return lhs != null && lhs.matches(regexStr);
        }
        catch (Exception e) {
            logger.error((Object)("Error while checking regular expression: " + regexStr + "for value: " + lhs));
            return false;
        }
    }

    @Override
    public boolean isValidTimeCode() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    private int getComparisonLength() throws IllegalOperationException {
        String str = this.getStringRhs();
        try {
            long length = Long.parseLong(str);
            if (length > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            if (length < Integer.MIN_VALUE) {
                return Integer.MIN_VALUE;
            }
            return (int)length;
        }
        catch (NumberFormatException e) {
            throw new IllegalOperationException("Illegal Number! " + str);
        }
    }

    @Override
    public boolean startsWith() throws IllegalOperationException {
        String lhs = this.getStringLhs();
        String rhs = this.getStringRhs();
        return lhs != null && rhs != null && lhs.startsWith(rhs);
    }

    @Override
    public boolean endsWith() throws IllegalOperationException {
        String lhs = this.getStringLhs();
        String rhs = this.getStringRhs();
        return lhs != null && rhs != null && lhs.endsWith(rhs);
    }

    @Override
    public boolean greaterThanToday() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean lessThanToday() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean containsUnparsable() {
        if (this.fieldLhs == null) {
            return false;
        }
        return this.fieldLhs.getParsable() == false;
    }

    @Override
    public boolean doesNotContain() throws IllegalOperationException {
        return !this.contains();
    }

    @Override
    public boolean doesNotListContain() throws IllegalOperationException {
        return !this.listContains();
    }

    @Override
    public boolean tierEquals(int tier) throws IllegalOperationException {
        int currTier;
        String lhs = this.getStringLhs();
        String rhs = this.getStringRhs();
        if (this.isEmpty() || rhs == null) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(lhs, "/");
        for (currTier = 1; currTier < tier && tokenizer.hasMoreTokens(); ++currTier) {
            tokenizer.nextToken();
        }
        if (currTier == tier && tokenizer.hasMoreTokens()) {
            return tokenizer.nextToken().equals(rhs);
        }
        return false;
    }

    @Override
    public boolean timeEquals() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean timeGreaterThan() throws IllegalOperationException, EvaluatorException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean timeLessThan() throws IllegalOperationException, EvaluatorException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean equalToToday() throws IllegalOperationException, EvaluatorException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean validateCategory() throws IllegalOperationException {
        throw new IllegalOperationException();
    }
}

