/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.engine;

import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightField;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.tandbergtv.marvin.engine.EvaluatorException;
import com.tandbergtv.marvin.engine.IDeterminating;
import com.tandbergtv.marvin.engine.IllegalOperationException;
import com.tandbergtv.metadatamanager.model.IField;
import com.tandbergtv.metadatamanager.model.TimeCodeType;
import com.tandbergtv.metadatamanager.util.TimeCodeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TimeCodeDeterminating
implements IDeterminating {
    private static final Logger logger = Logger.getLogger(TimeCodeDeterminating.class);
    private Predicate predicate;
    private TimeCodeType lhs;
    private boolean parsable;
    private String unparsableLhs;
    private int frameRate;
    private IField fieldRhs;

    public TimeCodeDeterminating(Predicate predicate, IField fieldLhs, IField fieldRhs) {
        this.predicate = predicate;
        if (fieldLhs != null) {
            this.parsable = fieldLhs.getParsable();
            if (this.parsable) {
                this.lhs = (TimeCodeType)fieldLhs.getTypedValue();
            } else {
                this.unparsableLhs = fieldLhs.getValue();
            }
            if (fieldLhs.getParentAsset() != null) {
                Map frameRateMap = new HashMap();
                frameRateMap = fieldLhs.getParentAsset().getAssetIdMapWithFieldValueForXpath(Arrays.asList("MOVIE"), "/Fields/Content/FrameRate");
                try {
                    this.frameRate = Integer.valueOf((String)frameRateMap.get(fieldLhs.getParentAsset().getId()));
                }
                catch (NumberFormatException e) {
                    this.frameRate = 0;
                    logger.warn((Object)("Frame Rate is missing or unparsable." + e.getMessage()));
                }
            }
        } else {
            this.parsable = true;
        }
        this.fieldRhs = fieldRhs;
    }

    private boolean rhsContainsUnParasable() {
        return this.fieldRhs != null && this.fieldRhs.getParsable() == false;
    }

    private Float getNPTTimeCodeLhs() throws EvaluatorException {
        this.checkFrameRateMissing(this.lhs);
        if (this.lhs == null) {
            return null;
        }
        return Float.valueOf(this.lhs.getFloatValue(this.frameRate));
    }

    private Float getNPTTimeCodeRhs() throws EvaluatorException {
        if (this.predicate instanceof PredicateRightField && this.fieldRhs != null && this.fieldRhs.getParsable().booleanValue()) {
            return (Float)this.fieldRhs.getTypedValue();
        }
        if (this.predicate instanceof PredicateRightField) {
            return null;
        }
        if (this.lhs == null && this.unparsableLhs == null) {
            return null;
        }
        List<TimeCodeType> list = this.getRhsAsNPTTimeCodeList();
        if (list.size() == 1) {
            TimeCodeType tcType = list.get(0);
            this.checkFrameRateMissing(tcType);
            return Float.valueOf(tcType.getFloatValue(this.frameRate));
        }
        throw new EvaluatorException("Predicate with ID and operator " + this.predicate.getOperator().name() + " has a list as a RHS.");
    }

    private void checkFrameRateMissing(TimeCodeType tcType) throws EvaluatorException {
        if (tcType != null && !tcType.isNTP() && tcType.isSMTPE() && this.frameRate == 0) {
            throw new EvaluatorException("Frame Rate is missing in the asset with SMPTE timecode.");
        }
    }

    private String getRhsAsString() throws EvaluatorException {
        PredicateRightValue rightPredicate = (PredicateRightValue)this.predicate;
        if (rightPredicate.getValue().size() == 1) {
            return (String)rightPredicate.getValue().get(0);
        }
        throw new EvaluatorException("Predicate with ID and operator " + this.predicate.getOperator().name() + " has a list as a RHS.");
    }

    private List<TimeCodeType> getRhsAsNPTTimeCodeList() throws EvaluatorException {
        PredicateRightValue rightPredicate = (PredicateRightValue)this.predicate;
        if (rightPredicate.getValue().size() == 0) {
            throw new EvaluatorException("Predicate with ID and operator " + this.predicate.getOperator().name() + " is missing a RHS.");
        }
        try {
            ArrayList<TimeCodeType> ints = new ArrayList<TimeCodeType>();
            for (String predVal : rightPredicate.getValue()) {
                ints.add(new TimeCodeType(predVal));
            }
            return ints;
        }
        catch (NumberFormatException e) {
            throw new EvaluatorException("value must be a Float number", e);
        }
    }

    @Override
    public boolean equal() throws EvaluatorException {
        Float lhs = this.getNPTTimeCodeLhs();
        Float rhs = this.getNPTTimeCodeRhs();
        if (this.containsUnparsable() || this.rhsContainsUnParasable()) {
            return false;
        }
        if (lhs == null && rhs == null) {
            return true;
        }
        return lhs != null && rhs != null && lhs.equals(rhs);
    }

    @Override
    public boolean greaterThan() throws EvaluatorException {
        Float lhs = this.getNPTTimeCodeLhs();
        Float rhs = this.getNPTTimeCodeRhs();
        if (this.containsUnparsable() || this.rhsContainsUnParasable()) {
            return false;
        }
        return lhs != null && rhs != null && lhs.compareTo(rhs) > 0;
    }

    @Override
    public boolean greaterThanEqual() throws EvaluatorException {
        Float lhs = this.getNPTTimeCodeLhs();
        Float rhs = this.getNPTTimeCodeRhs();
        if (this.containsUnparsable() || this.rhsContainsUnParasable()) {
            return false;
        }
        return lhs != null && rhs != null && lhs.compareTo(rhs) >= 0;
    }

    @Override
    public boolean in() throws EvaluatorException {
        Float value = this.getNPTTimeCodeLhs();
        if (value == null) {
            return false;
        }
        for (TimeCodeType compVal : this.getRhsAsNPTTimeCodeList()) {
            this.checkFrameRateMissing(compVal);
            if (!value.equals(Float.valueOf(compVal.getFloatValue(this.frameRate)))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() throws IllegalOperationException {
        return this.lhs == null && this.parsable;
    }

    @Override
    public boolean isNotEmpty() throws IllegalOperationException {
        return !this.isEmpty();
    }

    @Override
    public boolean lessThan() throws EvaluatorException {
        Float lhs = this.getNPTTimeCodeLhs();
        Float rhs = this.getNPTTimeCodeRhs();
        if (this.containsUnparsable() || this.rhsContainsUnParasable()) {
            return false;
        }
        return lhs != null && rhs != null && lhs.compareTo(rhs) < 0;
    }

    @Override
    public boolean lessThanEqual() throws EvaluatorException {
        Float lhs = this.getNPTTimeCodeLhs();
        Float rhs = this.getNPTTimeCodeRhs();
        if (this.containsUnparsable() || this.rhsContainsUnParasable()) {
            return false;
        }
        return lhs != null && rhs != null && lhs.compareTo(rhs) <= 0;
    }

    @Override
    public boolean contains() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean notEqual() throws EvaluatorException {
        return !this.equal();
    }

    @Override
    public boolean notIn() throws IllegalOperationException, EvaluatorException {
        return !this.in();
    }

    @Override
    public boolean lengthEquals() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean lengthGreaterThan() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean lengthLessThan() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean regex() throws EvaluatorException {
        String value = this.unparsableLhs;
        String regexStr = this.getRhsAsString();
        if (this.parsable) {
            value = this.lhs == null ? null : this.lhs.toString();
        }
        try {
            return value != null && value.matches(regexStr);
        }
        catch (Exception e) {
            logger.error((Object)("Error while checking regular expression: " + regexStr + "for value: " + value));
            return false;
        }
    }

    @Override
    public boolean isValidTimeCode() throws EvaluatorException {
        if (this.lhs != null) {
            String value = this.lhs.toString();
            if (TimeCodeUtil.getInstance().isNPT(value)) {
                return true;
            }
            if (TimeCodeUtil.getInstance().isSMPTE(value)) {
                if (this.frameRate == 0) {
                    return false;
                }
                if (Integer.valueOf(value.split(":")[3]) >= this.frameRate) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean startsWith() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean endsWith() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean greaterThanToday() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean lessThanToday() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean containsUnparsable() {
        return !this.parsable;
    }

    @Override
    public boolean doesNotContain() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean tierEquals(int tier) throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean timeEquals() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean timeGreaterThan() throws IllegalOperationException, EvaluatorException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean timeLessThan() throws IllegalOperationException, EvaluatorException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean equalToToday() throws IllegalOperationException, EvaluatorException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean validateCategory() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean listContains() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean doesNotListContain() throws IllegalOperationException {
        throw new IllegalOperationException();
    }
}

