/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.engine;

import com.ericsson.cms.criteria.ExpList;
import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.criteria.ExpValue;
import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.LogicalOperator;
import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.ericsson.cms.criteria.SearchColumn;
import com.ericsson.cms.search.TitleSearchResult;
import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.extended_interface.IRulesLicensingField;
import com.ericsson.extended_interface.IRulesLicensingProvider;
import com.ericsson.extended_interface.impl.RulesLicenseWrapper;
import com.ericsson.extended_interface.impl.RulesLicensingField;
import com.ericsson.rules.fieldprovider.fieldvalue.FieldValue;
import com.ericsson.rules.fieldprovider.metadataenhancement.IMetadataEnhancementProvider;
import com.tandbergtv.cms.title.search.ITitleSearchService;
import com.tandbergtv.cms.titlefilter.CriteriaMode;
import com.tandbergtv.cms.titlefilter.TitleFilter;
import com.tandbergtv.marvin.engine.EvaluatorException;
import com.tandbergtv.marvin.engine.FieldValueDataTypeHelper;
import com.tandbergtv.marvin.engine.PoserField;
import com.tandbergtv.marvin.udt.TreAction;
import com.tandbergtv.marvin.udt.TreActionParameterValue;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.FieldTree;
import com.tandbergtv.metadatamanager.model.FieldTreeNode;
import com.tandbergtv.metadatamanager.model.Group;
import com.tandbergtv.metadatamanager.model.IField;
import com.tandbergtv.metadatamanager.util.DataTypeMappingReader;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class TitleExt {
    private static final Logger logger = Logger.getLogger(TitleExt.class);
    public static final String TITLE_ID = "id";
    public static final String TITLE_STATUS = "status";
    public static final String DISTRIBUTION_STATUS = "distributionStatus";
    public static final String DISTRIBUTION_DATE = "distributionDate";
    public static final String PROCESSING_STATUS = "processingStatus";
    public static final String CONTENT_CLASS = "contentClassId";
    private static final String SEASON_PATH = "Series/Season";
    public static final String CREATE_DATE = "createDate";
    public static final String RETIREMENT_DATE = "retirementDate";
    private static IRulesLicensingProvider licensingProvider;
    private static ITitleSearchService searchService;
    private static ISiteManager siteManager;
    private static IMetadataEnhancementProvider metdataEnhancementProvider;
    private static ITitleManager titleManagerService;
    private Title title;
    private Title series;
    private RulesLicenseWrapper license;
    private boolean checkedForLicense = false;
    private Set<String> matchablePaths;
    private long parentSeriesId;
    private long parentSeasonAssetId;
    private boolean loadedParentSeriesId = false;
    private String refId;

    public TitleExt(Title title, List<TreAction> actions, String refId) {
        this.refId = refId != null && !metdataEnhancementProvider.requestExists(refId) ? null : refId;
        this.title = title;
        this.setMatchablePaths(actions);
    }

    public Title getTitle() {
        return this.title;
    }

    public boolean hasRefId() {
        return this.refId != null && !this.refId.isEmpty();
    }

    private void setMatchablePaths(List<TreAction> actions) {
        this.matchablePaths = new HashSet<String>();
        for (TreAction action : actions) {
            String path;
            Boolean forMatchedLhs = false;
            Boolean forMatchedRhs = false;
            String sectionTypeLhs = "";
            String rootXpathLhs = null;
            String xpathLhs = "";
            String sectionTypeRhs = "";
            String rootXpathRhs = null;
            String xpathRhs = "";
            for (TreActionParameterValue param : action.getParams()) {
                if (param.getName().equals(ActionParams.forMatched.name())) {
                    forMatchedLhs = Boolean.parseBoolean(param.getValue());
                    continue;
                }
                if (param.getName().equals(ActionParams.sectionType.name())) {
                    sectionTypeLhs = param.getValue();
                    continue;
                }
                if (param.getName().equals(ActionParams.rootxpath.name())) {
                    rootXpathLhs = param.getValue() == null ? "" : param.getValue();
                    continue;
                }
                if (param.getName().equals(ActionParams.xpath.name())) {
                    xpathLhs = param.getValue() == null ? "" : param.getValue();
                    continue;
                }
                if (param.getName().equals(ActionParams.forMatchedRhs.name())) {
                    forMatchedRhs = Boolean.parseBoolean(param.getValue());
                    continue;
                }
                if (param.getName().equals(ActionParams.sectionTypeRhs.name())) {
                    sectionTypeRhs = param.getValue();
                    continue;
                }
                if (param.getName().equals(ActionParams.rootxpathRhs.name())) {
                    rootXpathRhs = param.getValue() == null ? "" : param.getValue();
                    continue;
                }
                if (!param.getName().equals(ActionParams.xpathRhs.name())) continue;
                xpathRhs = param.getValue() == null ? "" : param.getValue();
            }
            if (forMatchedLhs.booleanValue()) {
                path = sectionTypeLhs + (rootXpathLhs == null ? xpathLhs : rootXpathLhs);
                this.matchablePaths.add(path);
            }
            if (!forMatchedRhs.booleanValue()) continue;
            path = sectionTypeRhs + (rootXpathRhs.isEmpty() ? xpathRhs : rootXpathRhs);
            this.matchablePaths.add(path);
        }
    }

    public boolean isEvaluateAsset(FieldType type, String assetPath, String xpath) {
        return type.equals((Object)FieldType.ASSET) && xpath.isEmpty();
    }

    private boolean titleIsSeries() {
        return this.title.getAsset().getAssetType().equalsIgnoreCase("SERIES");
    }

    public List<Asset> getAsset(String path) {
        List<String> assetTypes = Arrays.asList(path.split("/"));
        if (path.startsWith("PACKAGE")) {
            return this.title.getAsset().getAllAssetsWithLineage(assetTypes);
        }
        Title series = this.getSeries();
        if (series == null) {
            return new ArrayList<Asset>(0);
        }
        Pattern pattern = Pattern.compile("Series/Season.*", 2);
        if (!this.titleIsSeries() && pattern.matcher(path).matches()) {
            Asset season = this.getSeasonAsset();
            if (season != null) {
                if (assetTypes.size() == 2) {
                    return Arrays.asList(season);
                }
                return season.getAllAssetsWithLineage(assetTypes.subList(1, assetTypes.size()));
            }
            return new ArrayList<Asset>(0);
        }
        return series.getAsset().getAllAssetsWithLineage(assetTypes);
    }

    private Asset getSeasonAsset() {
        Long seasonId = null;
        if (this.title.isCopy() && !this.loadedParentSeriesId) {
            this.loadCopySeriesSeason();
        }
        if ((seasonId = this.title.isCopy() ? Long.valueOf(this.parentSeasonAssetId) : ((Group)this.title.getAsset()).getSeasonAssetId()) == null) {
            return null;
        }
        return this.getSeries().getAsset().getAsset(seasonId.longValue());
    }

    public List<FieldTree> getFieldTrees(String assetPath, String xpath) {
        List<String> assetTypes = Arrays.asList(assetPath.split("/"));
        if (assetPath.startsWith("PACKAGE")) {
            return TitleExt.breakApartFieldTree(this.title.getAsset().getFieldTreeForXpath(assetTypes, xpath), xpath);
        }
        Title series = this.getSeries();
        if (series == null) {
            return new ArrayList<FieldTree>(0);
        }
        Pattern pattern = Pattern.compile("Series/Season.*", 2);
        if (!this.titleIsSeries() && pattern.matcher(assetPath).matches()) {
            Asset season = this.getSeasonAsset();
            if (season != null) {
                return season.getFieldTreeForXpath(assetTypes.subList(1, assetTypes.size()), xpath);
            }
            return new ArrayList<FieldTree>(0);
        }
        return series.getAsset().getFieldTreeForXpath(assetTypes, xpath);
    }

    public List<FieldTree> getFieldTreesWithEmptyValue(String assetPath, String xpath) {
        List<String> assetTypes = Arrays.asList(assetPath.split("/"));
        if (assetPath.startsWith("PACKAGE")) {
            return TitleExt.breakApartFieldTree(this.title.getAsset().getFieldTreeForXpathWithEmptyValue(assetTypes, xpath), xpath);
        }
        Title series = this.getSeries();
        if (series == null) {
            return new ArrayList<FieldTree>(0);
        }
        Pattern pattern = Pattern.compile("Series/Season.*", 2);
        if (!this.titleIsSeries() && pattern.matcher(assetPath).matches()) {
            Asset season = this.getSeasonAsset();
            if (season != null) {
                return season.getFieldTreeForXpathWithEmptyValue(assetTypes.subList(1, assetTypes.size()), xpath);
            }
            return new ArrayList<FieldTree>(0);
        }
        return series.getAsset().getFieldTreeForXpath(assetTypes, xpath);
    }

    public static List<FieldTree> getFieldTrees(Asset asset, List<String> assetTypes, String xpath) {
        return TitleExt.breakApartFieldTree(asset.getFieldTreeForXpath(assetTypes, xpath), xpath);
    }

    public static List<FieldTree> breakApartFieldTree(List<FieldTree> fieldTree, String xpath) {
        List<String> xpathTokens = Arrays.asList(xpath.split("/"));
        xpathTokens = xpathTokens.subList(1, xpathTokens.size());
        ArrayList<FieldTree> trees = new ArrayList<FieldTree>();
        for (FieldTree tree : fieldTree) {
            List<FieldTreeNode> newTreeNodes = TitleExt.breakApartFieldTreeHelper(tree.getRootElement().getChildren(), xpathTokens, 1);
            for (FieldTreeNode node : newTreeNodes) {
                FieldTree yeffedTree = new FieldTree();
                FieldTreeNode root = new FieldTreeNode();
                root.setName(tree.getRootElement().getName());
                root.addChild(node);
                yeffedTree.setRootElement(root);
                trees.add(yeffedTree);
            }
        }
        return trees;
    }

    private static List<FieldTreeNode> breakApartFieldTreeHelper(List<FieldTreeNode> nodes, List<String> xpathTokens, int pos) {
        ArrayList<FieldTreeNode> result = new ArrayList<FieldTreeNode>();
        for (FieldTreeNode node : nodes) {
            String xpathToken = xpathTokens.get(pos);
            if (node.isAttribute() && xpathToken.startsWith("@")) {
                xpathToken = xpathToken.substring(1);
            }
            if (node.getName().equals(xpathToken) && xpathTokens.size() > pos + 1) {
                List<FieldTreeNode> childNodes = TitleExt.breakApartFieldTreeHelper(node.getChildren(), xpathTokens, pos + 1);
                for (FieldTreeNode childNode : childNodes) {
                    FieldTreeNode brokenParent = new FieldTreeNode();
                    brokenParent.setAttribute(node.isAttribute());
                    brokenParent.setCurrentIndex(node.getCurrentIndex());
                    brokenParent.setField(node.getField());
                    brokenParent.setName(node.getName());
                    ArrayList<FieldTreeNode> newChildList = new ArrayList<FieldTreeNode>();
                    newChildList.add(childNode);
                    brokenParent.setChildren(newChildList);
                    result.add(brokenParent);
                }
                continue;
            }
            if (!node.getName().equals(xpathToken)) continue;
            result.add(node);
        }
        return result;
    }

    public List<? extends IField> getFields(FieldType fieldType, String assetPath, String xpath) throws EvaluatorException {
        if (fieldType.equals((Object)FieldType.ASSET)) {
            List<String> assetTypes = Arrays.asList(assetPath.split("/"));
            if (assetPath.startsWith("PACKAGE")) {
                return this.title.getAsset().getAllFieldsForXpath(assetTypes, xpath);
            }
            Title series = this.getSeries();
            if (series == null) {
                return new ArrayList(0);
            }
            Pattern pattern = Pattern.compile("Series/Season.*", 2);
            if (!this.titleIsSeries() && pattern.matcher(assetPath).matches()) {
                Asset season = this.getSeasonAsset();
                if (season != null) {
                    return season.getAllFieldsForXpath(assetTypes.subList(1, assetTypes.size()), xpath);
                }
                return new ArrayList(0);
            }
            return series.getAsset().getAllFieldsForXpath(assetTypes, xpath);
        }
        if (fieldType.equals((Object)FieldType.ENHANCEMENT)) {
            if (this.refId == null || this.refId.isEmpty()) {
                return new ArrayList(0);
            }
            Collection fields = metdataEnhancementProvider.getFieldValues(Long.valueOf(Long.parseLong(assetPath)), xpath, this.refId);
            ArrayList<PoserField> resultFields = new ArrayList<PoserField>();
            for (FieldValue field : fields) {
                resultFields.add(new PoserField(FieldValueDataTypeHelper.getDataType(field), field.getValue()));
            }
            return resultFields;
        }
        if (fieldType.equals((Object)FieldType.LICENSE)) {
            if (this.title.getId() == null) {
                return new ArrayList(0);
            }
            if (this.license == null && this.checkedForLicense) {
                return new ArrayList(0);
            }
            this.loadContract();
            if (this.license == null) {
                return new ArrayList(0);
            }
            List values = this.license.getFieldValue(xpath);
            String dataType = TitleExt.dataTypeLookup(fieldType, assetPath, xpath);
            ArrayList<PoserField> fields = new ArrayList<PoserField>();
            for (Object value : values) {
                if (!this.contractDataIsValid(value, xpath, dataType)) continue;
                fields.add(new PoserField(dataType, value));
            }
            return fields;
        }
        if (xpath.equalsIgnoreCase(TITLE_ID)) {
            return this.getPoserField("integer", this.title.getId());
        }
        if (xpath.equalsIgnoreCase(TITLE_STATUS)) {
            return this.getPoserField("string", this.title.getStatus().toString());
        }
        if (xpath.equalsIgnoreCase(CONTENT_CLASS)) {
            return this.getPoserField("integer", this.title.getContentClassId());
        }
        if (xpath.equalsIgnoreCase(DISTRIBUTION_STATUS)) {
            return this.getPoserField("string", this.title.getDistributionStatus().toString());
        }
        if (xpath.equalsIgnoreCase(DISTRIBUTION_DATE)) {
            return this.getPoserField("date", this.title.getDistributionDate());
        }
        if (xpath.equalsIgnoreCase(CREATE_DATE)) {
            return this.getPoserField("date", this.title.getCreateDate());
        }
        if (xpath.equalsIgnoreCase(RETIREMENT_DATE)) {
            return this.getPoserField("date", this.title.getRetirementDate());
        }
        if (xpath.equalsIgnoreCase(PROCESSING_STATUS)) {
            return this.getPoserField("string", this.title.getProcessingStatus().toString());
        }
        throw new EvaluatorException("Encountered unsupported field in determinator. Field = " + xpath);
    }

    private void loadContract() {
        if (this.license == null && this.title.isCopy()) {
            Integer siteId = siteManager.getDistributionSiteId(this.title.getId());
            this.license = licensingProvider.getLicense(this.title.getOriginalId().longValue(), (long)siteId.intValue());
        } else if (this.license == null) {
            this.license = licensingProvider.getLicense(this.title.getId().longValue());
        }
        this.checkedForLicense = true;
    }

    private boolean contractDataIsValid(Object value, String xpath, String dataType) {
        if (value == null) {
            logger.error((Object)"Expected value but recieved null");
            return false;
        }
        if (dataType.equals("string") && !(value instanceof String)) {
            logger.error((Object)("Expected string but recieved" + value.getClass().getCanonicalName()));
            return false;
        }
        if (dataType.equals("date") && !(value instanceof Date)) {
            logger.error((Object)("Expected Date but recieved" + value.getClass().getCanonicalName()));
            return false;
        }
        if (dataType.equals("integer") && !(value instanceof Long)) {
            logger.error((Object)("Expected Integer but recieved" + value.getClass().getCanonicalName()));
            return false;
        }
        if (dataType.equals("float") && !(value instanceof Float)) {
            logger.error((Object)("Expected Float but recieved" + value.getClass().getCanonicalName()));
            return false;
        }
        if (dataType.equals("time") && !(value instanceof String)) {
            logger.error((Object)("Expected Time but recieved" + value.getClass().getCanonicalName()));
            return false;
        }
        if (dataType.equals("time") && !value.toString().matches("\\d\\d:\\d\\d:\\d\\d")) {
            logger.error((Object)("Expected Time in format hh:mm:ss but recieved" + value.toString()));
            return false;
        }
        return true;
    }

    private List<IField> getPoserField(String dataType, Object value) {
        return Arrays.asList(new PoserField(dataType, value));
    }

    public boolean requiresMatched(FieldType fieldType, String assetPath, String xpath) {
        if (fieldType.equals((Object)FieldType.ASSET)) {
            return this.requiresMatched(assetPath, xpath);
        }
        return false;
    }

    public boolean requiresMatched(String assetPath, String xpath) {
        return this.matchablePaths.contains(assetPath + xpath);
    }

    public static String dataTypeLookup(FieldType type, String assetPath, String xpath) {
        if (type.equals((Object)FieldType.ASSET)) {
            DataTypeMappingReader dtr = DataTypeMappingReader.getInstance();
            return dtr.determineDataType(xpath);
        }
        if (type.equals((Object)FieldType.PMM_TITLE)) {
            if (xpath.equalsIgnoreCase(TITLE_ID)) {
                return "integer";
            }
            if (xpath.equalsIgnoreCase(TITLE_STATUS)) {
                return "string";
            }
            if (xpath.equalsIgnoreCase(CONTENT_CLASS)) {
                return "integer";
            }
            if (xpath.equalsIgnoreCase(DISTRIBUTION_STATUS)) {
                return "string";
            }
            if (xpath.equalsIgnoreCase(DISTRIBUTION_DATE)) {
                return "date";
            }
            if (xpath.equalsIgnoreCase(CREATE_DATE)) {
                return "date";
            }
            if (xpath.equalsIgnoreCase(RETIREMENT_DATE)) {
                return "date";
            }
            if (xpath.equalsIgnoreCase(PROCESSING_STATUS)) {
                return "string";
            }
        } else if (type.equals((Object)FieldType.LICENSE)) {
            for (RulesLicensingField field : licensingProvider.getFields()) {
                if (!field.getFieldIdentifier().equals(xpath)) continue;
                IRulesLicensingField.DataType dataType = field.getFieldDataType();
                if (dataType.equals((Object)IRulesLicensingField.DataType.LONG)) {
                    return "integer";
                }
                return dataType.toString().toLowerCase();
            }
        }
        return null;
    }

    private void loadCopySeriesSeason() {
        PredicateRightValue predicate = new PredicateRightValue(TITLE_ID, null, FieldType.PMM_TITLE, Arrays.asList(String.valueOf(this.title.getOriginalId())), LogicalOperator.EQUAL, Boolean.valueOf(false));
        ExpValue condition = new ExpValue((Predicate)predicate);
        ExpList rootNode = new ExpList();
        rootNode.addItem((ExpNode)condition);
        TitleFilter filter = new TitleFilter((ExpNode)rootNode);
        ArrayList<SearchColumn> searchColumns = new ArrayList<SearchColumn>(1);
        searchColumns.add(new SearchColumn(null, "seriesDocumentId", FieldType.PMM_TITLE, "integer", false));
        searchColumns.add(new SearchColumn(null, "seasonAssetId", FieldType.PMM_TITLE, "integer", false));
        TitleSearchResult result = searchService.getSearchResults(filter, null, searchColumns);
        List seriesDocIds = result.getRows();
        if (seriesDocIds.size() == 1) {
            String seriesIdStr = ((TitleSearchResult.SearchRow)seriesDocIds.get(0)).getFirstValueAsString(0);
            String seasonIdStr = ((TitleSearchResult.SearchRow)seriesDocIds.get(0)).getFirstValueAsString(1);
            if (!seriesIdStr.isEmpty()) {
                this.parentSeriesId = Long.parseLong(seriesIdStr);
            }
            if (!seasonIdStr.isEmpty()) {
                this.parentSeasonAssetId = Long.parseLong(seasonIdStr);
            }
        }
        this.loadedParentSeriesId = true;
    }

    public Title getSeries() {
        if (this.title.getAsset().getAssetType().equalsIgnoreCase("SERIES")) {
            return this.title;
        }
        if (this.series == null) {
            Long seriesDocumentId = null;
            if (this.title.isCopy() && !this.loadedParentSeriesId) {
                this.loadCopySeriesSeason();
            }
            if ((seriesDocumentId = this.title.isCopy() ? Long.valueOf(this.parentSeriesId) : ((Group)this.title.getAsset()).getSeriesDocumentId()) == null || seriesDocumentId < 1L) {
                return null;
            }
            PredicateRightValue predicate = new PredicateRightValue("documentId", null, FieldType.PMM_TITLE, Arrays.asList(String.valueOf(seriesDocumentId)), LogicalOperator.EQUAL, Boolean.valueOf(false));
            ExpValue condition = new ExpValue((Predicate)predicate);
            ExpList rootNode = new ExpList();
            rootNode.addItem((ExpNode)condition);
            TitleFilter filter = new TitleFilter((ExpNode)rootNode);
            filter.setCriteriaMode(CriteriaMode.SERIES);
            TitleSearchResult result = searchService.getSearchResults(filter, null, null);
            List rows = result.getRows();
            long titleId = -1L;
            if (rows.size() > 0) {
                titleId = ((TitleSearchResult.SearchRow)rows.get(0)).getId();
            }
            this.series = titleManagerService.get(Long.valueOf(titleId));
        }
        return this.series;
    }

    public CriteriaMode getTitleCriteriaMode() {
        if (this.title.getAsset().getAssetType().equalsIgnoreCase("SERIES")) {
            return CriteriaMode.SERIES;
        }
        return CriteriaMode.MASTER;
    }

    public boolean fieldCanBeThere(FieldType fieldType, String sectionType, String xpath) {
        switch (fieldType) {
            case ENHANCEMENT: {
                return this.refId != null;
            }
            case LICENSE: {
                this.loadContract();
                return this.license != null;
            }
            case PMM_TITLE: {
                return true;
            }
            case ASSET: {
                if (sectionType.startsWith("SERIES/SEASON") && this.title.getAsset().getPath().equals("PACKAGE")) {
                    Asset season = this.getSeasonAsset();
                    if (sectionType.equals("SERIES/SEASON")) {
                        return season != null;
                    }
                    String subSectionType = sectionType.substring("SERIES/".length());
                    List<String> subSectionTypeList = Arrays.asList(subSectionType.split("/"));
                    return season != null && season.getAllAssetsWithLineage(subSectionTypeList).size() > 0;
                }
                if (sectionType.startsWith("SERIES")) {
                    Title series = this.getSeries();
                    return series != null && series.getAsset().getAllAssetsWithLineage(Arrays.asList(sectionType.split("/"))).size() > 0;
                }
                if (!sectionType.startsWith("PACKAGE")) break;
                return this.title.getAsset().getAllAssetsWithLineage(Arrays.asList(sectionType.split("/"))).size() > 0;
            }
        }
        return false;
    }

    static {
        try {
            licensingProvider = (IRulesLicensingProvider)InjectionUtil.injectInstance((String)"cms/RulesLicensingProvider/local", IRulesLicensingProvider.class);
        }
        catch (Exception e) {
            logger.error((Object)"could not initialize licensing provider", (Throwable)e);
        }
        try {
            searchService = (ITitleSearchService)InjectionUtil.injectInstance((String)"cms/TitleSearchServiceProxy/local", ITitleSearchService.class);
        }
        catch (Exception e) {
            logger.error((Object)"could not initialize search service", (Throwable)e);
        }
        try {
            siteManager = (ISiteManager)InjectionUtil.injectInstance((String)"cms/SiteManager/local", ISiteManager.class);
        }
        catch (Exception e) {
            logger.error((Object)"could not initialize site Manager", (Throwable)e);
        }
        try {
            metdataEnhancementProvider = (IMetadataEnhancementProvider)InjectionUtil.injectInstance((String)"cms/MEManager/local", IMetadataEnhancementProvider.class);
        }
        catch (Exception e) {
            logger.error((Object)"could not initialize metadataEnhancementProvider", (Throwable)e);
        }
        try {
            titleManagerService = (ITitleManager)InjectionUtil.injectInstance((String)"cms/TitleManagerProxy/local", ITitleManager.class);
        }
        catch (Exception e) {
            logger.error((Object)"could not initialize TitleManager", (Throwable)e);
        }
    }

    public static enum ActionParams {
        sectionType,
        rootxpath,
        xpath,
        forMatched,
        xpathRhs,
        rootxpathRhs,
        sectionTypeRhs,
        forMatchedRhs;

    }
}

