/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.event;

import com.ericsson.cms.criteria.ret.RetTree;
import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.cms.sites.core.entities.DistributionSite;
import com.ericsson.cms.sites.core.entities.Site;
import com.tandbergtv.cms.rules.service.category.IRuleExecutionHandler;
import com.tandbergtv.cms.rules.service.category.IRuleManager;
import com.tandbergtv.cms.rules.service.category.IRuleManagerCache;
import com.tandbergtv.cms.rules.service.category.RuleExecutionException;
import com.tandbergtv.cms.rules.service.category.TreRuleSetCachable;
import com.tandbergtv.cms.titlefilter.TitleFilter;
import com.tandbergtv.marvin.engine.Evaluator;
import com.tandbergtv.marvin.engine.TitleExt;
import com.tandbergtv.marvin.udt.RuleResults;
import com.tandbergtv.marvin.udt.TreAction;
import com.tandbergtv.marvin.udt.TreEvent;
import com.tandbergtv.marvin.udt.TrePackage;
import com.tandbergtv.marvin.udt.TreRule;
import com.tandbergtv.marvin.udt.TreRuleSet;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.Stateless;
import org.apache.log4j.Logger;

@Stateless
public class EventHandler
implements IRuleExecutionHandler {
    private static final Logger logger = Logger.getLogger(EventHandler.class);
    private IRuleManager ruleManager;
    private ISiteManager siteManager;
    private IRuleManagerCache ruleCache;

    public EventHandler() {
        try {
            this.ruleManager = (IRuleManager)InjectionUtil.injectInstance((String)"cms/RuleManagerImpl/local", IRuleManager.class);
            this.ruleCache = (IRuleManagerCache)InjectionUtil.injectInstance((String)"cms/RuleManagerCache/local", IRuleManagerCache.class);
        }
        catch (Exception e) {
            this.siteManager = null;
            logger.error((Object)"Could locate rule manager service within rules component.", (Throwable)e);
        }
        try {
            this.siteManager = (ISiteManager)InjectionUtil.injectInstance((String)"cms/SiteManager/local", ISiteManager.class);
        }
        catch (Exception e) {
            this.siteManager = null;
            logger.error((Object)"Could locate site service within rules component.", (Throwable)e);
        }
    }

    public EventHandler(IRuleManager ruleManager, ISiteManager siteManager, IRuleManagerCache ruleCache) {
        this.ruleManager = ruleManager;
        this.siteManager = siteManager;
        this.ruleCache = ruleCache;
    }

    public RuleResults runRuler(Title title, TreEvent event) {
        logger.debug((Object)("Running rules for event: " + (event == null ? "null" : event.name())));
        TrePackage tp = new TrePackage();
        tp.setName("PROCESSING");
        return this.runRuler(title, event, tp);
    }

    public RuleResults runRuler(Title title, List<Integer> ruleSetIds) {
        logger.debug((Object)("Running rule sets: " + (ruleSetIds == null ? "null" : ruleSetIds)));
        Collection ruleSets = this.ruleCache.getRuleSets(ruleSetIds);
        DistributionSite s = this.siteLookup(title);
        return this.runRulerHelper(title, ruleSets, null, s, null);
    }

    public void testNormalization(Title title) {
        this.runRuler(title, new TrePackage("NORMALIZATION"));
    }

    public void testNormalization(Title title, String refId) {
        String packName = "NORMALIZATION";
        DistributionSite s = this.siteLookup(title);
        List setOfRuleSets = this.ruleCache.getRuleSetsByPackage(packName);
        this.runRulerHelper(title, setOfRuleSets, refId, s, null);
    }

    public void testNormalization(Title title, Integer ruleSetId) {
        this.testNormalization(title, ruleSetId, null, null);
    }

    public void testNormalization(Title title, Integer ruleSetId, String refId) {
        this.testNormalization(title, ruleSetId, null, refId);
    }

    public void testNormalizationTargeting(Title title, Integer siteId) {
        this.testNormalizationTargeting(title, siteId, null);
    }

    public void testNormalizationTargeting(Title title, Integer siteId, String refId) {
        List ruleSets = this.ruleManager.getRuleSetBySitePackageEvent(siteId, "NORMALIZATION", TreEvent.TARGETED);
        RuleResults results = new RuleResults(title);
        Evaluator e = new Evaluator();
        for (TreRuleSet rs : ruleSets) {
            try {
                RetTree filterTree;
                TitleExt titleExt = this.buildTitleExt(rs.getRules(), title, refId);
                TitleFilter filter = rs.getFilter();
                RetTree retTree = filterTree = filter.getRootNode() != null ? filter.getRootNode().getAsOptimizedTree() : new RetTree();
                if (siteId == null) {
                    throw new IllegalArgumentException("You must provide a siteId");
                }
                if (!rs.getEnabled().booleanValue() || !e.evaluateTitleFilter(rs.getRuleSetId(), filterTree, titleExt, filter.getCriteriaMode())) continue;
                Site site = this.siteManager.getSite(siteId.intValue());
                ArrayList<Integer> siteIds = new ArrayList<Integer>();
                for (Site s : rs.getSites()) {
                    siteIds.add(s.getId());
                }
                if (!this.siteValidForRule(site, siteIds)) continue;
                e.evaluateRules(rs.getRuleSetId(), rs.getRuleName(), rs.getRules(), titleExt, results);
            }
            catch (Exception ex) {
                RuleExecutionException ex1 = new RuleExecutionException("An error occured while try to run RuleSet: " + rs.getRuleSetId(), (Throwable)ex);
                throw ex1;
            }
        }
    }

    public void testNormalization(Title title, Integer ruleSetId, Integer siteId) {
        this.testNormalization(title, ruleSetId, siteId, null);
    }

    public void testNormalization(Title title, Integer ruleSetId, Integer siteId, String refId) {
        logger.debug((Object)("Running rule sets: " + (ruleSetId == null ? "null" : ruleSetId)));
        TreRuleSetCachable rs = this.ruleCache.getRuleSet(ruleSetId);
        if (rs == null) {
            throw new IllegalArgumentException("The ruleSet id you provided is not valid. RuleSetId = " + ruleSetId);
        }
        this.testNormalization(title, rs, siteId, refId);
    }

    private void testNormalization(Title title, TreRuleSetCachable rs, Integer siteId, String refId) {
        TrePackage trePackage = rs.getTpackage();
        if (!"NORMALIZATION".equalsIgnoreCase(trePackage.getName())) {
            throw new IllegalArgumentException("The ruleSet you provided is not a normalization rule set. It is a " + trePackage.getName());
        }
        RuleResults results = new RuleResults(title);
        Evaluator e = new Evaluator();
        try {
            TitleExt titleExt = this.buildTitleExt(rs.getRules(), title, refId);
            if (e.evaluateTitleFilter(rs.getRuleSetId(), rs.getFilter(), titleExt, rs.getCriteriaMode())) {
                Site s = null;
                if (siteId != null) {
                    s = this.siteManager.getSite(siteId.intValue());
                }
                if (s == null && rs.isGlobal() || s != null && this.siteValidForRule(s, rs.getSites())) {
                    e.evaluateRules(rs.getRuleSetId(), rs.getRuleName(), rs.getRules(), titleExt, results);
                }
            }
        }
        catch (Exception ex) {
            RuleExecutionException ex1 = new RuleExecutionException("An error occured while try to run RuleSet: " + rs.getRuleSetId(), (Throwable)ex);
            throw ex1;
        }
    }

    public RuleResults runRuler(Title title, TrePackage tpackage) {
        long t0 = System.currentTimeMillis();
        String packName = tpackage.getName();
        DistributionSite s = this.siteLookup(title);
        List setOfRuleSets = this.ruleCache.getRuleSetsByPackage(packName);
        RuleResults rs = this.runRulerHelper(title, setOfRuleSets, null, s, null);
        long t1 = System.currentTimeMillis();
        if (tpackage.getName().equalsIgnoreCase("VALIDATION")) {
            Map ruleSetEmailNotificationMap = rs.getRuleSetEmailNotifyMap();
            for (TreRuleSetCachable tre : setOfRuleSets) {
                TreRuleSet ruleSet = tre.getRuleSet();
                ruleSetEmailNotificationMap.put(ruleSet.getRuleSetId(), ruleSet.getIsEmailNotify());
            }
        }
        logger.debug((Object)("********** runRuler = " + (t1 - t0) + " ms type=" + (tpackage == null ? "null" : tpackage.getName()) + " titleID = " + title.getId() + " originalTitleId = " + title.getOriginalId()));
        return rs;
    }

    public RuleResults runRuler(Title title, TreEvent event, TrePackage tpackage) {
        long t0 = System.currentTimeMillis();
        String packageName = tpackage.getName();
        DistributionSite s = this.siteLookup(title);
        List setOfRuleSets = this.ruleCache.getRuleSetsByPackage(packageName);
        RuleResults rs = this.runRulerHelper(title, setOfRuleSets, null, s, event);
        long t1 = System.currentTimeMillis();
        logger.debug((Object)("********** runRuler = " + (t1 - t0) + " ms type=" + (tpackage == null ? "null" : tpackage.getName()) + " titleID = " + title.getId() + " originalTitleId = " + title.getOriginalId()));
        return rs;
    }

    public RuleResults runNationalizeRuler(Title title) {
        TrePackage tp = new TrePackage();
        tp.setName("NORMALIZATION");
        return this.runRuler(title, tp);
    }

    public RuleResults runNationalizeRuler(Title title, TreEvent event) {
        TrePackage tp = new TrePackage();
        tp.setName("NORMALIZATION");
        return this.runRuler(title, event, tp);
    }

    public RuleResults runNormalizeRule(Title title, TreEvent event, String refId) {
        long t0 = System.currentTimeMillis();
        String packageName = "NORMALIZATION";
        DistributionSite s = this.siteLookup(title);
        long t1 = System.currentTimeMillis();
        logger.debug((Object)("********** runNormalizeRuleSiteLookup = " + (t1 - t0) + " ms titleID = " + title.getId() + " originalTitleId = " + title.getOriginalId()));
        List setOfRuleSets = this.ruleCache.getRuleSetsByPackage(packageName);
        long t2 = System.currentTimeMillis();
        logger.debug((Object)("********** runNormalizeRuleGetRuleSets = " + (t2 - t1) + " ms titleID = " + title.getId() + " originalTitleId = " + title.getOriginalId()));
        RuleResults rs = this.runRulerHelper(title, setOfRuleSets, refId, s, event);
        long t3 = System.currentTimeMillis();
        logger.debug((Object)("********** runNormalizeRuleRunRulerHelper = " + (t3 - t2) + " ms titleID = " + title.getId() + " originalTitleId = " + title.getOriginalId()));
        logger.debug((Object)("********** runNormalizeRuleTotal = " + (t3 - t0) + " ms titleID = " + title.getId() + " originalTitleId = " + title.getOriginalId()));
        return rs;
    }

    public RuleResults runProcessContentRuler(Title title) {
        TrePackage tp = new TrePackage();
        tp.setName("PROCESSING");
        return this.runRuler(title, tp);
    }

    public RuleResults runValidateRuler(Title title) {
        TrePackage tp = new TrePackage();
        tp.setName("VALIDATION");
        return this.runRuler(title, tp);
    }

    public RuleResults runTargetingRuler(Title title) {
        TrePackage tp = new TrePackage();
        tp.setName("TARGETING");
        return this.runRuler(title, tp);
    }

    public RuleResults runPrioritizationRuler(Title title) {
        TrePackage tp = new TrePackage();
        tp.setName("PRIORITIZATION");
        return this.runRuler(title, tp);
    }

    public Set<Integer> getTargetedSites(Title title) {
        RuleResults ruleResults = this.runTargetingRuler(title);
        return ruleResults.getSiteIds();
    }

    public RuleResults runRuler(Title title, Collection<TreRuleSet> ruleSet) {
        ArrayList<TreRuleSetCachable> cachableRuleSets = new ArrayList<TreRuleSetCachable>();
        DistributionSite s = this.siteLookup(title);
        for (TreRuleSet rs : ruleSet) {
            cachableRuleSets.add(new TreRuleSetCachable(rs));
        }
        return this.runRulerHelper(title, cachableRuleSets, null, s, null);
    }

    private RuleResults runRulerHelper(Title title, Collection<TreRuleSetCachable> ruleSet, String refId, DistributionSite site, TreEvent restrictRulesToEvent) {
        RuleResults results = new RuleResults(title);
        Evaluator e = new Evaluator();
        for (TreRuleSetCachable rs : ruleSet) {
            try {
                if (rs.getTpackage().getName().equals("MSOOVERRIDE")) {
                    throw new RuntimeException("This api doesn't support MSO Override rules.  Please use runMsoOverrideRuler.");
                }
                if (!rs.isEnabled() || restrictRulesToEvent != null && !rs.getEvents().contains(restrictRulesToEvent)) continue;
                this.logRuleSetStart(rs, title);
                TrePackage trePackage = rs.getTpackage();
                results.addRuleTypeRun(trePackage);
                long t0 = System.currentTimeMillis();
                TitleExt titleExt = this.buildTitleExt(rs.getRules(), title, refId);
                long t1 = System.currentTimeMillis();
                logger.debug((Object)("********** buildTitleExt = " + (t1 - t0) + " ms RuleName = " + rs.getRuleName() + " titleID = " + title.getId() + " originalTitleId = " + title.getOriginalId()));
                if (e.evaluateTitleFilter(rs.getRuleSetId(), rs.getFilter(), titleExt, rs.getCriteriaMode())) {
                    long t2 = System.currentTimeMillis();
                    logger.debug((Object)("********** evaluateTitleFilter = " + (t2 - t1) + " ms RuleName = " + rs.getRuleName() + " titleID = " + title.getId() + " originalTitleId = " + title.getOriginalId()));
                    if ("TARGETING".equalsIgnoreCase(trePackage.getName())) {
                        Set sites = rs.getSites();
                        results.getSiteIds().addAll(sites);
                    } else if (site == null && rs.isGlobal() || site != null && this.siteValidForRule((Site)site, rs.getSites())) {
                        e.evaluateRules(rs.getRuleSetId(), rs.getRuleName(), rs.getRules(), titleExt, results);
                        long t3 = System.currentTimeMillis();
                        logger.debug((Object)("********** evaluateRules = " + (t3 - t2) + " ms RuleName = " + rs.getRuleName() + " titleID = " + title.getId() + " originalTitleId = " + title.getOriginalId()));
                    }
                }
                this.logRuleSetEnd(rs, title);
            }
            catch (Exception ex) {
                RuleExecutionException ex1 = new RuleExecutionException("An error occured while try to run RuleSet: " + rs.getRuleSetId(), (Throwable)ex);
                throw ex1;
            }
        }
        return results;
    }

    private void logRuleSetStart(TreRuleSetCachable rs, Title title) {
        if (logger.isDebugEnabled()) {
            String titleIdStr = title.getId() != null ? title.getId().toString() : "NEW TITLE";
            logger.debug((Object)("Evaluating Rule Set Id: " + rs.getRuleSetId() + " Name = \"" + rs.getRuleName() + "\" Enabled: titleId = " + titleIdStr));
        }
    }

    private void logRuleSetEnd(TreRuleSetCachable rs, Title title) {
        if (logger.isDebugEnabled()) {
            String titleIdStr = title.getId() != null ? title.getId().toString() : "NEW TITLE";
            logger.debug((Object)("Finished Evaluating Rule Set Id: " + rs.getRuleSetId() + " Name = \"" + rs.getRuleName() + " titleId = " + titleIdStr));
        }
    }

    private TitleExt buildTitleExt(Collection<TreRule> rules, Title title, String refId) {
        ArrayList<TreAction> actions = new ArrayList<TreAction>();
        if (rules != null) {
            for (TreRule rule : rules) {
                actions.addAll(rule.getActions());
            }
        }
        return new TitleExt(title, actions, refId);
    }

    private boolean siteValidForRule(Site site, Collection<Integer> rsIds) {
        Integer logicalSiteId = -1;
        if (site instanceof DistributionSite && ((DistributionSite)site).getParent() != null) {
            logicalSiteId = ((DistributionSite)site).getParent().getId();
        }
        for (Integer id : rsIds) {
            if (!id.equals(logicalSiteId) && !id.equals(site.getId())) continue;
            return true;
        }
        return false;
    }

    private DistributionSite siteLookup(Title t) {
        if (this.siteManager != null && t.getId() != null) {
            return this.siteManager.getAssociatedDistributionSite(t.getId().longValue());
        }
        return null;
    }

    public RuleResults runMsoOverrideRuler(Title title, int msoId) {
        title = title.clone();
        List ruleSet = this.ruleCache.getRuleSetsByPackage("MSOOVERRIDE");
        RuleResults results = new RuleResults(title);
        Evaluator e = new Evaluator();
        for (TreRuleSetCachable rs : ruleSet) {
            try {
                if (!rs.isEnabled() || !rs.getMsos().contains(msoId)) continue;
                this.logRuleSetStart(rs, title);
                results.addRuleTypeRun(new TrePackage("MSOOVERRIDE"));
                TitleExt titleExt = this.buildTitleExt(rs.getRules(), title, null);
                if (e.evaluateTitleFilter(rs.getRuleSetId(), rs.getFilter(), titleExt, rs.getCriteriaMode())) {
                    e.evaluateRules(rs.getRuleSetId(), rs.getRuleName(), rs.getRules(), titleExt, results);
                }
                this.logRuleSetEnd(rs, title);
            }
            catch (Exception ex) {
                RuleExecutionException ex1 = new RuleExecutionException("An error occured while try to run RuleSet: " + rs.getRuleSetId(), (Throwable)ex);
                throw ex1;
            }
        }
        return results;
    }

    public RuleResults runMsoOverrideRulerTest(Title title, int ruleSetId) {
        TreRuleSetCachable rs = this.ruleCache.getRuleSet(Integer.valueOf(ruleSetId));
        RuleResults results = new RuleResults(title);
        Evaluator e = new Evaluator();
        try {
            this.logRuleSetStart(rs, title);
            results.addRuleTypeRun(new TrePackage("MSOOVERRIDE"));
            TitleExt titleExt = this.buildTitleExt(rs.getRules(), title, null);
            if (e.evaluateTitleFilter(rs.getRuleSetId(), rs.getFilter(), titleExt, rs.getCriteriaMode())) {
                e.evaluateRules(rs.getRuleSetId(), rs.getRuleName(), rs.getRules(), titleExt, results);
            }
            this.logRuleSetEnd(rs, title);
        }
        catch (Exception ex) {
            RuleExecutionException ex1 = new RuleExecutionException("An error occured while try to run RuleSet: " + rs.getRuleSetId(), (Throwable)ex);
            throw ex1;
        }
        return results;
    }

    public void testNormalization(Title title, TreRuleSet treRuleSet, Integer siteId) {
        TreRuleSetCachable rs = new TreRuleSetCachable(treRuleSet);
        this.testNormalization(title, rs, siteId, null);
    }
}

