/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.event;

import com.ericsson.cms.sites.core.entities.DistributionSite;
import com.ericsson.cms.sites.core.entities.LogicalSite;
import com.ericsson.cms.sites.core.entities.Site;
import com.tandbergtv.cms.rules.service.category.EventHandlerCallback;
import com.tandbergtv.cms.rules.service.category.IEventHandlerJob;
import com.tandbergtv.cms.rules.service.category.IRuleExecutionHandler;
import com.tandbergtv.cms.rules.service.category.IRuleManager;
import com.tandbergtv.cms.rules.service.category.IRuleManagerCache;
import com.tandbergtv.cms.rules.service.category.TreRuleSetCachable;
import com.tandbergtv.cms.title.search.ITitleSearchService;
import com.tandbergtv.cms.title.search.entities.SiteType;
import com.tandbergtv.marvin.event.BulkActionInfo;
import com.tandbergtv.marvin.event.IBulkActionInfoDao;
import com.tandbergtv.marvin.event.RuleAsyncExecutionException;
import com.tandbergtv.marvin.udt.RuleResults;
import com.tandbergtv.marvin.udt.TreEvent;
import com.tandbergtv.marvin.udt.TreRuleSet;
import com.tandbergtv.metadatamanager.exception.SearchException;
import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.core.TitlePersistenceException;
import com.tandbergtv.watchpoint.pmm.entities.ITitleActionSource;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleActionSource;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.watchpoint.pmm.title.TitleActions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.jms.JMSException;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;

@Local
@Stateless
@TransactionManagement(value=TransactionManagementType.BEAN)
public class EventHandlerJob
implements IEventHandlerJob {
    private static final Logger logger = Logger.getLogger(EventHandlerJob.class);
    private static final int MAX_FAILURES_TOLERATED = 25;
    private static float STATUS_GRANULARITY = 0.1f;
    private static Date lastPurgeDate = EventHandlerJob.getOneHourAgo();
    private static final String SCHEDULER_PROPERTIES_GROUP_NAME = "com.ericsson.cms.scheduler";
    private static final String PROPERTY_NAME_DELAY_SENDING_REQUEST = "scheduler.createWorkOrders.throttling";
    private static final int DEFAULT_DELAY_SENDING_REQUEST = 1;

    public void runRules(List<Integer> ruleSetIds, List<Long> titleIds, String correlationId) throws Exception {
        IBulkActionInfoDao stateSaver = (IBulkActionInfoDao)InjectionUtil.injectInstance((String)"cms/BulkExecutionDao/local", IBulkActionInfoDao.class);
        ArrayList<Long> failedTitles = new ArrayList();
        ArrayList<Integer> contentProcessingRuleSets = new ArrayList<Integer>();
        ArrayList<Integer> otherRuleSets = new ArrayList<Integer>();
        this.getRulesets(ruleSetIds, contentProcessingRuleSets, otherRuleSets);
        BulkActionInfo previousState = stateSaver.getSavedState(correlationId);
        logger.info((Object)"EventHandlerJob: runRules");
        if (previousState.moveOn()) {
            logger.info((Object)"EventHandlerJob: moveOn");
        } else if (previousState.hasPreviousState()) {
            logger.info((Object)"EventHandlerJob: hasprevious");
            failedTitles = previousState.getFailedTitles();
            this.processCrashRecovery(null, correlationId, otherRuleSets, previousState);
        } else {
            logger.info((Object)"EventHandlerJob: runnormal");
            this.processNormal(null, correlationId, contentProcessingRuleSets, otherRuleSets, titleIds, failedTitles);
        }
        logger.info((Object)"Done!");
        this.purge();
    }

    public void runRulesAsync(final List<Integer> ruleSetIds, final List<Long> titleIds, final String correlationId, final EventHandlerCallback returnDestination) {
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                IBulkActionInfoDao stateSaver = (IBulkActionInfoDao)InjectionUtil.injectInstance((String)"cms/BulkExecutionDao/local", IBulkActionInfoDao.class);
                try {
                    List<Object> failedTitles = new ArrayList();
                    try {
                        ArrayList contentProcessingRuleSets = new ArrayList();
                        ArrayList otherRuleSets = new ArrayList();
                        EventHandlerJob.this.getRulesets(ruleSetIds, contentProcessingRuleSets, otherRuleSets);
                        BulkActionInfo previousState = stateSaver.getSavedState(correlationId);
                        if (previousState.moveOn()) {
                            logger.info((Object)"EventHandlerJob: moveOn");
                        } else if (previousState.hasPreviousState()) {
                            failedTitles = previousState.getFailedTitles();
                            EventHandlerJob.this.processCrashRecovery(returnDestination, correlationId, otherRuleSets, previousState);
                        } else {
                            EventHandlerJob.this.processNormal(returnDestination, correlationId, contentProcessingRuleSets, otherRuleSets, titleIds, failedTitles);
                        }
                        logger.info((Object)"Done!");
                        if (failedTitles.size() != 0) {
                            String failMessage = "FAIL: The following title(s) failed during rule engine execution: " + EventHandlerJob.this.getFailedTitlesString(failedTitles);
                            EventHandlerJob.this.reply(returnDestination, correlationId, false, failMessage, 0);
                        } else {
                            EventHandlerJob.this.reply(returnDestination, correlationId, true, "Done!", 100);
                        }
                    }
                    catch (RuleAsyncExecutionException e) {
                        EventHandlerJob.this.reply(returnDestination, correlationId, false, e.getMessage(), 0);
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    catch (Exception e) {
                        logger.error((Object)"Failed execution!", (Throwable)e);
                        EventHandlerJob.this.reply(returnDestination, correlationId, false, "FAIL", 0);
                    }
                    finally {
                        stateSaver.setFinishedSavedState(correlationId);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Failed execution!", (Throwable)e);
                }
                EventHandlerJob.this.purge();
            }
        };
        new Thread(r).start();
    }

    private static Date getOneHourAgo() {
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(new Date());
        cal.add(10, -1);
        return cal.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purge() {
        Date date = lastPurgeDate;
        synchronized (date) {
            if (lastPurgeDate.compareTo(EventHandlerJob.getOneHourAgo()) < 0) {
                IBulkActionInfoDao stateSaver = (IBulkActionInfoDao)InjectionUtil.injectInstance((String)"cms/BulkExecutionDao/local", IBulkActionInfoDao.class);
                stateSaver.purgeSavedState();
                lastPurgeDate = new Date();
            }
        }
    }

    private void processCrashRecovery(EventHandlerCallback returnDestination, String correlationId, List<Integer> otherRuleSets, BulkActionInfo previousState) throws Exception {
        int woDelayTime = EventHandlerJob.getWorkOrderDelayTimeInMilliSeconds();
        this.reply(returnDestination, correlationId, true, "Crash recovery: continuing proccessing rules for this request...", 1);
        Set<Map.Entry<Long, List<Integer>>> cpItems = previousState.getRuleSetSpecificItems().entrySet();
        List<Long> generalTitleIds = previousState.getGeneralProcessingTitleIds();
        List<List<Long>> splitTitles = this.splitTitleList(generalTitleIds);
        int complete = 0;
        for (List<Long> list : splitTitles) {
            int progress;
            if ((progress = (int)((float)complete++ * STATUS_GRANULARITY * 100.0f)) < 100 && progress > 0) {
                this.reply(returnDestination, correlationId, true, "processing ...", progress);
            }
            for (Long tId : list) {
                this.runNonCotentProcessingRules(tId, otherRuleSets, previousState.getFailedTitles(), correlationId);
            }
        }
        this.reply(returnDestination, correlationId, true, "processing content processing ...", 91);
        for (Map.Entry entry : cpItems) {
            Long titleId = (Long)entry.getKey();
            List ruleSetIds = (List)entry.getValue();
            if (woDelayTime != 0) {
                Thread.sleep(woDelayTime);
            }
            this.runCotentProcessingRules(titleId, ruleSetIds, previousState.getFailedTitles(), correlationId);
        }
    }

    private void processNormal(EventHandlerCallback returnDestination, String correlationId, List<Integer> contentProcessingRuleSets, List<Integer> otherRuleSets, List<Long> titleIds, List<Long> failedTitles) throws Exception {
        this.reply(returnDestination, correlationId, true, "Starting to proccess rules for this request...", 1);
        logger.info((Object)"Starting to proccess rules for this request...");
        int woDelayTime = EventHandlerJob.getWorkOrderDelayTimeInMilliSeconds();
        if (otherRuleSets.size() == 0 && contentProcessingRuleSets.size() == 0) {
            logger.info((Object)"No rule sets to run.");
            this.reply(returnDestination, correlationId, true, "No rule sets to run.", 100);
            return;
        }
        this.reply(returnDestination, correlationId, true, "Searching for titles...", 2);
        logger.info((Object)"Searching for titles...");
        ArrayList<Integer> ruleSets = new ArrayList<Integer>(contentProcessingRuleSets.size() + otherRuleSets.size());
        ruleSets.addAll(contentProcessingRuleSets);
        ruleSets.addAll(otherRuleSets);
        IRuleManager ruleManager = (IRuleManager)InjectionUtil.injectInstance((String)"cms/RuleManagerImpl/local", IRuleManager.class);
        TreRuleSet ruleSetObj = null;
        List ruleSetObjs = ruleManager.getRuleSets(ruleSets);
        if (ruleSetObjs.size() > 0) {
            ruleSetObj = (TreRuleSet)ruleSetObjs.get(0);
        }
        if (titleIds == null) {
            titleIds = new ArrayList<Long>(this.getTitlesUsingTitleFilter(ruleSets));
        }
        IBulkActionInfoDao stateSaver = (IBulkActionInfoDao)InjectionUtil.injectInstance((String)"cms/BulkExecutionDao/local", IBulkActionInfoDao.class);
        int totalItems = titleIds.size();
        int jobLimit = 0;
        if (ruleSetObj != null && totalItems > 0 && (jobLimit = ruleSetObj.getJobLimit()) != 0) {
            totalItems = totalItems > jobLimit ? jobLimit : totalItems;
            jobLimit = jobLimit > totalItems ? totalItems : jobLimit;
            ArrayList<Long> limitedTitleIds = new ArrayList<Long>();
            for (int i = 0; i < titleIds.size(); ++i) {
                logger.info((Object)("Adding: " + titleIds.get(i) + " of " + jobLimit));
                limitedTitleIds.add(titleIds.get(i));
                if (i >= jobLimit - 1) break;
            }
            titleIds = limitedTitleIds;
        }
        stateSaver.saveState(correlationId, titleIds, contentProcessingRuleSets, otherRuleSets.size() > 0);
        List<List<Long>> splitTitles = this.splitTitleList(titleIds);
        int complete = 0;
        logger.info((Object)("Processing " + (titleIds == null ? 0 : titleIds.size()) + " titles..."));
        int totalTitles = 0;
        block1: for (List<Long> subTitleIds : splitTitles) {
            int progress;
            if ((progress = (int)((float)complete++ * STATUS_GRANULARITY * 100.0f)) < 100 && progress > 0) {
                this.reply(returnDestination, correlationId, true, "processing...", progress);
            }
            for (Long tId : subTitleIds) {
                if (jobLimit != 0 && totalTitles >= jobLimit) break block1;
                logger.info((Object)("Title Id Process:  " + tId + " - " + otherRuleSets.size()));
                if (otherRuleSets.size() > 0) {
                    this.runNonCotentProcessingRules(tId, otherRuleSets, failedTitles, correlationId);
                }
                if (contentProcessingRuleSets.size() > 0) {
                    if (woDelayTime != 0) {
                        Thread.sleep(woDelayTime);
                    }
                    this.runCotentProcessingRules(tId, contentProcessingRuleSets, failedTitles, correlationId);
                }
                ++totalTitles;
            }
        }
    }

    private void runNonCotentProcessingRules(Long titleId, List<Integer> ruleSetIds, List<Long> failedTitles, String correlationId) throws Exception {
        TransactionManager tm = this.getCurrentTransaction();
        IBulkActionInfoDao stateSaver = (IBulkActionInfoDao)InjectionUtil.injectInstance((String)"cms/BulkExecutionDao/local", IBulkActionInfoDao.class);
        ITitleManager titleManager = (ITitleManager)InjectionUtil.injectInstance((String)"cms/TitleManagerProxy/local", ITitleManager.class);
        IRuleManagerCache ruleCache = (IRuleManagerCache)InjectionUtil.injectInstance((String)"cms/RuleManagerCache/local", IRuleManagerCache.class);
        IRuleExecutionHandler eventHandler = (IRuleExecutionHandler)InjectionUtil.injectInstance((String)"cms/EventHandler/local", IRuleExecutionHandler.class);
        try {
            ArrayList<Integer> cprsIds = new ArrayList<Integer>();
            tm.begin();
            Title title = titleManager.getForUpdate(titleId);
            RuleResults result = eventHandler.runRuler(title, ruleSetIds);
            if (result.isModified()) {
                ArrayList<TitleActions> actions = new ArrayList<TitleActions>();
                if (result.ranRuleType("NORMALIZATION")) {
                    actions.add(TitleActions.TITLE_NATIONALIZED_ACTION);
                }
                titleManager.save(title, (ITitleActionSource)new TitleActionSource("Rules", null, "sys"));
                List cprs = ruleCache.getRuleSetsByPackage("PROCESSING");
                for (TreRuleSetCachable rs : cprs) {
                    if (!rs.getEvents().contains(TreEvent.NORMALIZED)) continue;
                    cprsIds.add(rs.getRuleSetId());
                }
                stateSaver.saveState(correlationId, titleId, cprsIds);
            }
            stateSaver.deleteSavedStateGeneral(correlationId, titleId);
            tm.commit();
            this.runCotentProcessingRules(titleId, cprsIds, failedTitles, correlationId);
        }
        catch (TitlePersistenceException e) {
            this.tryRollback(tm);
            if (e.getCause() instanceof SearchException) {
                String errMsg = "There was a search exception. I hope it was because a title was deleted. Otherwise we might have done something bad.";
                logger.warn((Object)errMsg, (Throwable)e);
            } else {
                this.handleRunRulesException(titleId, correlationId, (Exception)((Object)e), failedTitles);
            }
        }
        catch (Exception ex) {
            this.tryRollback(tm);
            this.handleRunRulesException(titleId, correlationId, ex, failedTitles);
        }
    }

    private void runCotentProcessingRules(Long titleId, List<Integer> ruleSetIds, List<Long> failedTitles, String correlationId) throws Exception {
        TransactionManager tm = this.getCurrentTransaction();
        IBulkActionInfoDao stateSaver = (IBulkActionInfoDao)InjectionUtil.injectInstance((String)"cms/BulkExecutionDao/local", IBulkActionInfoDao.class);
        ITitleManager titleManager = (ITitleManager)InjectionUtil.injectInstance((String)"cms/TitleManagerProxy/local", ITitleManager.class);
        IRuleExecutionHandler eventHandler = (IRuleExecutionHandler)InjectionUtil.injectInstance((String)"cms/EventHandler/local", IRuleExecutionHandler.class);
        try {
            tm.begin();
            Title title = titleManager.get(titleId);
            for (Integer ruleSetId : ruleSetIds) {
                eventHandler.runRuler(title, Arrays.asList(ruleSetId));
                stateSaver.deleteSavedStateContentProcessing(correlationId, titleId, ruleSetId);
            }
            tm.commit();
        }
        catch (TitlePersistenceException e) {
            this.tryRollback(tm);
            if (e.getCause() instanceof SearchException) {
                String errMsg = "There was a search exception. I hope it was because a title was deleted. Otherwise we might have done something bad.";
                logger.warn((Object)errMsg, (Throwable)e);
            } else {
                this.handleRunRulesException(titleId, correlationId, (Exception)((Object)e), failedTitles);
            }
        }
        catch (Exception ex) {
            this.tryRollback(tm);
            this.handleRunRulesException(titleId, correlationId, ex, failedTitles);
        }
    }

    private void handleRunRulesException(Long titleId, String correlationId, Exception e, List<Long> failedTitles) throws RuleAsyncExecutionException {
        IBulkActionInfoDao stateSaver = (IBulkActionInfoDao)InjectionUtil.injectInstance((String)"cms/BulkExecutionDao/local", IBulkActionInfoDao.class);
        stateSaver.setTitleFailed(correlationId, titleId);
        failedTitles.add(titleId);
        if (failedTitles.size() >= 25) {
            String msg = "FAIL: Max failures tolerated reached. Failed titles: " + this.getFailedTitlesString(failedTitles);
            throw new RuleAsyncExecutionException(msg, e);
        }
        String msg = "Error while running rules. See stack trace for more info.";
        logger.error((Object)msg, (Throwable)e);
    }

    private String getFailedTitlesString(List<Long> failures) {
        StringBuffer result = new StringBuffer();
        for (Long id : failures) {
            if (result.length() > 0) {
                result.append(",");
            }
            result.append(id);
        }
        return result.toString();
    }

    private void reply(EventHandlerCallback callback, String correlationId, boolean success, String message, int percent) throws JMSException {
        if (callback != null) {
            callback.onMessage(correlationId, success, message, percent);
        }
    }

    private Set<Long> getTitlesUsingTitleFilter(Collection<Integer> ruleSetIds) throws Exception {
        logger.info((Object)"loading titles from database.");
        HashSet<Long> resultTitleIds = new HashSet<Long>();
        TransactionManager tm = this.getCurrentTransaction();
        IRuleManager ruleManager = (IRuleManager)InjectionUtil.injectInstance((String)"cms/RuleManagerImpl/local", IRuleManager.class);
        ITitleSearchService titleSearchService = (ITitleSearchService)InjectionUtil.injectInstance((String)"cms/TitleSearchServiceProxy/local", ITitleSearchService.class);
        try {
            tm.begin();
            List ruleSets = ruleManager.getRuleSets(ruleSetIds);
            for (TreRuleSet rs : ruleSets) {
                if (!rs.getEnabled().booleanValue()) continue;
                boolean runOnGlobal = rs.isRunOnGlobal();
                Set<Integer> sites = this.getSiteIds(rs.getSites());
                if (runOnGlobal && !sites.isEmpty()) {
                    resultTitleIds.addAll(titleSearchService.getMasterTitleIdsFromES(rs.getFilter().getRootNode()));
                    resultTitleIds.addAll(titleSearchService.getSiteTitleIdsfromES(rs.getFilter().getRootNode(), sites, SiteType.DISTRIBUTION_SITE));
                    continue;
                }
                if (runOnGlobal) {
                    resultTitleIds.addAll(titleSearchService.getMasterTitleIdsFromES(rs.getFilter().getRootNode()));
                    continue;
                }
                resultTitleIds.addAll(titleSearchService.getSiteTitleIdsfromES(rs.getFilter().getRootNode(), sites, SiteType.DISTRIBUTION_SITE));
            }
            logger.info((Object)"finished loading titles.");
            tm.commit();
        }
        catch (Exception e) {
            this.tryRollback(tm);
            throw e;
        }
        return resultTitleIds;
    }

    private Set<Integer> getSiteIds(Set<Site> sites) {
        HashSet<Integer> results = new HashSet<Integer>();
        if (sites == null) {
            return results;
        }
        this.addAllDistSiteIds(sites, results);
        return results;
    }

    private void addAllDistSiteIds(Collection<Site> sites, Set<Integer> siteIds) {
        for (Site site : sites) {
            if (site instanceof DistributionSite) {
                siteIds.add(site.getId());
                continue;
            }
            if (!(site instanceof LogicalSite)) continue;
            this.addAllDistSiteIds(((LogicalSite)site).getSiteChildren(), siteIds);
        }
    }

    private void tryRollback(TransactionManager tm) {
        try {
            tm.rollback();
        }
        catch (Exception ex) {
            logger.warn((Object)"Tried to rollback but was unable to do so.");
        }
    }

    private List<List<Long>> splitTitleList(List<Long> titles) {
        ArrayList<List<Long>> result = new ArrayList<List<Long>>();
        int total = titles.size();
        int m = 1;
        int start = 0;
        int end = 0;
        while (true) {
            start = end;
            end = (int)Math.floor((float)total * STATUS_GRANULARITY * (float)m);
            result.add(titles.subList(start, Math.min(end, total)));
            if (end >= total) break;
            ++m;
        }
        return result;
    }

    private void getRulesets(List<Integer> ruleSetIds, List<Integer> contentProcessingRuleSets, List<Integer> otherRuleSets) throws Exception {
        IRuleManagerCache ruleCache = (IRuleManagerCache)InjectionUtil.injectInstance((String)"cms/RuleManagerCache/local", IRuleManagerCache.class);
        Collection ruleSets = ruleCache.getRuleSets(ruleSetIds);
        for (TreRuleSetCachable rs : ruleSets) {
            if (rs.getTpackage().getName().equals("PROCESSING")) {
                contentProcessingRuleSets.add(rs.getRuleSetId());
                continue;
            }
            otherRuleSets.add(rs.getRuleSetId());
        }
    }

    private TransactionManager getCurrentTransaction() {
        TransactionManager transactionManager = null;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get current transaction manager", (Throwable)e);
        }
        return transactionManager;
    }

    public static int getWorkOrderDelayTimeInMilliSeconds() {
        IConfigurationService configService = (IConfigurationService)InjectionUtil.injectInstance((String)"cms/ConfigurationService/local", IConfigurationService.class);
        int delayTimeInSeconds = 1;
        try {
            delayTimeInSeconds = Integer.parseInt(((String)configService.getProperties(SCHEDULER_PROPERTIES_GROUP_NAME).get(PROPERTY_NAME_DELAY_SENDING_REQUEST)).trim());
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get workOrders Per Minute property. Using default value ", (Throwable)e);
        }
        return delayTimeInSeconds * 1000;
    }
}

