/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.services;

import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.criteria.ret.RetNode;
import com.ericsson.cms.criteria.ret.RetTree;
import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.cms.sites.core.entities.LogicalSite;
import com.ericsson.cms.sites.core.entities.Site;
import com.ericsson.rules.fieldprovider.metadataenhancement.IMetadataEnhancementField;
import com.ericsson.rules.fieldprovider.metadataenhancement.ISubscriptionProfile;
import com.ericsson.rules.fieldprovider.metadataenhancement.ISubscriptionProfileProvider;
import com.ericsson.rules.fieldprovider.metadataenhancement.RuleSetSubscriptionProfile;
import com.tandbergtv.cms.rules.service.category.RuleExecutionException;
import com.tandbergtv.cms.titlefilter.TitleFilter;
import com.tandbergtv.marvin.engine.Evaluator;
import com.tandbergtv.marvin.engine.EvaluatorResults;
import com.tandbergtv.marvin.engine.TitleExt;
import com.tandbergtv.marvin.udt.ShallowRuleSet;
import com.tandbergtv.marvin.udt.TreAction;
import com.tandbergtv.marvin.udt.TreActionParameterValue;
import com.tandbergtv.marvin.udt.TreEvent;
import com.tandbergtv.marvin.udt.TreRule;
import com.tandbergtv.marvin.udt.TreRuleSet;
import com.tandbergtv.marvin.udt.TreStandardRule;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

@Stateless
public class SubscriptionProfileProvider
implements ISubscriptionProfileProvider {
    @PersistenceContext(unitName="rulesds")
    private EntityManager entityManager;
    @EJB
    private ISiteManager siteManager;

    @TransactionAttribute
    public Collection<Long> getSubscriptionProfiles(Title title) {
        List<TreRuleSet> ruleSets = this.getRuleSets(null);
        return this.getSubscriptionProfilesHelper(ruleSets, title, null);
    }

    @TransactionAttribute
    public Collection<Long> getSubscriptionProfilesByRuleSet(Title title, Integer ruleSetId) {
        List<TreRuleSet> ruleSets = this.getRuleSets(ruleSetId);
        return this.getSubscriptionProfilesHelper(ruleSets, title, null);
    }

    private Collection<Long> getSubscriptionProfilesHelper(List<TreRuleSet> ruleSets, Title title, Integer siteId) {
        HashSet<Long> ids = new HashSet<Long>();
        Evaluator e = new Evaluator();
        for (TreRuleSet ruleSet : ruleSets) {
            TitleExt titleExt = this.buildTitleExt(ruleSet, title);
            try {
                TitleFilter filter = ruleSet.getFilter();
                RetTree filterTree = filter.getRootNode() != null ? filter.getRootNode().getAsOptimizedTree() : new RetTree();
                Site s = siteId != null ? this.siteManager.getSite(siteId.intValue()) : this.siteLookup(title);
                if ((s != null || !ruleSet.isRunOnGlobal()) && (s == null || !this.siteValidForRule(s, ruleSet.getSites())) || !e.evaluateTitleFilter(ruleSet.getRuleSetId(), filterTree, titleExt, filter.getCriteriaMode())) continue;
                for (TreRule rule : ruleSet.getRules()) {
                    EvaluatorResults evalResults;
                    Set<Long> idsFromRule = this.getIdsFromActions(rule);
                    if (idsFromRule.size() == 0) continue;
                    ExpNode expnode = ((TreStandardRule)rule).getConditions();
                    RetNode node = null;
                    if (expnode != null) {
                        RetTree tree = expnode.getAsOptimizedTree();
                        node = tree.getRoot();
                    }
                    if (!(evalResults = e.evaluateNode(node, titleExt)).passed()) continue;
                    ids.addAll(idsFromRule);
                }
            }
            catch (Exception ex) {
                RuleExecutionException ex1 = new RuleExecutionException("An error occured while try to run RuleSet: " + ruleSet.getRuleSetId(), (Throwable)ex);
                throw ex1;
            }
        }
        return ids;
    }

    private Site siteLookup(Title t) {
        if (this.siteManager != null && t.getId() != null) {
            return this.siteManager.getAssociatedDistributionSite(t.getId().longValue());
        }
        return null;
    }

    private boolean siteValidForRule(Site site, Collection<Site> rsSites) {
        for (Site rsSite : rsSites) {
            if (!rsSite.getId().equals(site.getId()) && (!(rsSite instanceof LogicalSite) || !this.siteValidForRule(site, rsSite.getSiteChildren()))) continue;
            return true;
        }
        return false;
    }

    private Set<Long> getIdsFromActions(TreRule rule) {
        HashSet<Long> idsFromRule = new HashSet<Long>();
        for (TreAction a : rule.getActions()) {
            String sectionType = "";
            boolean isMetaDataEnhancement = false;
            for (TreActionParameterValue param : a.getParams()) {
                if (param.getName().equals("fieldType")) {
                    isMetaDataEnhancement = param.getValue().equals("ENHANCEMENT");
                }
                if (!param.getName().equals("sectionType")) continue;
                sectionType = param.getValue();
            }
            if (!isMetaDataEnhancement) continue;
            idsFromRule.add(Long.parseLong(sectionType));
        }
        return idsFromRule;
    }

    private TitleExt buildTitleExt(TreRuleSet rs, Title title) {
        ArrayList<TreAction> actions = new ArrayList<TreAction>();
        if (rs.getRules() != null) {
            for (TreRule rule : rs.getRules()) {
                actions.addAll(rule.getActions());
            }
        }
        return new TitleExt(title, actions, null);
    }

    public List<TreRuleSet> getRuleSets(Integer ruleSetId) {
        StringBuffer queryString = new StringBuffer("SELECT tr FROM\t TrePackage p JOIN\t p.ruleSets tr JOIN  tr.rules r join  r.actions a join  a.params fieldType WHERE p.name = 'NORMALIZATION' and ");
        if (ruleSetId != null) {
            queryString.append("tr.ruleSetId = :ruleSetId ");
        } else {
            queryString.append("tr.enabled = true ");
        }
        queryString.append("and   fieldType.name = 'fieldType' and   fieldType.value = 'ENHANCEMENT' order by tr.order_");
        Query query = this.entityManager.createQuery(queryString.toString());
        if (ruleSetId != null) {
            query.setParameter("ruleSetId", (Object)ruleSetId);
        }
        List result = query.getResultList();
        return result;
    }

    @TransactionAttribute
    public Collection<RuleSetSubscriptionProfile> getAllRulesUsingThisProfile(Long subscriptionProfileId) {
        String queryString = "SELECT tr.ruleSetId, tr.ruleName, p.name, field.value  FROM\t TrePackage p JOIN\t p.ruleSets tr JOIN  tr.rules r join  r.actions a join  a.params fieldType join  a.params profile join  a.params field WHERE p.name = 'NORMALIZATION' and   fieldType.name = 'fieldType' and   fieldType.value = 'ENHANCEMENT' and   profile.name = 'sectionType' and   profile.value = :profileId and   field.name = 'xpath' group by tr.ruleSetId, tr.ruleName, p.name, field.value order by tr.ruleSetId";
        Query query = this.entityManager.createQuery(queryString);
        query.setParameter("profileId", (Object)subscriptionProfileId.toString());
        List queryResult = query.getResultList();
        ArrayList<RuleSetSubscriptionProfile> result = new ArrayList<RuleSetSubscriptionProfile>();
        RuleSetSubscriptionProfile currentRuleSet = null;
        for (Object[] row : queryResult) {
            int rsId = (Integer)row[0];
            String fieldIndentifier = row[3].toString();
            if (currentRuleSet != null && currentRuleSet.getRuleSetId() == rsId) {
                currentRuleSet.getFieldIdentifiers().add(fieldIndentifier);
                continue;
            }
            String ruleName = row[1].toString();
            String packageName = row[2].toString();
            ArrayList<String> fieldIdentifiers = new ArrayList<String>();
            fieldIdentifiers.add(fieldIndentifier);
            currentRuleSet = new RuleSetSubscriptionProfile(rsId, ruleName, packageName, subscriptionProfileId, fieldIdentifiers);
            result.add(currentRuleSet);
        }
        return result;
    }

    @TransactionAttribute
    public Collection<ShallowRuleSet> getAllRulesUsingThisProfile(ISubscriptionProfile subscriptionProfile) {
        String subscriptionProfileId = subscriptionProfile.getId().toString();
        ArrayList<String> fields = new ArrayList<String>();
        for (IMetadataEnhancementField field : subscriptionProfile.getFields()) {
            fields.add(field.getFieldIdentifier());
        }
        String queryString = "SELECT new com.tandbergtv.marvin.udt.ShallowRuleSet(tr.ruleSetId, tr.ruleName, p.name) FROM\t TrePackage p JOIN\t p.ruleSets tr JOIN  tr.rules r join  r.actions a join  a.params fieldType join  a.params profile join  a.params field WHERE p.name = 'NORMALIZATION' and   fieldType.name = 'fieldType' and   fieldType.value = 'ENHANCEMENT' and   profile.name = 'sectionType' and   profile.value = :profileId and   field.name = 'xpath' and   field.value in (:fields) group by tr.ruleSetId, tr.ruleName, p.name order by max(tr.order_)";
        Query query = this.entityManager.createQuery(queryString);
        query.setParameter("profileId", (Object)subscriptionProfileId);
        query.setParameter("fields", fields);
        List result = query.getResultList();
        return result;
    }

    @TransactionAttribute
    public Collection<Long> getSubscriptionProfiles(Title title, TreEvent event) {
        List<TreRuleSet> ruleSets = this.getRuleSetByEvent(event);
        return this.getSubscriptionProfilesHelper(ruleSets, title, null);
    }

    @TransactionAttribute
    public Collection<Long> getSubscriptionProfilesBySite(Title title, Integer siteId) {
        List<TreRuleSet> ruleSets = this.getRuleSetByEvent(TreEvent.TARGETED);
        return this.getSubscriptionProfilesHelper(ruleSets, title, siteId);
    }

    public List<TreRuleSet> getRuleSetByEvent(TreEvent event) {
        String queryStr = "SELECT tr FROM\t TrePackage p JOIN\t p.ruleSets tr JOIN\t tr.eventsHibernate e JOIN  tr.rules r join  r.actions a join  a.params fieldType WHERE p.name = 'NORMALIZATION' and   e.name = :eventName and   tr.enabled = true and   fieldType.name = 'fieldType' and   fieldType.value = 'ENHANCEMENT' order by tr.order_";
        Query query = this.entityManager.createQuery(queryStr);
        query.setParameter("eventName", (Object)event.name());
        List ruleSets = query.getResultList();
        return ruleSets;
    }
}

