/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduler;

import com.ericsson.cms.scheduler.IRecoveryService;
import com.ericsson.cms.scheduler.entities.PastExecution;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.hibernate.Session;

public class RecoveryService
implements IRecoveryService {
    private boolean recovering;
    private long pastExecutionId;

    public RecoveryService(boolean recovering, long pastExecutionId) {
        this.recovering = recovering;
        this.pastExecutionId = pastExecutionId;
    }

    public boolean isRecovering() {
        return this.recovering;
    }

    public Serializable get(String name) throws ClassNotFoundException {
        PastExecution pe = (PastExecution)this.getSession().get(PastExecution.class, (Serializable)Long.valueOf(this.pastExecutionId));
        return this.convert(pe.getValue(name));
    }

    public void save(String name, Serializable value) throws InvalidClassException, NotSerializableException {
        PastExecution pe = (PastExecution)this.getSession().get(PastExecution.class, (Serializable)Long.valueOf(this.pastExecutionId));
        pe.putValue(name, this.convert(value));
        this.getSession().save((Object)pe);
    }

    public void delete(String name) {
        PastExecution pe = (PastExecution)this.getSession().get(PastExecution.class, (Serializable)Long.valueOf(this.pastExecutionId));
        pe.removeValue(name);
        this.getSession().save((Object)pe);
    }

    public void deleteAll() {
        PastExecution pe = (PastExecution)this.getSession().get(PastExecution.class, (Serializable)Long.valueOf(this.pastExecutionId));
        pe.removeAllData();
        this.getSession().save((Object)pe);
    }

    public void markDone() {
        PastExecution pe = (PastExecution)this.getSession().get(PastExecution.class, (Serializable)Long.valueOf(this.pastExecutionId));
        pe.removeAllData();
        pe.setFinished(true);
        this.getSession().save((Object)pe);
    }

    private Session getSession() {
        return HibernateContext.getContext().getCurrentSession();
    }

    private byte[] convert(Serializable obj) throws InvalidClassException, NotSerializableException {
        if (obj == null) {
            return null;
        }
        ObjectOutputStream oos = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            oos.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (InvalidClassException e) {
            throw e;
        }
        catch (NotSerializableException e) {
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private Serializable convert(byte[] blob) throws ClassNotFoundException {
        if (blob == null) {
            return null;
        }
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new ByteArrayInputStream(blob));
            Serializable serializable = (Serializable)ois.readObject();
            return serializable;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

