/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduler;

import com.ericsson.cms.scheduler.IScheduler;
import com.ericsson.cms.scheduler.IWOScheduler;
import com.tandbergtv.metadatamanager.customfield.CustomFieldDeleteCallbackException;
import com.tandbergtv.metadatamanager.customfield.ICustomFieldDeleteCallback;
import com.tandbergtv.metadatamanager.customfield.model.CustomField;
import com.tandbergtv.metadatamanager.customfield.model.CustomFieldGroup;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class SchedulerCustomFieldDeleteCallback
implements ICustomFieldDeleteCallback {
    private static final Logger logger = Logger.getLogger(SchedulerCustomFieldDeleteCallback.class);
    private static final String REFERENCE_PREFIX = "$";
    private static final String TITLE_METADATA_PREFIX = "Title Metadata.";

    public void beforeCustomFieldDelete(CustomField customField) throws CustomFieldDeleteCallbackException {
        String assetPath = customField.getGroup().getAssetPath();
        String schRuleParamValue = "$Title Metadata." + assetPath.replace('/', '.') + "." + customField.getFieldPath();
        logger.debug((Object)("schRuleParamValue : " + schRuleParamValue));
        List jobsWithSchRule = new ArrayList();
        List jobsWithJobParam = new ArrayList();
        try {
            jobsWithSchRule = this.getScheduler().getJobsSchRuleParamValueUsage(schRuleParamValue);
            logger.debug((Object)(jobsWithSchRule.size() + " use this custom field"));
            if (jobsWithSchRule.size() == 0) {
                String woJobParamValue = schRuleParamValue;
                jobsWithJobParam = this.getWOScheduler().getJobsWOJobParamValueUsage(woJobParamValue);
                logger.debug((Object)("Found " + jobsWithJobParam.size() + " that use this custom field as a job parameter"));
            }
        }
        catch (Exception e) {
            logger.error((Object)("Exception checking usage of custom field " + customField.getName() + " in Scheduler"), (Throwable)e);
            throw new CustomFieldDeleteCallbackException(e.getMessage());
        }
        if (jobsWithSchRule.size() > 0 || jobsWithJobParam.size() > 0) {
            StringBuilder jobNames = new StringBuilder();
            if (jobsWithSchRule.size() > 0) {
                for (String name : jobsWithSchRule) {
                    if (jobNames.length() > 0) {
                        jobNames.append(", ");
                    }
                    jobNames.append(name);
                }
            } else if (jobsWithJobParam.size() > 0) {
                for (String name : jobsWithJobParam) {
                    if (jobNames.length() > 0) {
                        jobNames.append(", ");
                    }
                    jobNames.append(name);
                }
            }
            String customFieldName = customField.getName();
            String customFieldGroupDisplayName = customField.getGroup() != null ? customField.getGroup().getDisplayName() : null;
            String customFieldAssetPath = customField.getGroup() != null ? customField.getGroup().getAssetPath() : null;
            String exceptionMessage = "Custom Field '" + customFieldName + "' in Custom Field Group '" + customFieldGroupDisplayName + "' for asset '" + customFieldAssetPath + "' cannot be deleted. It is used in the following Job(s): " + jobNames;
            logger.debug((Object)("exceptionMessage : " + exceptionMessage));
            throw new CustomFieldDeleteCallbackException(exceptionMessage);
        }
    }

    public void afterCustomFieldDelete(CustomField customField) throws CustomFieldDeleteCallbackException {
    }

    public void afterCustomFieldGroupDelete(CustomFieldGroup customFieldGroup) throws CustomFieldDeleteCallbackException {
    }

    private IScheduler getScheduler() {
        return (IScheduler)InjectionUtil.injectInstance((String)"/cms/Scheduler/local", IScheduler.class);
    }

    private IWOScheduler getWOScheduler() {
        return (IWOScheduler)InjectionUtil.injectInstance((String)"/cms/WOScheduler/local", IWOScheduler.class);
    }
}

