/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduler;

import com.ericsson.cms.scheduler.IScheduler;
import com.ericsson.cms.scheduler.IWOScheduler;
import com.ericsson.cms.scheduler.IWOSchedulerClient;
import com.ericsson.cms.scheduler.Node;
import com.ericsson.cms.scheduler.SchedulerException;
import com.ericsson.cms.scheduler.TitleMetadataOptionProvider;
import com.ericsson.cms.scheduler.WOSchedulerCallback;
import com.ericsson.cms.scheduler.entities.Job;
import com.ericsson.cms.scheduler.entities.TemplateVariable;
import com.ericsson.cms.scheduler.entities.WOJob;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.workflow.api.API;
import com.tandbergtv.workflow.api.Templates;
import com.tandbergtv.workflow.api.model.process.Template;
import com.tandbergtv.workflow.api.model.process.TemplateListResponse;
import com.tandbergtv.workflow.api.model.process.Variable;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.Session;

@Stateless
@TransactionAttribute
public class WOScheduler
implements IWOScheduler {
    private static final Logger logger = Logger.getLogger(WOScheduler.class);
    private static final String VAR_TITLEID = "titleId";
    private static final String VAR_PROVIDERID = "providerId";
    private static final int MAX_ASSOCIATION_DESCRIPTION_LENGTH = 2000;
    @EJB
    private IScheduler scheduler;

    public List<IWOSchedulerClient> getAllClients() {
        ArrayList<IWOSchedulerClient> clients = new ArrayList<IWOSchedulerClient>();
        ServiceLoader<IWOSchedulerClient> loader = ServiceLoader.load(IWOSchedulerClient.class);
        Iterator<IWOSchedulerClient> serviceIterator = loader.iterator();
        if (serviceIterator != null) {
            while (serviceIterator.hasNext()) {
                clients.add(serviceIterator.next());
            }
        }
        return clients;
    }

    public IWOSchedulerClient getClientByName(String name) {
        ServiceLoader<IWOSchedulerClient> loader = ServiceLoader.load(IWOSchedulerClient.class);
        Iterator<IWOSchedulerClient> serviceIterator = loader.iterator();
        if (serviceIterator != null) {
            while (serviceIterator.hasNext()) {
                IWOSchedulerClient service = serviceIterator.next();
                if (!service.getName().equals(name)) continue;
                return service;
            }
        }
        throw new SchedulerException("No workorder scheduler client found with name: " + name);
    }

    public List<Node> getParametersForFilter(String clientName) {
        IWOSchedulerClient client = this.getClientByName(clientName);
        List filterParams = client.getParametersForFilter();
        return filterParams != null ? filterParams : new ArrayList(0);
    }

    public List<Node> getParametersForWorkOrderMapping(String clientName, boolean associatedWithTitles) {
        ArrayList<Node> allNodes = new ArrayList<Node>();
        IWOSchedulerClient client = this.getClientByName(clientName);
        List woParams = client.getParametersForWorkOrderMapping(associatedWithTitles);
        if (woParams != null) {
            allNodes.addAll(woParams);
        }
        if (associatedWithTitles) {
            allNodes.add(new TitleMetadataOptionProvider().getJobParameterMenuOptions());
        }
        Node general = new Node("General");
        general.addChild(new Node("Job Execution Date"));
        allNodes.add(general);
        return allNodes;
    }

    public List<String> getTemplates(boolean associatedWithTitles) {
        ArrayList<String> templateNames = new ArrayList<String>();
        for (Template template : this.getTemplatesList(associatedWithTitles)) {
            templateNames.add(template.getName());
        }
        Collections.sort(templateNames);
        return templateNames;
    }

    private Collection<Template> getTemplatesList(boolean titleTemplatesOnly) {
        ArrayList<Template> templates = new ArrayList();
        try {
            templates = this.getTemplateList(titleTemplatesOnly);
        }
        catch (IOException e) {
            logger.warn((Object)"Failed to get templates", (Throwable)e);
        }
        return templates;
    }

    private Template getTemplate(String templateName, boolean associatedWithTitles) {
        for (Template template : this.getTemplatesList(associatedWithTitles)) {
            if (!templateName.equals(template.getName())) continue;
            try {
                if ((template = this.getTemplate(template.getId())) == null) continue;
                return template;
            }
            catch (IOException e) {
                logger.warn((Object)("Failed to get template: " + templateName), (Throwable)e);
            }
        }
        throw new SchedulerException("No template found with name: " + templateName);
    }

    public List<TemplateVariable> getTemplateStartParamNames(String templateName, boolean associatedWithTitles) {
        ArrayList<TemplateVariable> templateVariables = new ArrayList<TemplateVariable>();
        Template matchedTemplate = this.getTemplate(templateName, associatedWithTitles);
        boolean titleIdVariablePresent = false;
        for (Variable variable : matchedTemplate.getVariables()) {
            TemplateVariable templateVariable = new TemplateVariable(variable.getName(), variable.getDisplayname(), variable.getRequired().booleanValue());
            if (VAR_TITLEID.equals(variable.getName())) {
                titleIdVariablePresent = true;
                if (associatedWithTitles) {
                    templateVariable.setAutoMapped(true);
                }
            }
            templateVariables.add(templateVariable);
        }
        if (titleIdVariablePresent) {
            Iterator iter = templateVariables.iterator();
            while (iter.hasNext()) {
                TemplateVariable tv = (TemplateVariable)iter.next();
                if (!tv.getName().equals(VAR_PROVIDERID)) continue;
                iter.remove();
            }
        }
        Collections.sort(templateVariables, new Comparator<TemplateVariable>(){

            @Override
            public int compare(TemplateVariable o1, TemplateVariable o2) {
                return o1.isRequired() ? -1 : 1;
            }
        });
        return templateVariables;
    }

    public WOJob getSchedule(long id) {
        WOJob woJob = this.get(id);
        this.fillWithJobInfo(woJob);
        return woJob;
    }

    public WOJob getScheduleByJobId(long jobId) {
        WOJob woJob = null;
        Job job = this.scheduler.get(jobId);
        if (job != null) {
            woJob = this.getScheduleByJobIdInternal(jobId);
        }
        return woJob;
    }

    public WOJob getScheduleByJobIdInternal(long jobId) {
        String queryStr = "from WOJob where jobId = :jobId";
        Query query = this.getSession().createQuery(queryStr);
        query.setParameter("jobId", (Object)jobId);
        WOJob woJob = (WOJob)query.uniqueResult();
        if (woJob != null) {
            this.fillWithJobInfoInternal(woJob);
        }
        return woJob;
    }

    public List<WOJob> getSchedulesByAssociatedEntityType(String entityType) {
        ArrayList<WOJob> woJobs = new ArrayList<WOJob>();
        List jobs = this.scheduler.getJobsByAssociatedEntityType(entityType);
        for (Job job : jobs) {
            WOJob woJob = this.getScheduleByJobId(job.getId());
            if (woJob == null) continue;
            woJobs.add(woJob);
        }
        return woJobs;
    }

    public List<WOJob> getSchedulesByAssociatedEntity(String entityType, long entityId) {
        ArrayList<WOJob> woJobs = new ArrayList<WOJob>();
        List jobs = this.scheduler.getJobsByAssociatedEntity(entityType, entityId);
        for (Job job : jobs) {
            WOJob woJob = this.getScheduleByJobId(job.getId());
            if (woJob == null) continue;
            woJobs.add(woJob);
        }
        return woJobs;
    }

    public WOJob schedule(WOJob woJob) {
        boolean create = woJob.getId() == null;
        WOJob dbWOJob = null;
        Job job = new Job();
        if (!create) {
            dbWOJob = this.get(woJob.getId());
            job.setId(dbWOJob.getJobId());
            dbWOJob.setTemplateName(woJob.getTemplateName());
            dbWOJob.setPriority(woJob.getPriority());
            dbWOJob.setWoMappingParams(woJob.getWoMappingParams());
        }
        job.setRule(woJob.getRule());
        job.setName(woJob.getName());
        job.setAssociatedEntityType(woJob.getAssociatedEntityType());
        job.setAssociatedEntities(woJob.getAssociatedEntities());
        this.setAssociationDescription(job);
        job.setCallbackClass(WOSchedulerCallback.class);
        this.scheduler.schedule(job);
        if (create) {
            woJob.setJobId(job.getId());
            this.getSession().saveOrUpdate((Object)woJob);
            this.copyJobPropertiesToWOJob(woJob, job);
            return woJob;
        }
        this.getSession().saveOrUpdate((Object)dbWOJob);
        this.copyJobPropertiesToWOJob(dbWOJob, job);
        return dbWOJob;
    }

    public void setScheduleActive(long woJobId, boolean active) {
        WOJob woJob = this.get(woJobId);
        this.scheduler.setActive(woJob.getJobId().longValue(), active);
    }

    public void setSchedulesActive(Set<Long> woJobIds, boolean active) {
        if (woJobIds != null) {
            for (Long woJobId : woJobIds) {
                if (woJobId == null) continue;
                this.setScheduleActive(woJobId, active);
            }
        }
    }

    public void dissociate(long woJobId, long entityId) {
        WOJob woJob = this.getSchedule(woJobId);
        if (!("SELF".equals(woJob.getAssociatedEntityType()) || woJob.getAssociatedEntities() != null && woJob.getAssociatedEntities().contains(entityId))) {
            throw new SchedulerException("The Schedule is not associated with the given entity");
        }
        if (woJob.getAssociatedEntities().size() > 1) {
            this.scheduler.dissociate(woJob.getJobId().longValue(), entityId);
            Job job = this.scheduler.get(woJob.getJobId().longValue());
            this.setAssociationDescription(job);
        } else {
            this.deleteSchedule(woJobId);
        }
    }

    public void deleteSchedule(long id) {
        WOJob woJob = this.get(id);
        this.getSession().delete((Object)woJob);
        this.scheduler.delete(woJob.getJobId().longValue());
    }

    public void deleteSchedules(Set<Long> woJobIds) {
        if (woJobIds != null) {
            for (Long woJobId : woJobIds) {
                if (woJobId == null) continue;
                this.deleteSchedule(woJobId);
            }
        }
    }

    public List<String> getJobsWOJobParamValueUsage(String woJobParamValue) {
        String queryStr = "select distinct job.name from WOJob wojob, Job job  where :wojobMapParamValue in elements(wojob.woMappingParams) and wojob.jobId = job.id";
        logger.debug((Object)("queryStr: " + queryStr));
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("wojobMapParamValue", (Object)woJobParamValue);
        return query.list();
    }

    private WOJob get(long id) {
        WOJob woJob = (WOJob)this.getSession().get(WOJob.class, (Serializable)Long.valueOf(id));
        if (woJob == null) {
            throw new SchedulerException("No workorder job found with id: " + id);
        }
        return woJob;
    }

    private void fillWithJobInfo(WOJob woJob) {
        Job job = this.scheduler.get(woJob.getJobId().longValue());
        this.copyJobPropertiesToWOJob(woJob, job);
    }

    private void fillWithJobInfoInternal(WOJob woJob) {
        Job job = this.scheduler.getInternal(woJob.getJobId().longValue());
        this.copyJobPropertiesToWOJob(woJob, job);
    }

    private void copyJobPropertiesToWOJob(WOJob woJob, Job job) {
        woJob.setName(job.getName());
        woJob.setRule(job.getRule());
        woJob.setAssociatedEntityType(job.getAssociatedEntityType());
        woJob.setAssociatedEntities(job.getAssociatedEntities());
        woJob.setActive(job.isActive());
    }

    private void setAssociationDescription(Job job) {
        IWOSchedulerClient woSchedulerClient = this.getClientByName(job.getAssociatedEntityType());
        ArrayList associatedEntityIds = new ArrayList();
        associatedEntityIds.addAll(job.getAssociatedEntities());
        String associationDescription = woSchedulerClient.getAssociationDescription(associatedEntityIds);
        if (associationDescription != null) {
            if (associationDescription.length() > 2000) {
                associationDescription = associationDescription.substring(0, 2000);
            }
            job.setAssociationDescription(associationDescription);
        }
    }

    private Session getSession() {
        return HibernateContext.getContext().getCurrentSession();
    }

    private List<Template> getTemplateList(boolean titleTemplates) throws IOException {
        Templates request = this.request();
        if (titleTemplates) {
            request.query().filter(VAR_TITLEID).count(100);
        } else {
            request.query().count(100);
        }
        return request.execute().getItems();
    }

    private Template getTemplate(String id) throws IOException {
        Templates request = this.request();
        request.query().id(id);
        TemplateListResponse response = request.execute();
        if (response.getItems().isEmpty()) {
            return null;
        }
        return (Template)response.getItems().get(0);
    }

    private Templates request() {
        return new API.Builder().build().templates();
    }
}

