/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduler.conf;

import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.neptune.util.InjectionUtil;
import org.apache.log4j.Logger;

public class SchedulerPropertiesReader {
    private static final String SCHEDULER_PROPERTIES_GROUP_NAME = "com.ericsson.cms.scheduler";
    private static final String PROPERTY_NAME_LOOKUP_PERIOD_DAYS = "scheduler.nextnjobs.lookupPeriodDays";
    private static final String PROPERTY_NAME_MAX_LOOKUPS = "scheduler.nextnjobs.maxLookups";
    private static final String PROPERTY_NAME_DELAY_SENDING_REQUEST = "scheduler.createWorkOrders.throttling";
    private static final int DEFAULT_DELAY_SENDING_REQUEST = 1;
    private static final int DEFAULT_LOOKUP_PERIOD_DAYS = 30;
    private static final int DEFAULT_MAX_LOOKUPS = 12;
    private static final Logger logger = Logger.getLogger(SchedulerPropertiesReader.class);

    public static int getLookupPeriodDays() {
        int lookupPeriodDays = 30;
        try {
            lookupPeriodDays = Integer.parseInt(((String)SchedulerPropertiesReader.getConfigurationService().getProperties(SCHEDULER_PROPERTIES_GROUP_NAME).get(PROPERTY_NAME_LOOKUP_PERIOD_DAYS)).trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return lookupPeriodDays;
    }

    public static int getMaxLookups() {
        int maxLookups = 12;
        try {
            maxLookups = Integer.parseInt(((String)SchedulerPropertiesReader.getConfigurationService().getProperties(SCHEDULER_PROPERTIES_GROUP_NAME).get(PROPERTY_NAME_MAX_LOOKUPS)).trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return maxLookups;
    }

    public static int getWorkOrderDelayTimeInMilliSeconds() {
        int delayTimeInSeconds = 1;
        try {
            delayTimeInSeconds = Integer.parseInt(((String)SchedulerPropertiesReader.getConfigurationService().getProperties(SCHEDULER_PROPERTIES_GROUP_NAME).get(PROPERTY_NAME_DELAY_SENDING_REQUEST)).trim());
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get workOrders Per Minute property. Using the default value ", (Throwable)e);
        }
        return delayTimeInSeconds * 1000;
    }

    private static IConfigurationService getConfigurationService() {
        String jndiName = "cms/ConfigurationService/local";
        return (IConfigurationService)InjectionUtil.injectInstance((String)jndiName, IConfigurationService.class);
    }
}

